/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[]="$Id: CollectionDepotConf_AppendGlobalDepotConf.c,v 1.4 1994/08/12 13:45:01 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "DepotConf.h"


static DEPOTCONFDB *CollectionDepotConfDB_PurgeCommand();
static DEPOTCONFDB *CollectionDepotConfDB_AppendItem();


static DEPOTCONFDB *CollectionDepotConfDB_PurgeCommand(confdbp, commandlabel)
     DEPOTCONFDB *confdbp;
     char *commandlabel;
{
  register int i;
  register DEPOTCONF **fp, **tp;

  DEPOTCONFDB *newconfdbp;
  int confdbsize, ndeletions;

  newconfdbp = confdbp;
  if ((newconfdbp != NULL) && (*newconfdbp != NULL))
    {
      confdbsize = DepotConfDB_Size(newconfdbp) + 1;
      i = 0; fp = *confdbp; tp = fp; ndeletions = 0;
      while ((PROGRAM_ErrorNo == E_NULL)
	     && (i < (confdbsize-1)) && (*fp != NULL))
	{
	  if ((DEPOTCONF_Spec(*fp) & DC_COMMAND)
	      && (DEPOTCONF_ConfValue(*fp) != NULL)
	      && (STRINGARRAY_Size(DEPOTCONF_ConfValue(*fp)) > 0)
	      && (String_Comparator
		  (commandlabel,
		   STRINGARRAY_String(DEPOTCONF_ConfValue(*fp), 0)) == 0))
	    {
	      /* $$$FREE$$$ */
	      /* DepotConf_Free(*fp); */
	      *fp = NULL;
	      ndeletions++; fp++;
	    }
	  else
	    {
	      if (ndeletions > 0)
		*tp = *fp;
	      fp++, tp++;
	    }
	  i++;
	}

      if ((PROGRAM_ErrorNo == E_NULL) && (ndeletions > 0))
	{
	  *tp = NULL;
	  confdbsize -= ndeletions;
	  *newconfdbp =
	    (DEPOTCONFDB)erealloc((void *)*newconfdbp,
				  (unsigned)confdbsize * sizeof(DEPOTCONF *));
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newconfdbp : NULL;  
}


static DEPOTCONFDB *CollectionDepotConfDB_AppendItem(confdbp, confitemp)
     DEPOTCONFDB *confdbp;
     DEPOTCONF *confitemp;
{
  register DEPOTCONF **cdp;

  DEPOTCONFDB *newconfdbp;
  int confdbsize;

  if (confdbp == NULL)
    { /* allocate array of length 1 */
      newconfdbp
	= (DEPOTCONFDB *)emalloc(sizeof(DEPOTCONFDB));
      if (PROGRAM_ErrorNo == E_NULL)
	*newconfdbp
	  = (DEPOTCONFDB)emalloc(sizeof(DEPOTCONF *));
      if (PROGRAM_ErrorNo == E_NULL)
	**newconfdbp = NULL;
    }
  else
    newconfdbp = confdbp;

  if (PROGRAM_ErrorNo == E_NULL)
    {
      if (!(DEPOTCONF_Spec(confitemp) & DC_DELETECOMMAND))
	{
	  confdbsize = DepotConfDB_Size(newconfdbp) + 1;
	  confdbsize++;
	  *newconfdbp =
	    (DEPOTCONFDB)erealloc((void *)*newconfdbp,
				  (unsigned)confdbsize * sizeof(DEPOTCONF *));

	  if (PROGRAM_ErrorNo == E_NULL)
	    {
	      cdp = *newconfdbp + confdbsize - 2;
	      *cdp = (DEPOTCONF *)emalloc(sizeof(DEPOTCONF));
	      if (*cdp != NULL)
		{
		  DEPOTCONF_CollectionName(*cdp)
		    = String(DEPOTCONF_CollectionName(confitemp),
			     strlen(DEPOTCONF_CollectionName(confitemp)));
		  DEPOTCONF_Spec(*cdp) = DEPOTCONF_Spec(confitemp);
		  DEPOTCONF_ConfValue(*cdp) =
		    StringArray
		      (DEPOTCONF_ConfValue(confitemp),
		       StringArray_Size(DEPOTCONF_ConfValue(confitemp)));
		}
	      *(cdp+1) = NULL;
	    }
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newconfdbp : NULL;
}



DEPOTCONFDB *CollectionDepotConf_AppendGlobalDepotConf(confdbp,
						       globalconfdbp,
						       collection_name)
     DEPOTCONFDB *confdbp, *globalconfdbp;
     char *collection_name;
{
  register DEPOTCONF **dp;

  DEPOTCONFDB *newconfdbp;

  newconfdbp = confdbp;

  if ((globalconfdbp != NULL) && (*globalconfdbp != NULL))
    {
      dp = *globalconfdbp;

      while ((*dp != NULL) && (PROGRAM_ErrorNo == E_NULL))
	{
	  if ((String_Comparator(DEPOTCONF_CollectionName(*dp),
				 collection_name) == 0)
	      || (String_Comparator(DEPOTCONF_CollectionName(*dp),
				    DEPOTCONF_WILDITEM) == 0)
	      || (String_Comparator(collection_name,
				    DEPOTCONF_WILDITEM) == 0))
	    {
	      if (PROGRAM_ErrorNo == E_NULL)
		{
		  if (DEPOTCONF_Spec(*dp) & DC_DELETECOMMAND)
		    {
		      if (DEPOTCONF_ConfValue(*dp) == NULL)
			{
			  FatalError
			    (E_BADDEPOTCONFVALUE,
			     "NULL value in depotconf spec to deletecommand\n");
			}
		      else if (STRINGARRAY_Size(DEPOTCONF_ConfValue(*dp)) <= 0)
			{
			  FatalError
			    (E_BADDEPOTCONFVALUE,
			     "No label in depotconf spec to deletecommand\n");
			}
		      else if (STRINGARRAY_String(DEPOTCONF_ConfValue(*dp), 0)
			       == NULL)
			{
			  FatalError(E_BADDEPOTCONFCOMMAND,
				     "Attempt to remove NULL command.\n");
			}
		      else
			newconfdbp =
			  CollectionDepotConfDB_PurgeCommand
			    (newconfdbp,
			     STRINGARRAY_String(DEPOTCONF_ConfValue(*dp), 0));
		    }
		  else
		    {
		      newconfdbp = CollectionDepotConfDB_AppendItem(newconfdbp,
								    *dp);
		    }
		}
	    }
	  dp++;
	}
    }

  return (PROGRAM_ErrorNo == E_NULL) ? newconfdbp : NULL;
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/DepotConf/RCS/CollectionDepotConf_AppendGlobalDepotConf.c,v $ */
