/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
static char rcs_id[] = "$Id: Command_Run.c,v 1.6 1994/08/13 04:32:57 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */

#include "depotlib.h"

#include "util.h"
#include "DepotErrorCodes.h"
#include "Command.h"



void 
Command_Run(commandp)
     COMMAND *commandp;
{
  pid_t pid;
#ifdef HAVE_UNION_WAIT
  union wait ExecStatus;
#else
  pid_t ExecStatus;
#endif

  if (COMMAND_Args(commandp) == NULL) {
    FatalError(E_NOEXECFILE,
	       "No executable file found for label %s\n",
	       COMMAND_Label(commandp));
  }
  if (PROGRAM_ErrorNo == E_NULL) {
    pid = vfork();
    if (pid < 0) {
      FatalError(E_VFORKFAILED,
		 "Could not execute %s; vfork failed\n",
		 *COMMAND_Args(commandp));
    } else if (pid == 0) {	/* child */
      char *path;
      
      path = STRINGARRAY_String(COMMAND_Args(commandp), 0);

      execv(path, STRINGARRAY_Values(COMMAND_Args(commandp)));
      FatalError(E_EXECFAILED,"Child failed to exec %s: %s\n", path,
		 strerror(errno));
      _exit(-1);
    }
    wait(&ExecStatus);

    if (WEXITSTATUS(ExecStatus) != 0) {
      FatalError(E_EXECFAILED,
		 "Execution of %s failed with exit status = %d\n",
		 COMMAND_Label(commandp), WEXITSTATUS(ExecStatus));
    }
  }
  return;
}

/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/lib/Command/RCS/Command_Run.c,v $ */
