/***********************************************************
        Copyright 1991,1994 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/


#ifndef SABER
#ifndef LINT
  static char rcs_id[]="$Id: fsi_generate.c,v 1.4 1994/08/13 04:16:01 ww0r Exp $";
#endif /* LINT */
#endif /* SABER */

/*
 * Author: Sohan C. Ramakrishna Pillai
 */


#include <stdio.h>

#include "depotlib.h"
#include "util.h"
#include "DepotErrorCodes.h"
#include "FileSystemImage.h"

static char VersionString[] = "fsi_generate: $Revision: 1.4 $ $Date: 1994/08/13 04:16:01 $";
static char *UsageString[] =
{
  "fsi_generate pathname",
  "fsi_generate -help",
};
static unsigned NOptions = sizeof(UsageString)/sizeof(UsageString[0]);

void Usage(fp)
  FILE *fp;
{
  register char **up;
  register unsigned i;

  (void)fprintf(fp,"%s\n", VersionString);
  (void)fprintf(fp,"%s\n", getversion_libdepot());
  for (i = 0, up = UsageString; i < NOptions; i++, up++)
    { fputs("\t", fp); fputs(*up, fp); fputs("\n", fp); }
}

main(argc, argv)
    int argc;
    char **argv;
{
    FILE *out = stdout;

    if (argc != 2)
      {
	FatalError(E_USAGE,
		   "Error on command line: wrong number of arguments\n");
      }
    else /* argc == 2 */
      {
	if (strcmp(argv[1], "-help") == 0)
	  Usage(stdout);
	else
	  {
	    FileSystemImage_Write(out, FileSystemImage_Build(argv[1]));
	  }
      }

    if (PROGRAM_ErrorNo == E_USAGE)
      Usage(stderr);

    exit(PROGRAM_ErrorNo);
}
/* $Source: /afs/andrew.cmu.edu/system/src/local/depot2/011/src/cmd/fsi_generate/RCS/fsi_generate.c,v $ */

