.\"
.\" $Header: /afs/andrew.cmu.edu/system/src/local/depot2/020/man/man5/RCS/depot.conf.man,v 2.1 1995/04/27 19:00:56 ww0r Exp $
.\"        Copyright 1991,1994 by Carnegie Mellon University
.\"
.\"                      All Rights Reserved
.\"
.\"Permission to use, copy, modify, and distribute this software and its
.\"documentation for any purpose and without fee is hereby granted,
.\"provided that the above copyright notice appear in all copies and that
.\"both that copyright notice and this permission notice appear in
.\"supporting documentation, and that the name of CMU not be
.\"used in advertising or publicity pertaining to distribution of the
.\"software without specific, written prior permission.
.\"
.\"CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
.\"ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
.\"CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
.\"ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
.\"WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
.\"ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
.\"SOFTWARE.
.\"
.\"
.\" Author: Sohan C. Ramakrishna Pillai
.\"
.TH DEPOT.CONF 5 "29 Jun 1993"
.SH NAME
depot.conf \- depot collection configuration options
.SH SYNOPSIS
.B [collectiondir]/depot.conf
.br
.B [targetdir]/depot/depot.conf

.SH DESCRIPTION
The file, \fIdepot.conf\fR, specifies how the contents of a
collection are to be mapped onto the target directory,
\fI[targetdir]\fP by \fBdepot\fP(1). The \fIdepot.conf\fP file is
optional and \fBdepot\fP(1) may be run with out it.
.PP
The \fIdepot.conf\fR can exist in the top level of the collection as
well as in the \fIdepot\fR directory of the environment. If there is a
\fIdepot.conf\fR in the \fIdepot\fR directory, then the information in
this file takes precedence over any \fIdepot.conf\fR found in any
collection.
.PP
Each line in the collection \fIdepot.conf\fP may be a comment, a
special specification entry termed a tilde-specification, or a mapping
specification.  Specifications are sequentially processed and later
specifications may override the effects of earlier specifications.
.PP
Lines in \fIdepot.conf\fP starting with a # are treated as comments
and are ignored by \fBdepot\fP(1).  
.PP
Lines in \fIdepot.conf\fP starting with a ~ are treated as
tilde-specifications. \fBDepot\fP(1) recognizes the following
tilde-specifcations:
.PP
.TP 8
~delete \fIpath\fP
prevents the specified path from being mapped by any earlier
specification. A  / should be used to specify the top level
of the \fIcollectiondir\fP. All other paths specified must
be relative to \fIcollectiondir\fP.
.PP
.TP 8
~command \fIlabel outputfilelist\fP 
causes \fBdepot\fP(1) to execute the command specified by the label at
the end of all other operations. This creates the specified output
files.The \fIoutputfilelist\fP is the only way, other than marking a
file "special", for a generated file to be recognized or mapped by
\fBdepot\fP. The command to be executed should be specified using the
\fIcommand\fR resource in the environment customization
file,\fIdepot.pref\fP(5).  The \fIoutputfilelist\fP must be a list of
pathnames relative to \fItargetdir\fP and each of the pathnames should
be separated by a whitespace.
.PP
.PP
Mapping entries specify what should be  exported from the collection
directory to the target directory. Mapping entries may also
specify that files and directories in the collection directory should
actually appear in a different location in the target directory.
Mapping entries are one on each line of the form
.sp 1
.ce 3
\fIfrompath topath\fP
or
\fIpath\fP
.sp 1
The second form is equivalent to a mapping specification of
.sp 1
.ce 1
\fIpath path\fP
.sp 1
and is used for brevity.  A / should be used to specify the top level
of the \fIcollectiondir\fP as the \fIfrompath\fR for mapping. All
other \fIfrompath\fRs specified must be relative to
\fIcollectiondir\fP. Similarly, a / should be used to specify the top
level of the \fItargetdir\fP as the \fItopath\fR for mapping.  All
other \fItopath\fRs specified must be relative to \fItargetdir\fP.
The specification
.sp 1
.ce 1
\fIfrompath topath\fP
.sp 1
causes \fBdepot\fP(1) to map the contents of
\fIcollectiondir/frompath\fP to \fItargetdir/topath\fP. If a
collection does not have a \fIdepot.conf\fR, the default is to map
everything in the collection. e.g.
.sp 1
.ce
/	/
.sp 1

.PP
The global \fIdepot.conf\fP provides a method for the environment
maintainer to customize the environment, even overrriding the
\fIdepot.conf\fP's in the collections. This file resides in the
\fBdepot\fP directory. The syntax of \fIglobal depot.conf\fP is the
same as for the collection \fIdepot.conf\fP except that each entry
applies to a specific collection and therefore  the name of the collection
is the first argument to any global \fIdepot.conf\fR
specification. The use of a global \fIdepot.conf\fR automatically
creates the '/' mapping. 

.SH EXAMPLE
.PP
An example of  how \fBdepot\fP(1)  maps files would be:
.PP 
.I usr/local		/
.PP
In this case, all the files under the usr/local directory will be
mapped to /, the top level environment. This makes it seem as though
all the files and directories under \fIusr/local\fR are actulally two
levels up.
.PP
A sample use of the global \fIdepot.conf\fR is to change the mapping
of the \fIfoo\fP collection, the \fIglobal depot.conf\fP woud be:
.PP
	\fI foo     bin     lib/log\fR
.br
	\fI foo     ~delete bin\fR
.PP
This would take the files in \fIbin\fP and \fIfoo\fP and map them into
\fIlib/log\fP and the \fI~delete\fP would keep the \fIbin\fR directory
and any files from the \fIfoo\fR collection from being mapped into the
target directory.

.SH AUTHOR
Sohan C. Ramakrishna-Pillai

.SH "SEE ALSO"
depot(1), depot.pref(5)
