/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist.impl;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SEnvironment;
import com.sleepycat.client.SForeignKeyDeleteAction;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryConfig;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.SSequence;
import com.sleepycat.client.SSequenceConfig;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.tuple.StringBinding;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.DatabaseNamer;
import com.sleepycat.client.persist.IndexNotAvailableException;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.SecondaryIndex;
import com.sleepycat.client.persist.StoreConfig;
import com.sleepycat.client.persist.StoreExistsException;
import com.sleepycat.client.persist.StoreNotFoundException;
import com.sleepycat.client.persist.evolve.EvolveConfig;
import com.sleepycat.client.persist.evolve.EvolveEvent;
import com.sleepycat.client.persist.evolve.EvolveInternal;
import com.sleepycat.client.persist.evolve.EvolveListener;
import com.sleepycat.client.persist.evolve.EvolveStats;
import com.sleepycat.client.persist.evolve.IncompatibleClassException;
import com.sleepycat.client.persist.evolve.Mutations;
import com.sleepycat.client.persist.impl.Catalog;
import com.sleepycat.client.persist.impl.ComplexFormat;
import com.sleepycat.client.persist.impl.CompositeKeyFormat;
import com.sleepycat.client.persist.impl.Format;
import com.sleepycat.client.persist.impl.PersistCatalog;
import com.sleepycat.client.persist.impl.PersistEntityBinding;
import com.sleepycat.client.persist.impl.PersistKeyAssigner;
import com.sleepycat.client.persist.impl.PersistKeyBinding;
import com.sleepycat.client.persist.impl.PersistKeyCreator;
import com.sleepycat.client.persist.impl.RefreshException;
import com.sleepycat.client.persist.impl.SimpleCatalog;
import com.sleepycat.client.persist.model.DeleteAction;
import com.sleepycat.client.persist.model.EntityMetadata;
import com.sleepycat.client.persist.model.EntityModel;
import com.sleepycat.client.persist.model.PrimaryKeyMetadata;
import com.sleepycat.client.persist.model.Relationship;
import com.sleepycat.client.persist.model.SecondaryKeyMetadata;
import com.sleepycat.client.persist.raw.RawObject;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import com.sleepycat.client.util.keyrange.KeyRange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class Store {
    public static final String NAME_SEPARATOR = "#";
    private static final String NAME_PREFIX = "persist#";
    private static final String DB_NAME_PREFIX = "com.sleepycat.client.persist.";
    private static final String CATALOG_DB = "com.sleepycat.client.persist.formats";
    private static final String SEQUENCE_DB = "com.sleepycat.client.persist.sequences";
    private static Map<SEnvironment, Map<String, PersistCatalog>> catalogPool = new WeakHashMap<SEnvironment, Map<String, PersistCatalog>>();
    private static SyncHook syncHook;
    public static boolean expectFlush;
    private final SEnvironment env;
    private final boolean rawAccess;
    private volatile PersistCatalog catalog;
    private EntityModel model;
    private final StoreConfig storeConfig;
    private final String storeName;
    private final String storePrefix;
    private final Map<String, InternalPrimaryIndex> priIndexMap;
    private final Map<String, InternalSecondaryIndex> secIndexMap;
    private final Map<String, SDatabaseConfig> priConfigMap;
    private final Map<String, SSecondaryConfig> secConfigMap;
    private final Map<String, PersistKeyBinding> keyBindingMap;
    private SDatabase sequenceDb;
    private final Map<String, SSequence> sequenceMap;
    private final Map<String, SSequenceConfig> sequenceConfigMap;
    private final IdentityHashMap<SDatabase, Object> deferredWriteDatabases;
    private final Map<String, Set<String>> inverseRelatedEntityMap;
    private final STransactionConfig autoCommitTxnConfig;
    private final STransactionConfig autoCommitNoWaitTxnConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store(SEnvironment sEnvironment, String string, StoreConfig storeConfig, boolean bl) throws StoreExistsException, StoreNotFoundException, IncompatibleClassException, SDatabaseException {
        ArrayList<Format> arrayList;
        this.env = sEnvironment;
        this.storeName = string;
        this.rawAccess = bl;
        if (sEnvironment == null || string == null) {
            throw new NullPointerException("env and storeName parameters must not be null");
        }
        this.storeConfig = storeConfig != null ? storeConfig.clone() : StoreConfig.DEFAULT;
        this.autoCommitTxnConfig = new STransactionConfig();
        this.autoCommitNoWaitTxnConfig = new STransactionConfig();
        this.autoCommitNoWaitTxnConfig.setNoWait(true);
        this.model = storeConfig.getModel();
        this.storePrefix = NAME_PREFIX + string + NAME_SEPARATOR;
        this.priIndexMap = new HashMap<String, InternalPrimaryIndex>();
        this.secIndexMap = new HashMap<String, InternalSecondaryIndex>();
        this.priConfigMap = new HashMap<String, SDatabaseConfig>();
        this.secConfigMap = new HashMap<String, SSecondaryConfig>();
        this.keyBindingMap = new HashMap<String, PersistKeyBinding>();
        this.sequenceMap = new HashMap<String, SSequence>();
        this.sequenceConfigMap = new HashMap<String, SSequenceConfig>();
        this.deferredWriteDatabases = new IdentityHashMap();
        if (bl) {
            if (this.model != null) {
                throw new IllegalArgumentException("A model may not be specified when opening a RawStore");
            }
            arrayList = new SDatabaseConfig();
            ((SDatabaseConfig)((Object)arrayList)).setReadOnly(true);
            this.catalog = new PersistCatalog(sEnvironment, this.storePrefix, this.storePrefix + CATALOG_DB, (SDatabaseConfig)((Object)arrayList), null, storeConfig.getMutations(), bl, this);
        } else {
            arrayList = catalogPool;
            synchronized (arrayList) {
                Object object = catalogPool.get(sEnvironment);
                if (object == null) {
                    object = new HashMap<String, PersistCatalog>();
                    catalogPool.put(sEnvironment, (Map<String, PersistCatalog>)object);
                }
                this.catalog = object.get(string);
                if (this.catalog != null) {
                    this.catalog.openExisting();
                } else {
                    SDatabaseConfig object2 = new SDatabaseConfig();
                    object2.setAllowCreate(this.storeConfig.getAllowCreate());
                    object2.setExclusiveCreate(this.storeConfig.getExclusiveCreate());
                    object2.setReadOnly(this.storeConfig.getReadOnly());
                    DbCompat.setTypeBtree(object2);
                    this.catalog = new PersistCatalog(sEnvironment, this.storePrefix, this.storePrefix + CATALOG_DB, object2, this.model, storeConfig.getMutations(), bl, this);
                    object.put(string, this.catalog);
                }
            }
        }
        this.model = this.catalog.getResolvedModel();
        this.inverseRelatedEntityMap = new HashMap<String, Set<String>>();
        arrayList = new ArrayList<Format>();
        this.catalog.getEntityFormats(arrayList);
        for (Format format : arrayList) {
            EntityMetadata entityMetadata = format.getEntityMetadata();
            for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string2 = secondaryKeyMetadata.getRelatedEntity();
                if (string2 == null) continue;
                Set<String> set = this.inverseRelatedEntityMap.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.inverseRelatedEntityMap.put(string2, set);
                }
                set.add(entityMetadata.getClassName());
            }
        }
    }

    public SEnvironment getEnvironment() {
        return this.env;
    }

    public StoreConfig getConfig() {
        return this.storeConfig.clone();
    }

    public String getStoreName() {
        return this.storeName;
    }

    public boolean isReplicaUpgradeMode() {
        return this.catalog.isReplicaUpgradeMode();
    }

    public EntityModel getModel() {
        return this.model;
    }

    public Mutations getMutations() {
        return this.catalog.getMutations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> clazz, String string, Class<E> clazz2, String string2) throws SDatabaseException, IndexNotAvailableException {
        assert (this.rawAccess && clazz2 == RawObject.class || !this.rawAccess && clazz2 != RawObject.class);
        assert (this.rawAccess && string == null || !this.rawAccess && string != null);
        this.checkOpen();
        InternalPrimaryIndex<PK, E> internalPrimaryIndex = this.priIndexMap.get(string2);
        if (internalPrimaryIndex == null) {
            Object object;
            EntityMetadata entityMetadata = this.checkEntityClass(string2);
            PrimaryKeyMetadata primaryKeyMetadata = entityMetadata.getPrimaryKey();
            if (string == null) {
                string = primaryKeyMetadata.getClassName();
            } else {
                object = SimpleCatalog.keyClassName(primaryKeyMetadata.getClassName());
                if (!string.equals(object)) {
                    throw new IllegalArgumentException("Wrong primary key class: " + string + " Correct class is: " + (String)object);
                }
            }
            object = new PersistEntityBinding(this.catalog, string2, this.rawAccess);
            PersistKeyBinding persistKeyBinding = this.getKeyBinding(string);
            String string3 = primaryKeyMetadata.getSequenceName();
            if (!this.storeConfig.getReadOnly() && string3 != null) {
                ((PersistEntityBinding)object).keyAssigner = new PersistKeyAssigner(persistKeyBinding, (PersistEntityBinding)object, this.getSequence(string3));
            }
            STransaction sTransaction = null;
            SDatabaseConfig sDatabaseConfig = this.getPrimaryConfig(entityMetadata);
            if (sDatabaseConfig.getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                sTransaction = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
            }
            PrimaryOpenState primaryOpenState = new PrimaryOpenState(string2);
            boolean bl = sDatabaseConfig.getAllowCreate();
            boolean bl2 = false;
            try {
                Object object2;
                if (this.catalog.isReadOnly()) {
                    sDatabaseConfig.setAllowCreate(false);
                }
                SDatabase sDatabase = null;
                String string4 = this.catalog.getDatabaseClassName(string2);
                if (string4 != null) {
                    object2 = this.parseDbName(this.storePrefix + string4);
                    sDatabase = DbCompat.openDatabase(this.env, sTransaction, object2[0], object2[1], sDatabaseConfig);
                }
                if (sDatabase == null) {
                    throw new IndexNotAvailableException("PrimaryIndex not yet available on this Replica, entity class: " + string2);
                }
                primaryOpenState.addDatabase(sDatabase);
                internalPrimaryIndex = new InternalPrimaryIndex<PK, E>(sDatabase, clazz, persistKeyBinding, clazz2, (PersistEntityBinding)object);
                this.priIndexMap.put(string2, internalPrimaryIndex);
                if (DbCompat.getDeferredWrite(sDatabaseConfig)) {
                    this.deferredWriteDatabases.put(sDatabase, null);
                }
                if (!sDatabaseConfig.getReadOnly()) {
                    this.openSecondaryIndexes(sTransaction, entityMetadata, primaryOpenState);
                    object2 = this.inverseRelatedEntityMap.get(string2);
                    if (object2 != null) {
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            this.getRelatedIndex(string5);
                        }
                    }
                }
                bl2 = true;
            }
            finally {
                sDatabaseConfig.setAllowCreate(bl);
                if (bl2) {
                    if (sTransaction != null) {
                        sTransaction.commit();
                    }
                } else {
                    if (sTransaction != null) {
                        sTransaction.abort();
                    }
                    primaryOpenState.undoState();
                }
            }
        }
        return internalPrimaryIndex;
    }

    private PrimaryIndex getRelatedIndex(String string) throws SDatabaseException {
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        if (primaryIndex == null) {
            String string2;
            Class clazz;
            Class clazz2;
            EntityMetadata entityMetadata = this.checkEntityClass(string);
            if (this.rawAccess) {
                clazz2 = RawObject.class;
                clazz = Object.class;
                string2 = null;
            } else {
                try {
                    clazz2 = this.catalog.resolveClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Related entity class not found: " + string);
                }
                string2 = SimpleCatalog.keyClassName(entityMetadata.getPrimaryKey().getClassName());
                clazz = this.catalog.resolveKeyClass(string2);
            }
            primaryIndex = this.getPrimaryIndex(clazz, string2, clazz2, string);
        }
        return primaryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSecondaryIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, String string, Class<SK> clazz2, String string2, String string3) throws SDatabaseException, IndexNotAvailableException {
        InternalSecondaryIndex<SK, PK, E2> internalSecondaryIndex;
        String string4;
        assert (this.rawAccess && string2 == null || !this.rawAccess && string2 != null);
        this.checkOpen();
        EntityMetadata entityMetadata = null;
        SecondaryKeyMetadata secondaryKeyMetadata = null;
        if (clazz != primaryIndex.getEntityClass()) {
            entityMetadata = this.model.getEntityMetadata(string);
            assert (entityMetadata != null);
            secondaryKeyMetadata = this.checkSecKey(entityMetadata, string3);
            string4 = clazz.getName();
            if (!string4.equals(internalSecondaryIndex = secondaryKeyMetadata.getDeclaringClassName())) {
                throw new IllegalArgumentException("Key for subclass " + string4 + " is declared in a different class: " + Store.makeSecName((String)((Object)internalSecondaryIndex), string3));
            }
            try {
                this.catalog.getFormat(clazz, false);
            }
            catch (RefreshException refreshException) {
                refreshException.refresh();
                try {
                    this.catalog.getFormat(clazz, false);
                }
                catch (RefreshException refreshException2) {
                    throw DbCompat.unexpectedException(refreshException2);
                }
            }
        }
        if ((internalSecondaryIndex = this.secIndexMap.get(string4 = Store.makeSecName(string, string3))) == null) {
            String string5;
            if (entityMetadata == null) {
                entityMetadata = this.model.getEntityMetadata(string);
                assert (entityMetadata != null);
            }
            if (secondaryKeyMetadata == null) {
                secondaryKeyMetadata = this.checkSecKey(entityMetadata, string3);
            }
            if (string2 == null) {
                string2 = this.getSecKeyClass(secondaryKeyMetadata);
            } else {
                string5 = this.getSecKeyClass(secondaryKeyMetadata);
                if (!string2.equals(string5)) {
                    throw new IllegalArgumentException("Wrong secondary key class: " + string2 + " Correct class is: " + string5);
                }
            }
            string5 = this.catalog.getDatabaseClassName(string);
            String string6 = this.catalog.getDatabaseKeyName(string, string3);
            if (string5 != null && string6 != null) {
                STransaction sTransaction = null;
                if (this.getPrimaryConfig(entityMetadata).getTransactional() && DbCompat.getThreadTransaction(this.env) == null) {
                    sTransaction = this.env.beginTransaction(null, this.autoCommitNoWaitTxnConfig);
                }
                boolean bl = false;
                try {
                    internalSecondaryIndex = this.openSecondaryIndex(sTransaction, primaryIndex, clazz, entityMetadata, clazz2, string2, secondaryKeyMetadata, string4, Store.makeSecName(string5, string6), this.catalog.isReadOnly(), null);
                    bl = true;
                }
                finally {
                    if (bl) {
                        if (sTransaction != null) {
                            sTransaction.commit();
                        }
                    } else if (sTransaction != null) {
                        sTransaction.abort();
                    }
                }
            }
            if (internalSecondaryIndex == null) {
                throw new IndexNotAvailableException("SecondaryIndex not yet available on this Replica, entity class: " + string + ", key name: " + string3);
            }
        }
        return internalSecondaryIndex;
    }

    private void openSecondaryIndexes(STransaction sTransaction, EntityMetadata entityMetadata, PrimaryOpenState primaryOpenState) throws SDatabaseException {
        String string = entityMetadata.getClassName();
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        assert (primaryIndex != null);
        Class clazz = primaryIndex.getEntityClass();
        for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
            String string2 = secondaryKeyMetadata.getKeyName();
            String string3 = Store.makeSecName(string, string2);
            SecondaryIndex secondaryIndex = this.secIndexMap.get(string3);
            if (secondaryIndex != null) continue;
            String string4 = this.getSecKeyClass(secondaryKeyMetadata);
            Class clazz2 = this.catalog.resolveKeyClass(string4);
            String string5 = this.catalog.getDatabaseClassName(string);
            String string6 = this.catalog.getDatabaseKeyName(string, string2);
            if (string5 == null || string6 == null) continue;
            this.openSecondaryIndex(sTransaction, primaryIndex, clazz, entityMetadata, clazz2, string4, secondaryKeyMetadata, string3, Store.makeSecName(string5, string6), this.storeConfig.getSecondaryBulkLoad() || this.catalog.isReadOnly(), primaryOpenState);
        }
    }

    private <SK, PK, E1, E2 extends E1> InternalSecondaryIndex<SK, PK, E2> openSecondaryIndex(STransaction sTransaction, PrimaryIndex<PK, E1> primaryIndex, Class<E2> clazz, EntityMetadata entityMetadata, Class<SK> clazz2, String string, SecondaryKeyMetadata secondaryKeyMetadata, String string2, String string3, boolean bl, PrimaryOpenState primaryOpenState) throws SDatabaseException {
        Object object;
        assert (!this.secIndexMap.containsKey(string2));
        String[] stringArray = this.parseDbName(this.storePrefix + string3);
        SSecondaryConfig sSecondaryConfig = this.getSecondaryConfig(string2, entityMetadata, string, secondaryKeyMetadata);
        SDatabase sDatabase = primaryIndex.getDatabase();
        SDatabaseConfig sDatabaseConfig = sDatabase.getConfig();
        String string4 = secondaryKeyMetadata.getRelatedEntity();
        if (string4 != null) {
            object = this.getRelatedIndex(string4);
            sSecondaryConfig.setForeignKeyDatabase(((PrimaryIndex)object).getDatabase());
        }
        if (sSecondaryConfig.getTransactional() != sDatabaseConfig.getTransactional() || DbCompat.getDeferredWrite(sSecondaryConfig) != DbCompat.getDeferredWrite(sDatabaseConfig) || sSecondaryConfig.getReadOnly() != sDatabaseConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was changed to be inconsistent with the associated primary database:  Transactional, DeferredWrite, ReadOnly");
        }
        object = this.getKeyBinding(string);
        SSecondaryDatabase sSecondaryDatabase = this.openSecondaryDatabase(sTransaction, stringArray, primaryIndex, secondaryKeyMetadata.getKeyName(), sSecondaryConfig, bl);
        if (sSecondaryDatabase == null) {
            assert (bl);
            return null;
        }
        InternalSecondaryIndex<SK, PK, E1> internalSecondaryIndex = new InternalSecondaryIndex<SK, PK, E1>(sSecondaryDatabase, primaryIndex, clazz2, (PersistKeyBinding)object, this.getKeyCreator(sSecondaryConfig));
        this.secIndexMap.put(string2, internalSecondaryIndex);
        if (DbCompat.getDeferredWrite(sSecondaryConfig)) {
            this.deferredWriteDatabases.put(sSecondaryDatabase, null);
        }
        if (primaryOpenState != null) {
            primaryOpenState.addDatabase(sSecondaryDatabase);
            primaryOpenState.addSecondaryName(string2);
        }
        return internalSecondaryIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSecondaryDatabase openSecondaryDatabase(STransaction sTransaction, String[] stringArray, PrimaryIndex primaryIndex, String string, SSecondaryConfig sSecondaryConfig, boolean bl) throws SDatabaseException {
        assert (sSecondaryConfig.getAllowPopulate());
        assert (!sSecondaryConfig.getExclusiveCreate());
        SDatabase sDatabase = primaryIndex.getDatabase();
        ComplexFormat complexFormat = (ComplexFormat)((PersistEntityBinding)primaryIndex.getEntityBinding()).entityFormat;
        boolean bl2 = sSecondaryConfig.getAllowCreate();
        try {
            SSecondaryDatabase sSecondaryDatabase;
            if (bl) {
                sSecondaryConfig.setAllowCreate(false);
            }
            if (sSecondaryConfig.getAllowCreate()) {
                sSecondaryConfig.setExclusiveCreate(true);
                sSecondaryDatabase = DbCompat.openSecondaryDatabase(this.env, sTransaction, stringArray[0], stringArray[1], sDatabase, sSecondaryConfig);
                if (sSecondaryDatabase != null) {
                    assert (!expectFlush);
                    SSecondaryDatabase sSecondaryDatabase2 = sSecondaryDatabase;
                    return sSecondaryDatabase2;
                }
            }
            sSecondaryConfig.setAllowCreate(false);
            sSecondaryConfig.setAllowPopulate(false);
            sSecondaryConfig.setExclusiveCreate(false);
            SSecondaryDatabase sSecondaryDatabase3 = sSecondaryDatabase = DbCompat.openSecondaryDatabase(this.env, sTransaction, stringArray[0], stringArray[1], sDatabase, sSecondaryConfig);
            return sSecondaryDatabase3;
        }
        finally {
            sSecondaryConfig.setAllowPopulate(true);
            sSecondaryConfig.setExclusiveCreate(false);
            sSecondaryConfig.setAllowCreate(bl2);
        }
    }

    synchronized void checkEntitySubclassSecondaries(EntityMetadata entityMetadata, String string) throws SDatabaseException {
        if (this.storeConfig.getSecondaryBulkLoad()) {
            return;
        }
        String string2 = entityMetadata.getClassName();
        for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
            String string3 = secondaryKeyMetadata.getKeyName();
            String string4 = Store.makeSecName(string2, string3);
            if (this.secIndexMap.containsKey(string4)) continue;
            throw new IllegalArgumentException("Entity subclasses defining a secondary key must be registered by calling EntityModel.registerClass or EntityStore.getSubclassIndex before storing an instance of the subclass: " + string);
        }
    }

    public void truncateClass(Class clazz) throws SDatabaseException {
        this.truncateClass(null, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void truncateClass(STransaction sTransaction, Class clazz) throws SDatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        this.closeClass(clazz);
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        boolean bl = false;
        if (sTransaction == null && DbCompat.getThreadTransaction(this.env) == null) {
            sTransaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            bl = true;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = this.truncateIfExists(sTransaction, this.storePrefix + string);
            if (bl3) {
                Object var8_8 = null;
                for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                    this.removeIfExists(sTransaction, this.storePrefix + Store.makeSecName(string, secondaryKeyMetadata.getKeyName()));
                }
                if (var8_8 != null) {
                    throw var8_8;
                }
            }
            bl2 = true;
        }
        finally {
            if (bl) {
                if (bl2) {
                    sTransaction.commit();
                } else {
                    sTransaction.abort();
                }
            }
        }
    }

    private boolean truncateIfExists(STransaction sTransaction, String string) throws SDatabaseException {
        String[] stringArray = this.parseDbName(string);
        return DbCompat.truncateDatabase(this.env, sTransaction, stringArray[0], stringArray[1]);
    }

    private boolean removeIfExists(STransaction sTransaction, String string) throws SDatabaseException {
        String[] stringArray = this.parseDbName(string);
        return DbCompat.removeDatabase(this.env, sTransaction, stringArray[0], stringArray[1]);
    }

    public synchronized void closeClass(Class clazz) throws SDatabaseException {
        this.checkOpen();
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        PrimaryIndex primaryIndex = this.priIndexMap.get(string);
        if (primaryIndex != null) {
            SDatabaseException sDatabaseException = null;
            for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string2 = Store.makeSecName(string, secondaryKeyMetadata.getKeyName());
                SecondaryIndex secondaryIndex = this.secIndexMap.get(string2);
                if (secondaryIndex == null) continue;
                SSecondaryDatabase sSecondaryDatabase = secondaryIndex.getDatabase();
                sDatabaseException = this.closeDb(sSecondaryDatabase, sDatabaseException);
                sDatabaseException = this.closeDb(secondaryIndex.getKeysDatabase(), sDatabaseException);
                this.secIndexMap.remove(string2);
                this.deferredWriteDatabases.remove(sSecondaryDatabase);
            }
            SDatabase sDatabase = primaryIndex.getDatabase();
            sDatabaseException = this.closeDb(sDatabase, sDatabaseException);
            this.priIndexMap.remove(string);
            this.deferredWriteDatabases.remove(sDatabase);
            if (sDatabaseException != null) {
                throw sDatabaseException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SDatabaseException {
        SDatabaseException sDatabaseException;
        block21: {
            if (this.catalog == null) {
                return;
            }
            sDatabaseException = null;
            try {
                if (this.rawAccess) {
                    boolean bl = this.catalog.close();
                    assert (bl);
                } else {
                    Map<SEnvironment, Map<String, PersistCatalog>> map = catalogPool;
                    synchronized (map) {
                        Map<String, PersistCatalog> object = catalogPool.get(this.env);
                        assert (object != null);
                        boolean bl = true;
                        try {
                            bl = this.catalog.close();
                        }
                        finally {
                            if (bl) {
                                object.remove(this.storeName);
                            }
                        }
                    }
                }
                this.catalog = null;
            }
            catch (SDatabaseException sDatabaseException2) {
                if (sDatabaseException != null) break block21;
                sDatabaseException = sDatabaseException2;
            }
        }
        for (SSequence sSequence : this.sequenceMap.values()) {
            try {
                sSequence.close();
            }
            catch (SDatabaseException sDatabaseException2) {
                if (sDatabaseException != null) continue;
                sDatabaseException = sDatabaseException2;
            }
        }
        sDatabaseException = this.closeDb(this.sequenceDb, sDatabaseException);
        for (SecondaryIndex secondaryIndex : this.secIndexMap.values()) {
            sDatabaseException = this.closeDb(secondaryIndex.getDatabase(), sDatabaseException);
            sDatabaseException = this.closeDb(secondaryIndex.getKeysDatabase(), sDatabaseException);
        }
        for (PrimaryIndex primaryIndex : this.priIndexMap.values()) {
            sDatabaseException = this.closeDb(primaryIndex.getDatabase(), sDatabaseException);
        }
        if (sDatabaseException != null) {
            throw sDatabaseException;
        }
    }

    public synchronized SSequence getSequence(String string) throws SDatabaseException {
        this.checkOpen();
        if (this.storeConfig.getReadOnly()) {
            throw new IllegalStateException("Store is read-only");
        }
        SSequence sSequence = this.sequenceMap.get(string);
        if (sSequence == null) {
            String[] stringArray;
            if (this.sequenceDb == null) {
                stringArray = this.parseDbName(this.storePrefix + SEQUENCE_DB);
                SDatabaseConfig sDatabaseConfig = new SDatabaseConfig();
                sDatabaseConfig.setAllowCreate(true);
                DbCompat.setTypeBtree(sDatabaseConfig);
                this.sequenceDb = DbCompat.openDatabase(this.env, null, stringArray[0], stringArray[1], sDatabaseConfig);
                assert (this.sequenceDb != null);
            }
            stringArray = new SDatabaseEntry();
            StringBinding.stringToEntry(string, (SDatabaseEntry)stringArray);
            sSequence = this.sequenceDb.openSequence(null, (SDatabaseEntry)stringArray, this.getSequenceConfig(string));
            this.sequenceMap.put(string, sSequence);
        }
        return sSequence;
    }

    public synchronized SSequenceConfig getSequenceConfig(String string) {
        this.checkOpen();
        SSequenceConfig sSequenceConfig = this.sequenceConfigMap.get(string);
        if (sSequenceConfig == null) {
            sSequenceConfig = new SSequenceConfig();
            sSequenceConfig.setInitialValue(1L);
            sSequenceConfig.setRange(1L, Long.MAX_VALUE);
            sSequenceConfig.setCacheSize(100);
            sSequenceConfig.setAutoCommitNoSync(true);
            sSequenceConfig.setAllowCreate(!this.storeConfig.getReadOnly());
            this.sequenceConfigMap.put(string, sSequenceConfig);
        }
        return sSequenceConfig;
    }

    public synchronized void setSequenceConfig(String string, SSequenceConfig sSequenceConfig) {
        this.checkOpen();
        if (sSequenceConfig.getExclusiveCreate() || sSequenceConfig.getAllowCreate() == this.storeConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate");
        }
        if (this.sequenceMap.containsKey(string)) {
            throw new IllegalStateException("Cannot set config after SSequence is open");
        }
        this.sequenceConfigMap.put(string, sSequenceConfig);
    }

    public synchronized SDatabaseConfig getPrimaryConfig(Class clazz) {
        this.checkOpen();
        String string = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        return this.getPrimaryConfig(entityMetadata).cloneConfig();
    }

    private synchronized SDatabaseConfig getPrimaryConfig(EntityMetadata entityMetadata) {
        String string = entityMetadata.getClassName();
        SDatabaseConfig sDatabaseConfig = this.priConfigMap.get(string);
        if (sDatabaseConfig == null) {
            sDatabaseConfig = new SDatabaseConfig();
            sDatabaseConfig.setAllowCreate(!this.storeConfig.getReadOnly());
            sDatabaseConfig.setReadOnly(this.storeConfig.getReadOnly());
            DbCompat.setTypeBtree(sDatabaseConfig);
            this.setBtreeComparator(sDatabaseConfig, entityMetadata.getPrimaryKey().getClassName());
            this.priConfigMap.put(string, sDatabaseConfig);
        }
        return sDatabaseConfig;
    }

    public synchronized void setPrimaryConfig(Class clazz, SDatabaseConfig sDatabaseConfig) {
        this.checkOpen();
        String string = clazz.getName();
        if (this.priIndexMap.containsKey(string)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        EntityMetadata entityMetadata = this.checkEntityClass(string);
        SDatabaseConfig sDatabaseConfig2 = this.getPrimaryConfig(entityMetadata);
        if (sDatabaseConfig.getExclusiveCreate() || sDatabaseConfig.getAllowCreate() == sDatabaseConfig.getReadOnly() || sDatabaseConfig.getSortedDuplicates() || sDatabaseConfig.getBtreeComparator() != sDatabaseConfig2.getBtreeComparator()) {
            throw new IllegalArgumentException("One of these properties was illegally changed: AllowCreate, ExclusiveCreate, SortedDuplicates, Temporary or BtreeComparator, ");
        }
        if (!DbCompat.isTypeBtree(sDatabaseConfig)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.priConfigMap.put(string, sDatabaseConfig);
    }

    public synchronized SSecondaryConfig getSecondaryConfig(Class clazz, String string) {
        this.checkOpen();
        String string2 = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string2);
        SecondaryKeyMetadata secondaryKeyMetadata = this.checkSecKey(entityMetadata, string);
        String string3 = this.getSecKeyClass(secondaryKeyMetadata);
        String string4 = Store.makeSecName(clazz.getName(), string);
        return this.getSecondaryConfig(string4, entityMetadata, string3, secondaryKeyMetadata).cloneConfig();
    }

    private SSecondaryConfig getSecondaryConfig(String string, EntityMetadata entityMetadata, String string2, SecondaryKeyMetadata secondaryKeyMetadata) {
        SSecondaryConfig sSecondaryConfig = this.secConfigMap.get(string);
        if (sSecondaryConfig == null) {
            SDatabaseConfig sDatabaseConfig = this.getPrimaryConfig(entityMetadata);
            sSecondaryConfig = new SSecondaryConfig();
            sSecondaryConfig.setAllowCreate(!sDatabaseConfig.getReadOnly());
            sSecondaryConfig.setReadOnly(sDatabaseConfig.getReadOnly());
            DbCompat.setTypeBtree(sSecondaryConfig);
            sSecondaryConfig.setAllowPopulate(true);
            Relationship relationship = secondaryKeyMetadata.getRelationship();
            sSecondaryConfig.setSortedDuplicates(relationship == Relationship.MANY_TO_ONE || relationship == Relationship.MANY_TO_MANY);
            this.setBtreeComparator(sSecondaryConfig, string2);
            PersistKeyCreator persistKeyCreator = new PersistKeyCreator(this.catalog, entityMetadata, string2, secondaryKeyMetadata, this.rawAccess);
            if (relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY) {
                sSecondaryConfig.setMultiKeyCreator(persistKeyCreator);
            } else {
                sSecondaryConfig.setKeyCreator(persistKeyCreator);
            }
            DeleteAction deleteAction = secondaryKeyMetadata.getDeleteAction();
            if (deleteAction != null) {
                SForeignKeyDeleteAction sForeignKeyDeleteAction;
                switch (deleteAction) {
                    case ABORT: {
                        sForeignKeyDeleteAction = SForeignKeyDeleteAction.ABORT;
                        break;
                    }
                    case CASCADE: {
                        sForeignKeyDeleteAction = SForeignKeyDeleteAction.CASCADE;
                        break;
                    }
                    case NULLIFY: {
                        sForeignKeyDeleteAction = SForeignKeyDeleteAction.NULLIFY;
                        break;
                    }
                    default: {
                        throw DbCompat.unexpectedState(deleteAction.toString());
                    }
                }
                sSecondaryConfig.setForeignKeyDeleteAction(sForeignKeyDeleteAction);
                if (deleteAction == DeleteAction.NULLIFY) {
                    sSecondaryConfig.setForeignMultiKeyNullifier(persistKeyCreator);
                }
            }
            this.secConfigMap.put(string, sSecondaryConfig);
        }
        return sSecondaryConfig;
    }

    public synchronized void setSecondaryConfig(Class clazz, String string, SSecondaryConfig sSecondaryConfig) {
        this.checkOpen();
        String string2 = clazz.getName();
        EntityMetadata entityMetadata = this.checkEntityClass(string2);
        SecondaryKeyMetadata secondaryKeyMetadata = this.checkSecKey(entityMetadata, string);
        String string3 = this.getSecKeyClass(secondaryKeyMetadata);
        String string4 = Store.makeSecName(clazz.getName(), string);
        if (this.secIndexMap.containsKey(string4)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        SSecondaryConfig sSecondaryConfig2 = this.getSecondaryConfig(string4, entityMetadata, string3, secondaryKeyMetadata);
        if (sSecondaryConfig.getExclusiveCreate() || sSecondaryConfig.getAllowCreate() == sSecondaryConfig.getReadOnly() || sSecondaryConfig.getSortedDuplicates() != sSecondaryConfig2.getSortedDuplicates() || sSecondaryConfig.getBtreeComparator() != sSecondaryConfig2.getBtreeComparator() || sSecondaryConfig.getAllowPopulate() != sSecondaryConfig2.getAllowPopulate() || sSecondaryConfig.getKeyCreator() != sSecondaryConfig2.getKeyCreator() || sSecondaryConfig.getMultiKeyCreator() != sSecondaryConfig2.getMultiKeyCreator() || sSecondaryConfig.getForeignKeyNullifier() != sSecondaryConfig2.getForeignKeyNullifier() || sSecondaryConfig.getForeignMultiKeyNullifier() != sSecondaryConfig2.getForeignMultiKeyNullifier() || sSecondaryConfig.getForeignKeyDeleteAction() != sSecondaryConfig2.getForeignKeyDeleteAction() || sSecondaryConfig.getForeignKeyDatabase() != null) {
            throw new IllegalArgumentException("One of these properties was illegally changed:  AllowCreate, ExclusiveCreate, SortedDuplicates, BtreeComparator, DuplicateComparator, Temporary, AllowPopulate, KeyCreator, MultiKeyCreator, ForeignKeyNullifer, ForeignMultiKeyNullifier, SForeignKeyDeleteAction, ForeignKeyDatabase");
        }
        if (!DbCompat.isTypeBtree(sSecondaryConfig)) {
            throw new IllegalArgumentException("Only type BTREE allowed");
        }
        this.secConfigMap.put(string4, sSecondaryConfig);
    }

    private static String makeSecName(String string, String string2) {
        return string + NAME_SEPARATOR + string2;
    }

    static String makePriDbName(String string, String string2) {
        return string + string2;
    }

    static String makeSecDbName(String string, String string2, String string3) {
        return string + Store.makeSecName(string2, string3);
    }

    public String[] parseDbName(String string) {
        return Store.parseDbName(string, this.storeConfig.getDatabaseNamer());
    }

    public static String[] parseDbName(String string, DatabaseNamer databaseNamer) {
        String[] stringArray = new String[2];
        String[] stringArray2 = string.split(NAME_SEPARATOR);
        assert (stringArray2.length == 3 || stringArray2.length == 4) : string;
        assert (stringArray2[0].equals("persist")) : string;
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        String string4 = stringArray2.length > 3 ? stringArray2[3] : null;
        stringArray[0] = databaseNamer.getFileName(string2, string3, string4);
        stringArray[1] = null;
        return stringArray;
    }

    String getDbNameMessage(String[] stringArray) {
        return "file: " + stringArray[0];
    }

    private void checkOpen() {
        if (this.catalog == null) {
            throw new IllegalStateException("Store has been closed");
        }
    }

    private void checkWriteAllowed() {
        if (this.catalog.isReadOnly()) {
            throw new IllegalStateException("Store is read-only or is operating as a Replica");
        }
    }

    private EntityMetadata checkEntityClass(String string) {
        EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
        if (entityMetadata == null) {
            throw new IllegalArgumentException("Class could not be loaded or is not an entity class: " + string);
        }
        return entityMetadata;
    }

    private SecondaryKeyMetadata checkSecKey(EntityMetadata entityMetadata, String string) {
        SecondaryKeyMetadata secondaryKeyMetadata = entityMetadata.getSecondaryKeys().get(string);
        if (secondaryKeyMetadata == null) {
            throw new IllegalArgumentException("Not a secondary key: " + Store.makeSecName(entityMetadata.getClassName(), string));
        }
        return secondaryKeyMetadata;
    }

    private String getSecKeyClass(SecondaryKeyMetadata secondaryKeyMetadata) {
        String string = secondaryKeyMetadata.getElementClassName();
        if (string == null) {
            string = secondaryKeyMetadata.getClassName();
        }
        return SimpleCatalog.keyClassName(string);
    }

    private PersistKeyBinding getKeyBinding(String string) {
        PersistKeyBinding persistKeyBinding = this.keyBindingMap.get(string);
        if (persistKeyBinding == null) {
            persistKeyBinding = new PersistKeyBinding((Catalog)this.catalog, string, this.rawAccess);
            this.keyBindingMap.put(string, persistKeyBinding);
        }
        return persistKeyBinding;
    }

    private PersistKeyCreator getKeyCreator(SSecondaryConfig sSecondaryConfig) {
        PersistKeyCreator persistKeyCreator = (PersistKeyCreator)sSecondaryConfig.getKeyCreator();
        if (persistKeyCreator != null) {
            return persistKeyCreator;
        }
        persistKeyCreator = (PersistKeyCreator)sSecondaryConfig.getMultiKeyCreator();
        assert (persistKeyCreator != null);
        return persistKeyCreator;
    }

    private void setBtreeComparator(SDatabaseConfig sDatabaseConfig, String string) {
        if (!this.rawAccess) {
            PersistKeyBinding persistKeyBinding = this.getKeyBinding(string);
            Format format = persistKeyBinding.keyFormat;
            if (format instanceof CompositeKeyFormat) {
                throw new UnsupportedOperationException("Composite key with custom sort order is unsupported.");
            }
        }
    }

    private SDatabaseException closeDb(SDatabase sDatabase, SDatabaseException sDatabaseException) {
        block3: {
            if (sDatabase != null) {
                try {
                    sDatabase.close();
                }
                catch (SDatabaseException sDatabaseException2) {
                    if (sDatabaseException != null) break block3;
                    sDatabaseException = sDatabaseException2;
                }
            }
        }
        return sDatabaseException;
    }

    public EvolveStats evolve(EvolveConfig evolveConfig) throws SDatabaseException {
        this.checkOpen();
        this.checkWriteAllowed();
        if (this.catalog.isReplicaUpgradeMode() || this.catalog.isMetadataStale(null)) {
            this.attemptRefresh();
        }
        PersistCatalog persistCatalog = this.catalog;
        ArrayList<Format> arrayList = new ArrayList<Format>();
        Set<String> set = evolveConfig.getClassesToEvolve();
        if (set.isEmpty()) {
            persistCatalog.getEntityFormats(arrayList);
        } else {
            for (String object : set) {
                Format format = persistCatalog.getFormat(object);
                if (format == null) {
                    throw new IllegalArgumentException("Class to evolve is not persistent: " + object);
                }
                if (!format.isEntity()) {
                    throw new IllegalArgumentException("Class to evolve is not an entity class: " + object);
                }
                arrayList.add(format);
            }
        }
        EvolveEvent evolveEvent = EvolveInternal.newEvent();
        for (Format format : arrayList) {
            if (!format.getEvolveNeeded()) continue;
            this.evolveIndex(format, evolveEvent, evolveConfig.getEvolveListener());
            format.setEvolveNeeded(false);
            persistCatalog.flush(null);
        }
        return evolveEvent.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evolveIndex(Format format, EvolveEvent evolveEvent, EvolveListener evolveListener) throws SDatabaseException {
        Class clazz = format.getType();
        String string = format.getClassName();
        EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
        String string2 = entityMetadata.getPrimaryKey().getClassName();
        string2 = SimpleCatalog.keyClassName(string2);
        SDatabaseConfig sDatabaseConfig = this.getPrimaryConfig(entityMetadata);
        PrimaryIndex primaryIndex = this.getPrimaryIndex(Object.class, string2, clazz, string);
        SDatabase sDatabase = primaryIndex.getDatabase();
        EntityBinding entityBinding = primaryIndex.getEntityBinding();
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        SCursorConfig sCursorConfig = null;
        STransaction sTransaction = null;
        if (sDatabaseConfig.getTransactional()) {
            sTransaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
            sCursorConfig = SCursorConfig.READ_COMMITTED;
        }
        SCursor sCursor = null;
        int n = 0;
        try {
            sCursor = sDatabase.openCursor(sTransaction, sCursorConfig);
            SOperationStatus sOperationStatus = sCursor.getFirst(sDatabaseEntry, sDatabaseEntry2, null);
            while (sOperationStatus == SOperationStatus.SUCCESS) {
                boolean bl = false;
                if (this.evolveNeeded(sDatabaseEntry, sDatabaseEntry2, entityBinding)) {
                    sCursor.putCurrent(sDatabaseEntry2);
                    bl = true;
                    ++n;
                }
                EvolveInternal.updateEvent(evolveEvent, string, 1, bl ? 1 : 0);
                if (evolveListener != null && !evolveListener.evolveProgress(evolveEvent)) {
                    break;
                }
                if (sTransaction != null && n >= 1) {
                    sCursor.close();
                    sCursor = null;
                    sTransaction.commit();
                    sTransaction = null;
                    sTransaction = this.env.beginTransaction(null, this.autoCommitTxnConfig);
                    sCursor = sDatabase.openCursor(sTransaction, sCursorConfig);
                    SDatabaseEntry sDatabaseEntry3 = KeyRange.copy(sDatabaseEntry);
                    sOperationStatus = sCursor.getSearchKeyRange(sDatabaseEntry, sDatabaseEntry2, null);
                    if (sOperationStatus != SOperationStatus.SUCCESS || !KeyRange.equalBytes(sDatabaseEntry, sDatabaseEntry3)) continue;
                    sOperationStatus = sCursor.getNext(sDatabaseEntry, sDatabaseEntry2, null);
                    continue;
                }
                sOperationStatus = sCursor.getNext(sDatabaseEntry, sDatabaseEntry2, null);
            }
        }
        finally {
            if (sCursor != null) {
                sCursor.close();
            }
            if (sTransaction != null) {
                if (n > 0) {
                    sTransaction.commit();
                } else {
                    sTransaction.abort();
                }
            }
        }
    }

    private boolean evolveNeeded(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, EntityBinding entityBinding) {
        Object e = entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2);
        SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
        entityBinding.objectToData(e, sDatabaseEntry3);
        if (sDatabaseEntry2.equals(sDatabaseEntry3)) {
            return false;
        }
        byte[] byArray = sDatabaseEntry3.getData();
        int n = sDatabaseEntry3.getOffset();
        int n2 = sDatabaseEntry3.getSize();
        sDatabaseEntry2.setData(byArray, n, n2);
        return true;
    }

    public static void setSyncHook(SyncHook syncHook) {
        Store.syncHook = syncHook;
    }

    public boolean attemptRefresh() {
        PersistCatalog persistCatalog = this.catalog;
        PersistCatalog persistCatalog2 = this.refresh(persistCatalog, -1, null);
        return persistCatalog != persistCatalog2;
    }

    synchronized PersistCatalog refresh(PersistCatalog persistCatalog, int n, RefreshException refreshException) {
        if (persistCatalog != this.catalog) {
            return this.catalog;
        }
        try {
            this.catalog = new PersistCatalog(persistCatalog, this.storePrefix);
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
        if (n >= this.catalog.getNFormats()) {
            throw DbCompat.unexpectedException("Catalog could not be refreshed, may indicate corruption, errorFormatId=" + n + " nFormats=" + this.catalog.getNFormats() + ", .", refreshException);
        }
        for (InternalPrimaryIndex object : this.priIndexMap.values()) {
            object.refresh(this.catalog);
        }
        for (InternalSecondaryIndex internalSecondaryIndex : this.secIndexMap.values()) {
            internalSecondaryIndex.refresh(this.catalog);
        }
        for (PersistKeyBinding persistKeyBinding : this.keyBindingMap.values()) {
            persistKeyBinding.refresh(this.catalog);
        }
        for (SSecondaryConfig sSecondaryConfig : this.secConfigMap.values()) {
            PersistKeyCreator persistKeyCreator = this.getKeyCreator(sSecondaryConfig);
            persistKeyCreator.refresh(this.catalog);
        }
        return this.catalog;
    }

    STransactionConfig getAutoCommitTxnConfig() {
        return this.autoCommitTxnConfig;
    }

    private class InternalSecondaryIndex<SK, PK, E>
    extends SecondaryIndex<SK, PK, E> {
        private final PersistKeyCreator keyCreator;

        InternalSecondaryIndex(SSecondaryDatabase sSecondaryDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, PersistKeyBinding persistKeyBinding, PersistKeyCreator persistKeyCreator) throws SDatabaseException {
            super(sSecondaryDatabase, null, primaryIndex, clazz, persistKeyBinding);
            this.keyCreator = persistKeyCreator;
        }

        void refresh(PersistCatalog persistCatalog) {
            this.keyCreator.refresh(persistCatalog);
        }
    }

    private class InternalPrimaryIndex<PK, E>
    extends PrimaryIndex<PK, E> {
        private final PersistEntityBinding entityBinding;

        InternalPrimaryIndex(SDatabase sDatabase, Class<PK> clazz, PersistKeyBinding persistKeyBinding, Class<E> clazz2, PersistEntityBinding persistEntityBinding) throws SDatabaseException {
            super(sDatabase, clazz, persistKeyBinding, clazz2, persistEntityBinding);
            this.entityBinding = persistEntityBinding;
        }

        void refresh(PersistCatalog persistCatalog) {
            this.entityBinding.refresh(persistCatalog);
        }
    }

    public static interface SyncHook {
        public void onSync(SDatabase var1);
    }

    private class PrimaryOpenState {
        private String entityClassName;
        private IdentityHashMap<SDatabase, Object> databases;
        private Set<String> secNames;

        PrimaryOpenState(String string) {
            this.entityClassName = string;
            this.databases = new IdentityHashMap();
            this.secNames = new HashSet<String>();
        }

        void addDatabase(SDatabase sDatabase) {
            this.databases.put(sDatabase, null);
        }

        void addSecondaryName(String string) {
            this.secNames.add(string);
        }

        void undoState() {
            for (SDatabase object : this.databases.keySet()) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            Store.this.priIndexMap.remove(this.entityClassName);
            for (String string : this.secNames) {
                Store.this.secIndexMap.remove(string);
            }
            for (SDatabase sDatabase : this.databases.keySet()) {
                Store.this.deferredWriteDatabases.remove(sDatabase);
            }
        }
    }
}

