/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.SSecondaryDatabase;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.STransactionConfig;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.collections.StoredSortedMap;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.persist.BasicIndex;
import com.sleepycat.client.persist.EntityIndex;
import com.sleepycat.client.persist.EntityValueAdapter;
import com.sleepycat.client.persist.KeysIndex;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.SubIndex;
import java.util.Map;
import java.util.SortedMap;

public class SecondaryIndex<SK, PK, E>
extends BasicIndex<SK, E> {
    private SSecondaryDatabase secDb;
    private SDatabase keysDb;
    private PrimaryIndex<PK, E> priIndex;
    private EntityBinding<E> entityBinding;
    private EntityIndex<SK, PK> keysIndex;
    private SortedMap<SK, E> map;

    public SecondaryIndex(SSecondaryDatabase sSecondaryDatabase, SDatabase sDatabase, PrimaryIndex<PK, E> primaryIndex, Class<SK> clazz, EntryBinding<SK> entryBinding) throws SDatabaseException {
        super(sSecondaryDatabase, clazz, entryBinding, new EntityValueAdapter<E>(primaryIndex.getEntityClass(), primaryIndex.getEntityBinding(), true));
        this.secDb = sSecondaryDatabase;
        this.keysDb = sDatabase;
        this.priIndex = primaryIndex;
        this.entityBinding = primaryIndex.getEntityBinding();
    }

    @Override
    public SSecondaryDatabase getDatabase() {
        return this.secDb;
    }

    public SDatabase getKeysDatabase() {
        return this.keysDb;
    }

    public PrimaryIndex<PK, E> getPrimaryIndex() {
        return this.priIndex;
    }

    public Class<SK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<SK> getKeyBinding() {
        return this.keyBinding;
    }

    public synchronized EntityIndex<SK, PK> keysIndex() throws SDatabaseException {
        if (this.keysIndex == null) {
            if (this.keysDb == null) {
                SDatabaseConfig sDatabaseConfig = this.secDb.getConfig();
                sDatabaseConfig.setReadOnly(true);
                sDatabaseConfig.setAllowCreate(false);
                sDatabaseConfig.setExclusiveCreate(false);
                this.keysDb = DbCompat.openDatabase(this.db.getEnvironment(), null, DbCompat.getDatabaseFile(this.secDb), this.secDb.getDatabaseName(), sDatabaseConfig);
                if (this.keysDb == null) {
                    throw new IllegalStateException("Could not open existing DB, file: " + DbCompat.getDatabaseFile(this.secDb) + " name: " + this.secDb.getDatabaseName());
                }
            }
            this.keysIndex = new KeysIndex(this.keysDb, this.keyClass, this.keyBinding, this.priIndex.getKeyClass(), this.priIndex.getKeyBinding());
        }
        return this.keysIndex;
    }

    public EntityIndex<PK, E> subIndex(SK SK) throws SDatabaseException {
        return new SubIndex(this, this.entityBinding, SK);
    }

    @Override
    public E get(SK SK) throws SDatabaseException {
        return this.get((STransaction)null, SK, (SLockMode)null);
    }

    @Override
    public E get(STransaction sTransaction, SK SK, SLockMode sLockMode) throws SDatabaseException {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
        SDatabaseEntry sDatabaseEntry3 = new SDatabaseEntry();
        this.keyBinding.objectToEntry(SK, sDatabaseEntry);
        SOperationStatus sOperationStatus = this.secDb.get(sTransaction, sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, sLockMode);
        if (sOperationStatus == SOperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(sDatabaseEntry2, sDatabaseEntry3);
        }
        return null;
    }

    @Override
    public Map<SK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<SK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<SK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    STransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return false;
    }
}

