/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.persist;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SJoinCursor;
import com.sleepycat.client.SLockMode;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.STransaction;
import com.sleepycat.client.bind.EntityBinding;
import com.sleepycat.client.bind.EntryBinding;
import com.sleepycat.client.persist.BasicIndex;
import com.sleepycat.client.persist.BasicIterator;
import com.sleepycat.client.persist.ForwardCursor;
import com.sleepycat.client.persist.PrimaryIndex;
import com.sleepycat.client.persist.SecondaryIndex;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EntityJoin<PK, E> {
    private PrimaryIndex<PK, E> primary;
    private List<Condition> conditions;

    public EntityJoin(PrimaryIndex<PK, E> primaryIndex) {
        this.primary = primaryIndex;
        this.conditions = new ArrayList<Condition>();
    }

    public <SK> void addCondition(SecondaryIndex<SK, PK, E> secondaryIndex, SK SK) {
        SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
        secondaryIndex.getKeyBinding().objectToEntry(SK, sDatabaseEntry);
        SDatabase sDatabase = secondaryIndex.getKeysDatabase();
        if (sDatabase == null) {
            sDatabase = secondaryIndex.getDatabase();
        }
        this.conditions.add(new Condition(sDatabase, sDatabaseEntry));
    }

    public ForwardCursor<E> entities() throws SDatabaseException {
        return this.entities(null, null);
    }

    public ForwardCursor<E> entities(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return new JoinForwardCursor(sTransaction, sCursorConfig, false);
    }

    public ForwardCursor<PK> keys() throws SDatabaseException {
        return this.keys(null, null);
    }

    public ForwardCursor<PK> keys(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
        return new JoinForwardCursor(sTransaction, sCursorConfig, true);
    }

    private class JoinForwardCursor<V>
    implements ForwardCursor<V> {
        private SCursor[] cursors;
        private SJoinCursor joinCursor;
        private boolean doKeys;

        JoinForwardCursor(STransaction sTransaction, SCursorConfig sCursorConfig, boolean bl) throws SDatabaseException {
            this.doKeys = bl;
            try {
                this.cursors = new SCursor[EntityJoin.this.conditions.size()];
                for (int i = 0; i < this.cursors.length; ++i) {
                    Condition condition = (Condition)EntityJoin.this.conditions.get(i);
                    SCursor sCursor = condition.openCursor(sTransaction, sCursorConfig);
                    if (sCursor == null) {
                        this.doClose(null);
                        return;
                    }
                    this.cursors[i] = sCursor;
                }
                this.joinCursor = EntityJoin.this.primary.getDatabase().join(this.cursors, null);
            }
            catch (SDatabaseException sDatabaseException) {
                this.doClose(sDatabaseException);
            }
        }

        @Override
        public V next() throws SDatabaseException {
            return this.next(null);
        }

        @Override
        public V next(SLockMode sLockMode) throws SDatabaseException {
            if (this.joinCursor == null) {
                return null;
            }
            if (this.doKeys) {
                SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
                SOperationStatus sOperationStatus = this.joinCursor.getNext(sDatabaseEntry, sLockMode);
                if (sOperationStatus == SOperationStatus.SUCCESS) {
                    EntryBinding entryBinding = EntityJoin.this.primary.getKeyBinding();
                    return (V)entryBinding.entryToObject(sDatabaseEntry);
                }
            } else {
                SDatabaseEntry sDatabaseEntry = new SDatabaseEntry();
                SDatabaseEntry sDatabaseEntry2 = new SDatabaseEntry();
                SOperationStatus sOperationStatus = this.joinCursor.getNext(sDatabaseEntry, sDatabaseEntry2, sLockMode);
                if (sOperationStatus == SOperationStatus.SUCCESS) {
                    EntityBinding entityBinding = EntityJoin.this.primary.getEntityBinding();
                    return (V)entityBinding.entryToObject(sDatabaseEntry, sDatabaseEntry2);
                }
            }
            return null;
        }

        @Override
        public Iterator<V> iterator() {
            return this.iterator(null);
        }

        @Override
        public Iterator<V> iterator(SLockMode sLockMode) {
            return new BasicIterator(this, sLockMode);
        }

        @Override
        public void close() throws SDatabaseException {
            this.doClose(null);
        }

        private void doClose(SDatabaseException sDatabaseException) throws SDatabaseException {
            block7: {
                if (this.joinCursor != null) {
                    try {
                        this.joinCursor.close();
                        this.joinCursor = null;
                    }
                    catch (SDatabaseException sDatabaseException2) {
                        if (sDatabaseException != null) break block7;
                        sDatabaseException = sDatabaseException2;
                    }
                }
            }
            for (int i = 0; i < this.cursors.length; ++i) {
                SCursor sCursor = this.cursors[i];
                if (sCursor == null) continue;
                try {
                    sCursor.close();
                    this.cursors[i] = null;
                    continue;
                }
                catch (SDatabaseException sDatabaseException3) {
                    if (sDatabaseException != null) continue;
                    sDatabaseException = sDatabaseException3;
                }
            }
            if (sDatabaseException != null) {
                throw sDatabaseException;
            }
        }
    }

    private static class Condition {
        private SDatabase db;
        private SDatabaseEntry key;

        Condition(SDatabase sDatabase, SDatabaseEntry sDatabaseEntry) {
            this.db = sDatabase;
            this.key = sDatabaseEntry;
        }

        SCursor openCursor(STransaction sTransaction, SCursorConfig sCursorConfig) throws SDatabaseException {
            SOperationStatus sOperationStatus;
            SCursor sCursor = this.db.openCursor(sTransaction, sCursorConfig);
            try {
                SDatabaseEntry sDatabaseEntry = BasicIndex.NO_RETURN_ENTRY;
                sOperationStatus = sCursor.getSearchKey(this.key, sDatabaseEntry, null);
            }
            catch (SDatabaseException sDatabaseException) {
                try {
                    sCursor.close();
                }
                catch (SDatabaseException sDatabaseException2) {
                    // empty catch block
                }
                throw sDatabaseException;
            }
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                return sCursor;
            }
            sCursor.close();
            return null;
        }
    }
}

