/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.client.collections.BaseIterator;
import com.sleepycat.client.collections.DataCursor;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.collections.StoredCollection;
import com.sleepycat.client.collections.StoredContainer;
import com.sleepycat.client.collections.StoredIterator;
import com.sleepycat.client.collections.StoredMapEntry;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet<K, V>
extends StoredCollection<Map.Entry<K, V>>
implements Set<Map.Entry<K, V>> {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    @Override
    public boolean add(Map.Entry<K, V> entry) {
        return this.add(entry.getKey(), entry.getValue());
    }

    @Override
    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            Map.Entry entry = (Map.Entry)object;
            SOperationStatus sOperationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (sOperationStatus == SOperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return sOperationStatus == SOperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            Map.Entry entry = (Map.Entry)object;
            SOperationStatus sOperationStatus = dataCursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = sOperationStatus == SOperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        StoredIterator storedIterator = null;
        try {
            Object object;
            storedIterator = this.storedIterator();
            while (storedIterator.hasNext()) {
                object = (Map.Entry)storedIterator.next();
                if (stringBuilder.length() > 1) {
                    stringBuilder.append(',');
                }
                Object k = object.getKey();
                Object v = object.getValue();
                if (k != null) {
                    stringBuilder.append(k.toString());
                }
                stringBuilder.append('=');
                if (v == null) continue;
                stringBuilder.append(v.toString());
            }
            stringBuilder.append(']');
            object = stringBuilder.toString();
            return object;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        finally {
            StoredIterator.close(storedIterator);
        }
    }

    @Override
    Map.Entry<K, V> makeIteratorData(BaseIterator baseIterator, SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        return new StoredMapEntry(this.view.makeKey(sDatabaseEntry, sDatabaseEntry2), this.view.makeValue(sDatabaseEntry2, sDatabaseEntry3), this, baseIterator);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

