/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.collections;

import com.sleepycat.client.SCursor;
import com.sleepycat.client.SCursorConfig;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.collections.DataView;
import com.sleepycat.client.compat.DbCompat;
import com.sleepycat.client.util.keyrange.KeyRange;
import com.sleepycat.client.util.keyrange.RangeCursor;

class MyRangeCursor
extends RangeCursor {
    private DataView view;
    private boolean isRecnoOrQueue;
    private boolean writeCursor;

    MyRangeCursor(KeyRange keyRange, SCursorConfig sCursorConfig, DataView dataView, boolean bl) throws SDatabaseException {
        super(keyRange, dataView.dupsRange, dataView.dupsOrdered, MyRangeCursor.openCursor(dataView, sCursorConfig, bl));
        this.view = dataView;
        this.isRecnoOrQueue = dataView.recNumAllowed && !dataView.btreeRecNumDb;
        this.writeCursor = MyRangeCursor.isWriteCursor(sCursorConfig, bl);
    }

    private static boolean isWriteCursor(SCursorConfig sCursorConfig, boolean bl) {
        return DbCompat.getWriteCursor(sCursorConfig) || sCursorConfig == SCursorConfig.DEFAULT && bl;
    }

    private static SCursor openCursor(DataView dataView, SCursorConfig sCursorConfig, boolean bl) throws SDatabaseException {
        return dataView.currentTxn.openCursor(dataView.db, sCursorConfig, MyRangeCursor.isWriteCursor(sCursorConfig, bl), dataView.useTransaction());
    }

    @Override
    protected SCursor dupCursor(SCursor sCursor, boolean bl) throws SDatabaseException {
        return this.view.currentTxn.dupCursor(sCursor, this.writeCursor, bl);
    }

    @Override
    protected void closeCursor(SCursor sCursor) throws SDatabaseException {
        this.view.currentTxn.closeCursor(sCursor);
    }

    @Override
    protected boolean checkRecordNumber() {
        return this.isRecnoOrQueue;
    }
}

