/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client.bind.serial;

import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.bind.serial.ClassCatalog;
import com.sleepycat.client.util.RuntimeExceptionWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class SerialOutput
extends ObjectOutputStream {
    private static final byte[] STREAM_HEADER;
    private ClassCatalog classCatalog;

    public SerialOutput(OutputStream outputStream, ClassCatalog classCatalog) throws IOException {
        super(outputStream);
        this.classCatalog = classCatalog;
        this.useProtocolVersion(2);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        try {
            byte[] byArray = this.classCatalog.getClassID(objectStreamClass);
            this.writeByte(byArray.length);
            this.write(byArray);
        }
        catch (SDatabaseException sDatabaseException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(sDatabaseException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(classNotFoundException);
        }
    }

    public static byte[] getStreamHeader() {
        return STREAM_HEADER;
    }

    static {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new SerialOutput(byteArrayOutputStream, null);
        }
        catch (IOException iOException) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(iOException);
        }
        STREAM_HEADER = byteArrayOutputStream.toByteArray();
    }
}

