/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SForeignKeyDeleteAction;
import com.sleepycat.client.SForeignKeyNullifier;
import com.sleepycat.client.SForeignMultiKeyNullifier;
import com.sleepycat.client.SSecondaryKeyCreator;
import com.sleepycat.client.SSecondaryMultiKeyCreator;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.thrift.TDatabaseConfig;
import com.sleepycat.thrift.TFKDeleteAction;
import com.sleepycat.thrift.TSecondaryDatabaseConfig;

public class SSecondaryConfig
extends SDatabaseConfig {
    private final SecondaryConfigWrapper wrapper;
    private SDatabase foreign;
    private boolean allowPopulate = false;
    private SSecondaryKeyCreator keyCreator;
    private SSecondaryMultiKeyCreator multiKeyCreator;
    private SForeignKeyNullifier keyNullifier;
    private SForeignMultiKeyNullifier multiKeyNullifier;

    public SSecondaryConfig() {
        this.wrapper = new SecondaryConfigWrapper(new TSecondaryDatabaseConfig());
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setDbConfig((TDatabaseConfig)super.getThriftObj());
    }

    SSecondaryConfig(SSecondaryConfig sSecondaryConfig) {
        this(sSecondaryConfig, ((TDatabaseConfig)sSecondaryConfig.getThriftObj()).deepCopy());
    }

    SSecondaryConfig(SSecondaryConfig sSecondaryConfig, TDatabaseConfig tDatabaseConfig) {
        super(tDatabaseConfig);
        this.wrapper = new SecondaryConfigWrapper(((TSecondaryDatabaseConfig)sSecondaryConfig.wrapper.getThriftObj()).deepCopy());
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setDbConfig((TDatabaseConfig)super.getThriftObj());
        this.allowPopulate = sSecondaryConfig.allowPopulate;
        this.foreign = sSecondaryConfig.foreign;
        this.keyCreator = sSecondaryConfig.keyCreator;
        this.multiKeyCreator = sSecondaryConfig.multiKeyCreator;
        this.keyNullifier = sSecondaryConfig.keyNullifier;
        this.multiKeyNullifier = sSecondaryConfig.multiKeyNullifier;
    }

    static TSecondaryDatabaseConfig nullSafeGet(SSecondaryConfig sSecondaryConfig) {
        return sSecondaryConfig == null ? null : (TSecondaryDatabaseConfig)sSecondaryConfig.wrapper.getThriftObj();
    }

    @Override
    public SSecondaryConfig cloneConfig() {
        return new SSecondaryConfig(this);
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public SSecondaryConfig setAllowPopulate(boolean bl) {
        this.allowPopulate = bl;
        return this;
    }

    public boolean getImmutableSecondaryKey() {
        return (Boolean)this.wrapper.getField(TSecondaryDatabaseConfig._Fields.IMMUTABLE_SECONDARY_KEY);
    }

    public SSecondaryConfig setImmutableSecondaryKey(boolean bl) {
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setImmutableSecondaryKey(bl);
        return this;
    }

    public SDatabase getForeignKeyDatabase() {
        return this.foreign;
    }

    public SSecondaryConfig setForeignKeyDatabase(SDatabase sDatabase) {
        this.foreign = sDatabase;
        if (sDatabase == null) {
            ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).unsetForeignDb();
        } else {
            ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setForeignDb(sDatabase.getThriftObj());
        }
        return this;
    }

    public SForeignKeyDeleteAction getForeignKeyDeleteAction() {
        TFKDeleteAction tFKDeleteAction = (TFKDeleteAction)this.wrapper.getField(TSecondaryDatabaseConfig._Fields.FOREIGN_KEY_DELETE_ACTION);
        return SForeignKeyDeleteAction.toBdb(tFKDeleteAction);
    }

    public SSecondaryConfig setForeignKeyDeleteAction(SForeignKeyDeleteAction sForeignKeyDeleteAction) {
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setForeignKeyDeleteAction(SForeignKeyDeleteAction.toThrift(sForeignKeyDeleteAction));
        return this;
    }

    public SSecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public SSecondaryConfig setKeyCreator(SSecondaryKeyCreator sSecondaryKeyCreator) {
        this.keyCreator = sSecondaryKeyCreator;
        return this;
    }

    public SSecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    public void setMultiKeyCreator(SSecondaryMultiKeyCreator sSecondaryMultiKeyCreator) {
        this.multiKeyCreator = sSecondaryMultiKeyCreator;
    }

    public SForeignKeyNullifier getForeignKeyNullifier() {
        return this.keyNullifier;
    }

    public void setForeignKeyNullifier(SForeignKeyNullifier sForeignKeyNullifier) {
        this.keyNullifier = sForeignKeyNullifier;
    }

    public SForeignMultiKeyNullifier getForeignMultiKeyNullifier() {
        return this.multiKeyNullifier;
    }

    public void setForeignMultiKeyNullifier(SForeignMultiKeyNullifier sForeignMultiKeyNullifier) {
        this.multiKeyNullifier = sForeignMultiKeyNullifier;
    }

    private static class SecondaryConfigWrapper
    extends ThriftWrapper<TSecondaryDatabaseConfig, TSecondaryDatabaseConfig._Fields> {
        SecondaryConfigWrapper(TDatabaseConfig tDatabaseConfig) {
            super(new TSecondaryDatabaseConfig().setDbConfig(tDatabaseConfig));
        }

        SecondaryConfigWrapper(TSecondaryDatabaseConfig tSecondaryDatabaseConfig) {
            super(tSecondaryDatabaseConfig);
        }
    }
}

