/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.RemoteCallHelper;
import com.sleepycat.client.SDatabaseEntry;
import com.sleepycat.client.SDatabaseEntryBase;
import com.sleepycat.client.SDatabaseException;
import com.sleepycat.client.SMultipleDataEntry;
import com.sleepycat.client.SMultiplePairs;
import com.sleepycat.client.SOperationStatus;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TGetResult;
import com.sleepycat.thrift.TGetWithPKeyResult;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TKeyDataWithPKey;
import com.sleepycat.thrift.TOperationStatus;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.thrift.TException;

interface GetHelper
extends RemoteCallHelper {
    default public TKeyData createGetSearchTerm(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase) {
        TKeyData tKeyData = new TKeyData();
        if (sDatabaseEntry != null) {
            tKeyData.setKey((TDbt)sDatabaseEntry.getThriftObj());
        }
        if (sDatabaseEntryBase instanceof SDatabaseEntry) {
            tKeyData.setData((TDbt)((SDatabaseEntry)sDatabaseEntryBase).getThriftObj());
        } else if (sDatabaseEntryBase != null) {
            tKeyData.setData(new TDbt());
        }
        return tKeyData;
    }

    default public TKeyDataWithPKey createPGetSearchTerm(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3) {
        TKeyDataWithPKey tKeyDataWithPKey = new TKeyDataWithPKey();
        if (sDatabaseEntry != null) {
            tKeyDataWithPKey.setSkey((TDbt)sDatabaseEntry.getThriftObj());
        }
        if (sDatabaseEntry2 != null) {
            tKeyDataWithPKey.setPkey((TDbt)sDatabaseEntry2.getThriftObj());
        }
        if (sDatabaseEntry3 != null) {
            tKeyDataWithPKey.setPdata((TDbt)sDatabaseEntry3.getThriftObj());
        }
        return tKeyDataWithPKey;
    }

    default public void updateKeyData(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, List<TKeyData> list) {
        if (list.isEmpty()) {
            return;
        }
        if (sDatabaseEntryBase instanceof SMultiplePairs) {
            ((SMultiplePairs)sDatabaseEntryBase).setEntriesFromKeyDatas(list);
        } else {
            TKeyData tKeyData2 = list.get(0);
            if (sDatabaseEntry != null) {
                sDatabaseEntry.setDataFromTDbt(tKeyData2.key);
            }
            if (sDatabaseEntryBase instanceof SDatabaseEntry) {
                ((SDatabaseEntry)sDatabaseEntryBase).setDataFromTDbt(tKeyData2.data);
            } else if (sDatabaseEntryBase instanceof SMultipleDataEntry) {
                ((SMultipleDataEntry)sDatabaseEntryBase).setEntriesFromDbts(list.stream().map(tKeyData -> tKeyData.data).collect(Collectors.toList()));
            }
        }
    }

    default public void updateTuple(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, TKeyDataWithPKey tKeyDataWithPKey) {
        if (sDatabaseEntry != null) {
            sDatabaseEntry.setDataFromTDbt(tKeyDataWithPKey.skey);
        }
        if (sDatabaseEntry2 != null) {
            sDatabaseEntry2.setDataFromTDbt(tKeyDataWithPKey.pkey);
        }
        if (sDatabaseEntry3 != null) {
            sDatabaseEntry3.setDataFromTDbt(tKeyDataWithPKey.pdata);
        }
    }

    default public SOperationStatus remoteGet(SDatabaseEntry sDatabaseEntry, SDatabaseEntryBase sDatabaseEntryBase, RemoteGetFunction remoteGetFunction) throws SDatabaseException {
        TKeyData tKeyData = this.createGetSearchTerm(sDatabaseEntry, sDatabaseEntryBase);
        return this.remoteCall(() -> {
            TGetResult tGetResult = remoteGetFunction.applyWithException(tKeyData);
            if (tGetResult.status == TOperationStatus.SUCCESS) {
                this.updateKeyData(sDatabaseEntry, sDatabaseEntryBase, tGetResult.pairs);
                return SOperationStatus.SUCCESS;
            }
            return SOperationStatus.toBdb(tGetResult.status);
        });
    }

    default public SOperationStatus remotePGet(SDatabaseEntry sDatabaseEntry, SDatabaseEntry sDatabaseEntry2, SDatabaseEntry sDatabaseEntry3, RemotePGetFunction remotePGetFunction) throws SDatabaseException {
        if (sDatabaseEntry2 != null && sDatabaseEntry2.getPartial()) {
            throw new IllegalArgumentException("Partial primary key is not supported.");
        }
        TKeyDataWithPKey tKeyDataWithPKey = this.createPGetSearchTerm(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3);
        return this.remoteCall(() -> {
            TGetWithPKeyResult tGetWithPKeyResult = remotePGetFunction.applyWithException(tKeyDataWithPKey);
            if (tGetWithPKeyResult.status == TOperationStatus.SUCCESS) {
                this.updateTuple(sDatabaseEntry, sDatabaseEntry2, sDatabaseEntry3, tGetWithPKeyResult.tuple);
                return SOperationStatus.SUCCESS;
            }
            return SOperationStatus.toBdb(tGetWithPKeyResult.status);
        });
    }

    @FunctionalInterface
    public static interface RemotePGetFunction {
        public TGetWithPKeyResult applyWithException(TKeyDataWithPKey var1) throws TException;
    }

    @FunctionalInterface
    public static interface RemoteGetFunction {
        public TGetResult applyWithException(TKeyData var1) throws TException;
    }
}

