/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LockMode;
import com.sleepycat.server.util.Adapters;
import com.sleepycat.thrift.TCursorGetConfig;
import com.sleepycat.thrift.TDbGetConfig;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TIsolationLevel;
import com.sleepycat.thrift.TJoinCursorGetConfig;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TKeyDataWithPKey;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;

public class GetArgs {
    public DatabaseEntry key;
    public DatabaseEntry pKey;
    public DatabaseEntry data;
    public LockMode lockMode;

    public GetArgs(TKeyData tKeyData, TDbGetConfig tDbGetConfig) {
        this.constructEntries(tKeyData);
        this.handleConfig(tDbGetConfig);
    }

    public GetArgs(TKeyDataWithPKey tKeyDataWithPKey, TDbGetConfig tDbGetConfig) {
        this.constructEntries(tKeyDataWithPKey);
        this.handleConfig(tDbGetConfig);
    }

    public GetArgs(TKeyData tKeyData, TCursorGetConfig tCursorGetConfig) {
        this.constructEntries(tKeyData);
        this.handleConfig(tCursorGetConfig);
    }

    public GetArgs(TJoinCursorGetConfig tJoinCursorGetConfig) {
        this.constructEntries(tJoinCursorGetConfig.pair);
        this.lockMode = tJoinCursorGetConfig.isSetRmw() && tJoinCursorGetConfig.rmw ? LockMode.RMW : (tJoinCursorGetConfig.isSetReadUncommitted() && tJoinCursorGetConfig.readUncommitted ? LockMode.READ_UNCOMMITTED : LockMode.DEFAULT);
    }

    public GetArgs(TKeyDataWithPKey tKeyDataWithPKey, TCursorGetConfig tCursorGetConfig) {
        this.constructEntries(tKeyDataWithPKey);
        this.handleConfig(tCursorGetConfig);
    }

    private void constructEntries(TKeyData tKeyData) {
        this.key = this.getDatabaseEntry(tKeyData, TKeyData._Fields.KEY);
        this.data = this.getDatabaseEntry(tKeyData, TKeyData._Fields.DATA);
    }

    private void constructEntries(TKeyDataWithPKey tKeyDataWithPKey) {
        this.key = this.getDatabaseEntry(tKeyDataWithPKey, TKeyDataWithPKey._Fields.SKEY);
        this.pKey = this.getDatabaseEntry(tKeyDataWithPKey, TKeyDataWithPKey._Fields.PKEY);
        this.data = this.getDatabaseEntry(tKeyDataWithPKey, TKeyDataWithPKey._Fields.PDATA);
    }

    private void handleConfig(TDbGetConfig tDbGetConfig) {
        this.lockMode = this.getLockMode(tDbGetConfig, TDbGetConfig._Fields.RMW, TDbGetConfig._Fields.ISO_LEVEL);
    }

    private void handleConfig(TCursorGetConfig tCursorGetConfig) {
        this.lockMode = this.getLockMode(tCursorGetConfig, TCursorGetConfig._Fields.RMW, TCursorGetConfig._Fields.ISO_LEVEL);
    }

    private <T extends TBase<T, F>, F extends TFieldIdEnum> DatabaseEntry getDatabaseEntry(T t, F f) {
        TDbt tDbt = null;
        if (t != null && t.isSet(f)) {
            tDbt = (TDbt)t.getFieldValue(f);
        }
        return Adapters.toBdbType(tDbt);
    }

    private <T extends TBase<T, F>, F extends TFieldIdEnum> LockMode getLockMode(T t, F f, F f2) {
        if (t.isSet(f) && ((Boolean)t.getFieldValue(f)).booleanValue()) {
            return LockMode.RMW;
        }
        if (!t.isSet(f2)) {
            return LockMode.DEFAULT;
        }
        switch ((TIsolationLevel)t.getFieldValue(f2)) {
            case READ_COMMITTED: {
                return LockMode.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return LockMode.READ_UNCOMMITTED;
            }
        }
        throw new IllegalArgumentException("Invalid isolation level.");
    }
}

