/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.handle;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.SecondaryDatabase;
import com.sleepycat.server.handle.DatabaseKey;
import com.sleepycat.server.handle.EnvironmentDescriptor;
import com.sleepycat.server.handle.HandleDescriptor;
import com.sleepycat.server.handle.ResourceKey;
import com.sleepycat.server.handle.SecondaryDatabaseDescriptor;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;

public class DatabaseDescriptor
extends HandleDescriptor<Database> {
    private ConcurrentLinkedDeque<SecondaryDatabaseDescriptor> secondaries;
    private ConcurrentLinkedDeque<SecondaryDatabaseDescriptor> foreignKeys;

    public DatabaseDescriptor(Database database, DatabaseKey databaseKey, EnvironmentDescriptor environmentDescriptor) {
        super(database, databaseKey, environmentDescriptor);
        this.secondaries = new ConcurrentLinkedDeque();
        this.foreignKeys = new ConcurrentLinkedDeque();
    }

    protected DatabaseDescriptor(SecondaryDatabase secondaryDatabase, DatabaseKey databaseKey, EnvironmentDescriptor environmentDescriptor, DatabaseDescriptor databaseDescriptor) {
        super(secondaryDatabase, databaseKey, environmentDescriptor, databaseDescriptor);
    }

    protected void associate(SecondaryDatabaseDescriptor secondaryDatabaseDescriptor) {
        this.secondaries.add(secondaryDatabaseDescriptor);
    }

    protected void disassociate(SecondaryDatabaseDescriptor secondaryDatabaseDescriptor) {
        this.secondaries.remove(secondaryDatabaseDescriptor);
    }

    protected void associateForeign(SecondaryDatabaseDescriptor secondaryDatabaseDescriptor) {
        this.foreignKeys.add(secondaryDatabaseDescriptor);
    }

    protected void disassociateForeign(SecondaryDatabaseDescriptor secondaryDatabaseDescriptor) {
        this.foreignKeys.remove(secondaryDatabaseDescriptor);
    }

    @Override
    public DatabaseKey getResourceKey() {
        return (DatabaseKey)super.getResourceKey();
    }

    @Override
    public ResourceKey[] resourceOwners() {
        DatabaseKey databaseKey = this.getResourceKey();
        if (databaseKey.getDatabaseName() == null) {
            return new ResourceKey[]{databaseKey.getDatabaseFile()};
        }
        return new ResourceKey[]{databaseKey.getDatabaseFile(), databaseKey};
    }

    @Override
    protected void closeBdbHandle() throws DatabaseException {
        ((Database)this.getHandle()).close();
    }

    public boolean hasSecondaryDb() {
        return !this.secondaries.isEmpty();
    }

    public void forEachSecondary(Consumer<SecondaryDatabaseDescriptor> consumer) {
        this.secondaries.forEach(consumer);
    }

    public void forEachForeignSecondary(Consumer<SecondaryDatabaseDescriptor> consumer) {
        this.foreignKeys.forEach(consumer);
    }
}

