/* These must go first. Some set explicit values. */
#define ALTERNATE(name, val)          T(_CXX, T_##name, #name,  val)
#define PUNCTUATOR(name, string, val) T(_ALL, T_##name, string, val)
#include "tokens_punctuator.inc"
#undef PUNCTUATOR
#undef ALTERNATE

#define S(name, description) T(_ALL, T_##name, description,)
S(EOF,                "end of input")
S(IDENTIFIER,         "identifier")
S(NUMBER,             "number constant")
S(CHARACTER_CONSTANT, "character constant")
S(STRING_LITERAL,     "string literal")
S(MACRO_PARAMETER,    "macro parameter")
S(UNKNOWN_CHAR,       "unknown character")
#undef S

#define S(mode,x)   T(mode,T_##x,#x,)
S(_ALL, auto)
S(_ALL, break)
S(_ALL, case)
S(_ALL, char)
S(_ALL, continue)
S(_ALL, default)
S(_ALL, do)
S(_ALL, double)
S(_ALL, else)
S(_ALL, enum)
S(_ALL, extern)
S(_ALL, float)
S(_ALL, for)
S(_ALL, goto)
S(_ALL, if)
S(_ALL, int)
S(_ALL, long)
S(_ALL, register)
S(_ALL, return)
S(_ALL, short)
S(_ALL, sizeof)
S(_ALL, static)
S(_ALL, struct)
S(_ALL, switch)
S(_ALL, typedef)
S(_ALL, union)
S(_ALL, unsigned)
S(_ALL, void)
S(_ALL, while)

/* C++ keywords */
S(_CXX, bool)
S(_CXX, catch)
S(_CXX, class)
S(_CXX, const_cast)
S(_CXX, delete)
S(_CXX, dynamic_cast)
S(_CXX, explicit)
S(_CXX, export)
S(_CXX, false)
S(_CXX, friend)
S(_CXX, mutable)
S(_CXX, namespace)
S(_CXX, new)
S(_CXX, operator)
S(_CXX, private)
S(_CXX, protected)
S(_CXX, public)
S(_CXX, reinterpret_cast)
S(_CXX, static_cast)
S(_CXX, template)
S(_CXX, this)
S(_CXX, throw)
S(_CXX, true)
S(_CXX, try)
S(_CXX, typeid)
S(_CXX, typename)
S(_CXX, using)
S(_CXX, virtual)
S(_CXX, wchar_t)

S(_C99|_GNUC, _Bool)

S(_C11, _Alignas)
S(_C11, _Atomic)
S(_C11, _Generic)
S(_C11, _Noreturn)
S(_C11, _Static_assert)

S(_ALL, __extension__)
S(_ALL, __builtin_classify_type)
S(_ALL, __builtin_va_list)
S(_ALL, __builtin_va_arg)
S(_ALL, __builtin_va_copy)
S(_ALL, __builtin_offsetof)
S(_ALL, __builtin_constant_p)
S(_ALL, __builtin_types_compatible_p)
S(_ALL, __builtin_isgreater)
S(_ALL, __builtin_isgreaterequal)
S(_ALL, __builtin_isless)
S(_ALL, __builtin_islessequal)
S(_ALL, __builtin_islessgreater)
S(_ALL, __builtin_isunordered)
S(_ALL, __PRETTY_FUNCTION__)
S(_ALL, __label__)
S(_MS, __FUNCSIG__)
S(_MS, __FUNCDNAME__)
#undef S

#define S(mode, x, val) T(mode, T_##x, #x, val)
S(_C99,            __func__,)
S(_ALL,            __FUNCTION__,           = T___func__)
S(_C11,             _Thread_local,         )
S(_ALL,            __thread,               = T__Thread_local)
S(_ALL,              signed,               )
S(_ALL,            __signed,               = T_signed)
S(_ALL,            __signed__,             = T_signed)
S(_C99|_GNUC,       _Complex,              )
S(_ALL,            __complex__,            = T__Complex)
S(_ALL,            __complex,              = T__Complex)
S(_C99|_GNUC,       _Imaginary,            )
S(_ALL,            __real__,               )
S(_ALL,            __real,                 = T___real__)
S(_ALL,            __imag__,               )
S(_ALL,            __imag,                 = T___imag__)
S(_C11,             _Alignof,              )
S(_ALL,            __alignof__,            = T__Alignof)
S(_ALL,            __alignof,              = T__Alignof)
S(_MS,              _alignof,              = T__Alignof)
S(_ALL,              const,                )
S(_ALL,            __const,                = T_const)
S(_ALL,            __const__,              = T_const)
S(_C99,              restrict,             )
S(_ALL,            __restrict__,           = T_restrict)
S(_ALL,            __restrict,             = T_restrict)
S(_MS,              _restrict,             = T_restrict)
S(_ALL,              asm,                  )
S(_ALL,            __asm__,                = T_asm)
S(_MS,              _asm,                  = T_asm)
S(_ALL,            __asm,                  = T_asm)
S(_ALL,              volatile,             )
S(_ALL,            __volatile,             = T_volatile)
S(_ALL,            __volatile__,           = T_volatile)
S(_C99|_CXX|_GNUC,   inline,               )
S(_ALL,            __inline,               = T_inline)
S(_ALL,            __inline__,             = T_inline)
S(_GNUC,             typeof,               )
S(_ALL,            __typeof,               = T_typeof)
S(_ALL,            __typeof__,             = T_typeof)
S(_ALL,            __attribute__,          )

S(_ALL,            __builtin_va_start,     )
S(_ALL,            __builtin_stdarg_start, = T___builtin_va_start)

S(_MS,              _near,                 )
S(_MS,             __near,                 = T__near)
S(_MS,              _far,                  )
S(_MS,             __far,                  = T__far)
S(_MS,               cdecl,                )
S(_MS,              _cdecl,                = T_cdecl)
S(_MS,             __cdecl,                = T_cdecl)
S(_MS,              _stdcall,              )
S(_MS,             __stdcall,              = T__stdcall)
S(_MS,              _fastcall,             )
S(_MS,             __fastcall,             = T__fastcall)
S(_MS,             __thiscall,             )
S(_MS,              _forceinline,          )
S(_MS,             __forceinline,          = T__forceinline)
S(_MS,             __unaligned,            )
S(_MS,              _assume,               )
S(_MS,             __assume,               = T__assume)
S(_MS,              _try,                  )
S(_MS,             __try,                  = T__try)
S(_MS,              _finally,              )
S(_MS,             __finally,              = T__finally)
S(_MS,              _leave,                )
S(_MS,             __leave,                = T__leave)
S(_MS,              _except,               )
S(_MS,             __except,               = T__except)
S(_MS,              _declspec,             )
S(_MS,             __declspec,             = T__declspec)
S(_MS,              _based,                )
S(_MS,             __based,                = T__based)
S(_MS,             __noop,                 )

S(_MS,             __ptr32,                )
S(_MS,             __ptr64,                )
S(_MS,             __sptr,                 )
S(_MS,             __uptr,                 )
S(_MS,              _w64,                  )
S(_MS,             __w64,                  = T__w64)

S(_MS,              _int8,                 )
S(_MS,             __int8,                 = T__int8)
S(_MS,              _int16,                )
S(_MS,             __int16,                = T__int16)
S(_MS,              _int32,                )
S(_MS,             __int32,                = T__int32)
S(_MS,              _int64,                )
S(_MS,             __int64,                = T__int64)
S(_MS,              _int128,               )
S(_MS,             __int128,               = T__int128)
#undef S

/* Redefine required macros for MinGW headers */
#if defined(__MINGW32__) || defined(__CYGWIN__)
#define __stdcall __attribute__((__stdcall__))
#define __fastcall __attribute__((__fastcall__))
#define __cdecl __attribute__((__cdecl__))
#endif
