pub mod assignees;
pub mod branch;
pub mod clone;
pub mod create;
pub mod delete;
pub mod fork;
pub mod info;
pub mod list;
pub mod migrate;
pub mod open;

use clap::Subcommand;

use super::GlobalArgs;

/// Repository subcommands
#[derive(Subcommand, Debug)]
pub enum RepoArgs {
    Create(create::RepoCreateArgs),
    Clone(clone::RepoCloneArgs),
    Delete(delete::RepoDeleteArgs),
    Fork(fork::RepoForkArgs),
    Info(info::RepoInfoArgs),
    Assignees(assignees::RepoAssigneesArgs),
    Migrate(migrate::RepoMigrateArgs),
    List(list::RepoListArgs),
    Open(open::RepoOpenArgs),
    #[command(subcommand)]
    Branch(branch::BranchArgs),
}

impl RepoArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            RepoArgs::Create(args) => args.run(global_args).await,
            RepoArgs::Clone(args) => args.run(global_args).await,
            RepoArgs::Delete(args) => args.run(global_args).await,
            RepoArgs::Fork(args) => args.run(global_args).await,
            RepoArgs::Info(args) => args.run(global_args).await,
            RepoArgs::Assignees(args) => args.run(global_args).await,
            RepoArgs::Migrate(args) => args.run(global_args).await,
            RepoArgs::List(args) => args.run(global_args).await,
            RepoArgs::Open(args) => args.run(global_args).await,
            RepoArgs::Branch(args) => args.run(global_args).await,
        }
    }
}
