mod add;
mod list;
mod remove;

use clap::Subcommand;

use crate::render::option::option_display;

use super::GlobalArgs;

/// Ssh key management
#[derive(Subcommand, Debug)]
pub enum SshArgs {
    List(list::ListSshArgs),
    Add(add::AddSshArgs),
    Remove(remove::RemoveSshArgs),
}

impl SshArgs {
    pub async fn run(self, global_args: GlobalArgs) -> miette::Result<()> {
        match self {
            SshArgs::List(args) => args.run(global_args).await,
            SshArgs::Add(args) => args.run(global_args).await,
            SshArgs::Remove(args) => args.run(global_args).await,
        }
    }
}

pub fn ssh_key_identifier(key: &forgejo_api::structs::PublicKey) -> String {
    format!(
        "{title} {user} {fingerprint}",
        fingerprint = option_display(&key.fingerprint),
        title = option_display(&key.title),
        user = option_display(&key.user.as_ref().and_then(|user| user.login.as_ref())),
    )
}
