#open "syntaxe";;
#open "envir";;

let vrifie_type message type_attendu type_rel =
  if type_attendu <> type_rel then
    raise(Erreur_typage(Conflit(message, type_attendu, type_rel)));;

let vrifie_tableau = function
    Array(inf, sup, lments) -> lments
  | _ -> raise(Erreur_typage(Tableau_attendu));;

let vrifie_non_tableau message = function
    Array(inf, sup, lments) ->
      raise(Erreur_typage(Tableau_interdit message))
  | _ -> ();;
let rec type_expr env = function
    Constante(Entire n) -> Integer
  | Constante(Boolenne b) -> Boolean
  | Variable nom_var ->
      cherche_variable nom_var env
  | Application(nom_fonc, args) ->
      let fonc = cherche_fonction nom_fonc env in
      type_application env nom_fonc fonc.fonc_paramtres args;
      fonc.fonc_type_rsultat
  | Op_unaire(op, arg) ->
      let (type_arg, type_res) = type_op_unaire op in
      vrifie_type ("l'argument de " ^ op)
                   type_arg (type_expr env arg);
      type_res
  | Op_binaire(op, arg1, arg2) ->
      let (type_arg1, type_arg2, type_res) = type_op_binaire op in
      vrifie_type ("le premier argument de " ^ op)
                   type_arg1 (type_expr env arg1);
      vrifie_type ("le deuxime argument de " ^ op)
                   type_arg2 (type_expr env arg2);
      type_res
  | Accs_tableau(expr1, expr2) ->
      let type_lments = vrifie_tableau (type_expr env expr1) in
      vrifie_type "l'indice de tableau"
                   Integer (type_expr env expr2);
      type_lments

and type_application env nom paramtres arguments =
  let nbr_paramtres = list_length paramtres
  and nbr_arguments = list_length arguments in
  if nbr_paramtres <> nbr_arguments then
    raise(Erreur_typage(Arit(nom, nbr_paramtres, nbr_arguments)));
  let type_paramtre (nom_param, type_param) argument =
    vrifie_type ("le paramtre " ^ nom_param ^ " de " ^ nom)
                 type_param (type_expr env argument) in
  do_list2 type_paramtre paramtres arguments

and type_op_unaire = function
    "-" -> (Integer, Integer)
  | "not" -> (Boolean, Boolean)

and type_op_binaire = function
    "*" | "/" | "+" | "-" -> (Integer,Integer,Integer)
  | "=" | "<>" | "<" | ">" | "<=" | ">=" -> (Integer,Integer,Boolean)
  | "and" | "or" -> (Boolean,Boolean,Boolean);;
let rec type_instr env = function
    Affectation_var(nom_var, expr) ->
      let type_var = cherche_variable nom_var env in
      vrifie_non_tableau ("affectation de " ^ nom_var) type_var;
      vrifie_type ("la variable " ^ nom_var)
                   type_var (type_expr env expr)
  | Affectation_tableau(expr1, expr2, expr3) ->
      let type_lments = vrifie_tableau (type_expr env expr1) in
      vrifie_non_tableau "affectation de tableau" type_lments;
      vrifie_type "l'indice de tableau"
                   Integer (type_expr env expr2);
      vrifie_type "affectation de tableau"
                   type_lments (type_expr env expr3)
  | Appel(nom_proc, args) ->
      let proc = cherche_procdure nom_proc env in
      type_application env nom_proc proc.proc_paramtres args
  | If(condition, branche_oui, branche_non) ->
      vrifie_type "la condition de IF"
                   Boolean (type_expr env condition);
      type_instr env branche_oui;
      type_instr env branche_non
  | While(condition, corps) ->
      vrifie_type "la condition de WHILE"
                   Boolean (type_expr env condition);
      type_instr env corps
  | Write expr ->
      vrifie_type "l'argument de WRITE"
                   Integer (type_expr env expr)
  | Read nom_var ->
      vrifie_type "l'argument de READ"
                   Integer (cherche_variable nom_var env)
  | Bloc liste ->
      do_list (type_instr env) liste;;
let ajoute_var (nom, typ) env = ajoute_variable nom typ env;;

let type_procdure env_global (nom, dcl) =
  let env =
    list_it ajoute_var
            (dcl.proc_variables @ dcl.proc_paramtres)
            env_global in
  type_instr env dcl.proc_corps;;

let type_fonction env_global (nom, dcl) =
  vrifie_non_tableau
    ("passage comme rsultat de la fonction " ^ nom)
    dcl.fonc_type_rsultat;
  let env =
    list_it ajoute_var
            ((nom, dcl.fonc_type_rsultat) ::
              dcl.fonc_variables @ dcl.fonc_paramtres)
            env_global in
  type_instr env dcl.fonc_corps;;
let type_programme prog =
  let env_global =
    list_it ajoute_var prog.prog_variables
            (environnement_initial prog.prog_procdures
                                   prog.prog_fonctions) in
  try
    do_list (type_procdure env_global) prog.prog_procdures;
    do_list (type_fonction env_global) prog.prog_fonctions;
    type_instr env_global prog.prog_corps
  with Pas_trouv nom ->
    raise(Erreur_typage(Indfini nom));;
let rec affiche_type = function
    Integer -> prerr_string "integer"
  | Boolean -> prerr_string "boolean"
  | Array(inf, sup, ty) ->
      prerr_string "array ["; prerr_int inf; prerr_string ".."; 
      prerr_int sup; prerr_string "] of "; affiche_type ty;;

let affiche_erreur = function
    Indfini nom ->
      prerr_string "Nom inconnu: "; prerr_string nom;
      prerr_endline "."
  | Conflit(message, type_attendu, type_rel) ->
      prerr_string "Conflit de types: "; prerr_string message;
      prerr_string " devrait avoir le type ";
      affiche_type type_attendu;
      prerr_string " mais a le type "; affiche_type type_rel;
      prerr_endline "."
  | Arit(nom, nbr_paramtres, nbr_arguments) ->
      prerr_string "Mauvais nombre d'arguments: "; prerr_string nom;
      prerr_string " attend "; prerr_int nbr_paramtres;
      prerr_string " paramtre(s), mais est appele avec ";
      prerr_int nbr_arguments; prerr_endline " argument(s)."
  | Tableau_attendu ->
      prerr_endline "Accs dans un objet qui n'est pas un tableau."
  | Tableau_interdit message ->
      prerr_string "Opration interdite sur les tableaux: ";
      prerr_string message; prerr_endline ".";;
