/*

	$Id: main.c,v 1.10 2003/09/22 11:17:27 tron Exp $

*/

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "iprecord.h"
#include "ipstat.h"

char *Progname;
int Verbose = FALSE;

#define IN_NETWORK(a,n,m) (((a).s_addr&(m).s_addr)==(n).s_addr)

static void Usage(void)

{
 (void)fprintf(stderr,
               "Usage: %s [-i ignoredumpfile] [-v] configfile datafile "
               "[datafile ...]\n",
               Progname);
 exit(EXIT_FAILURE);
}

static u_int32_t ReadIPRecords(Match *List,FILE *In,FILE *Ignore)

{
 IPRecord IR;
 Match *Mt;
 Account *Acc;
 u_int32_t Ignored;

 Ignored=0;
 while (fread(&IR,sizeof(IPRecord),1,In)==1)
  {
   Mt=List;
   while (Mt!=NULL)
    {
     if (IN_NETWORK(IR.ir_SrcAddr,Mt->m_SrcAddr,Mt->m_SrcMask)&&
         IN_NETWORK(IR.ir_DstAddr,Mt->m_DstAddr,Mt->m_DstMask)&&
         ((Mt->m_Proto==0)||(Mt->m_Proto==IR.ir_Proto)))
      {
       if ((Mt->m_Proto==IPPROTO_TCP)||(Mt->m_Proto==IPPROTO_UDP))
        {
         if (((Mt->m_SrcPort==0)||(Mt->m_SrcPort==IR.ir_SrcPort))&&
             ((Mt->m_DstPort==0)||(Mt->m_DstPort==IR.ir_DstPort)))
          break;
        }
       else break;
      }

     Mt=Mt->m_Next;
    }

   if (Mt!=NULL)
    {
     Acc=Mt->m_Account;
     Acc->a_Packets+=IR.ir_Packets;
     Acc->a_Bytes+=IR.ir_Bytes;
    }
   else
    {
     Ignored++;
     if (Ignore!=NULL)
      {
       (void)fprintf(Ignore,"%s:%d ",inet_ntoa(IR.ir_SrcAddr),IR.ir_SrcPort);
       (void)fprintf(Ignore,"%s:%d ",inet_ntoa(IR.ir_DstAddr),IR.ir_DstPort);
       (void)fprintf(Ignore,
                     "%u %u %u\n",
                     IR.ir_Proto,
                     IR.ir_Packets,
                     IR.ir_Bytes);
      }
    }
  }

 return Ignored;
}

static void DumpAccounts(Account *Acc)

{
 int Index;

 (void)printf("%-31s %-15s %-15s\n","Account","Packets","Bytes");
 for (Index=0; Index<79; Index++) (void)putchar('-');
 (void)putchar('\n');

 while (Acc!=NULL)
  {
/* Hurtz */
   (void)printf("%-31s %-15u %u\n",
                Acc->a_Name,
                Acc->a_Packets,
                (u_int32_t)Acc->a_Bytes);

   Acc=Acc->a_Next;
  }
}
  
int main(int argc,char **argv)

{
 int Opt,Index;
 char *IgnoreFile;
 Config *Cfg;
 u_int32_t Ignored;
 FILE *Ignore;

 Progname=argv[0];

 IgnoreFile=NULL;
 while ((Opt=getopt(argc,argv,"i:v"))!=-1)
  switch (Opt)
   {
    case 'i':
     IgnoreFile=optarg;
     break;
    case 'v':
     Verbose=TRUE;
     break;
    default:
     Usage();
   }
 argc-=optind;
 argv+=optind;

 if (argc<2) Usage();

 if ((Cfg=ReadConfig(argv[0]))==NULL) return EXIT_FAILURE;

 if (IgnoreFile==NULL) Ignore=NULL;
 else
  if ((Ignore=fopen(IgnoreFile,"w"))==NULL)
   {
    (void)fprintf(stderr,
                  "%s: unable to open ignore dump file \"%s\".\n",
                  Progname,IgnoreFile);
    return EXIT_FAILURE;
   }

 Ignored=0;
 for (Index=1; Index<argc; Index++)
  if (strcmp(argv[Index],"-")==0)
   Ignored+=ReadIPRecords(Cfg->c_Matches,stdin,Ignore);
  else
   {
    FILE *In;

    if ((In=fopen(argv[Index],"r"))==NULL)
     {
      (void)fprintf(stderr,
                    "%s: unable to open data file \"%s\".\n",
                    Progname,argv[Index]);
      return EXIT_FAILURE;
     }

    if (Verbose) (void)fprintf(stderr,"Reading \"%s\".\n",argv[Index]);
    Ignored+=ReadIPRecords(Cfg->c_Matches,In,Ignore);

    (void)fclose(In);
   }

 if (Ignore!=NULL)
  {
   int Size;

   Size=ftell(Ignore);
   (void)fclose(Ignore);

   if (Size==0) (void)unlink(IgnoreFile);
  }

 if (Verbose) (void)fputc('\n',stderr);

 DumpAccounts(Cfg->c_Accounts);

 if (Verbose&&(Ignored>0))
  (void)fprintf(stderr,"\nIgnored %u packets.\n",Ignored);

 return EXIT_SUCCESS;
}
