" Vim syntax file
" Language: CDL3
" Authors: Erik Verbruggen <ejv@cs.kun.nl> and
"          Jaap Boender <jaapboen@sci.kun.nl>
" Last change: Tue Sep 19 12:19:43 MET DST 2000
syn clear

" Keywords
syn match		cdlBasicType	"\(INT\|TEXT\|FILE\)\([0-9]\|{[ ]*}\)*"
syn match		cdlType			"[A-Z]\+[0-9]*"	
syn match		cdlOperator		"->\|=\|+\|-\|\*\|%%\|%\|<<\|>>\|&\||\|^\|?\|!"
syn match		cdlNumber		"[+-]\=[0-9]\+" oneline
syn match		cdlTypeDef		"\([A-Z]\+[ ]*\)::\([ ]*[A-Za-z; ]\+[ ]*\.\)" oneline
syn match		cdlTypeEquiv	"\([A-Z, ]\+[ ]*\)=\([ ]*[A-Z]\+[ ]*\.\)" oneline
syn keyword		cdlProcedure	ACTION TEST PRED FUNCTION PRELUDE INTERLUDE POSTLUDE
syn keyword		cdlInclude		USES
syn keyword		cdlModule		MODULE DEFINES ROOT VERSIONID
syn region		cdlString		start=+"+ end=+"+
syn region		cdlGuard		start="\[" end="\]" contains=ALL
syn match		cdlComment		"#.*" oneline

if !exists("did_cdl3_syntax_init")
  let did_cdl3_syntax_init = 1
  hi link			cdlProcedure	Keyword
  hi link			cdlBasicType	Type
  hi link			cdlType			Type
  hi link			cdlString		String
  hi link			cdlNumber		Number
  hi link			cdlOperator		Operator
  hi link			cdlInclude		Include
  hi link			cdlModule		PreProc
  hi link			cdlGuard		Special
  hi link			cdlTypeDef		Typedef
  hi link			cdlTypeEquiv		Typedef
  hi link			cdlComment		Comment
endif

let b:current_syntax = "cdl3"
