#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

/* parse_request() - Request.* object */

int parse_request(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char token_obj[TOKENSIZE];
char molecule1[LINELENGTH];

  molecule1[0]=0;

  if ((tokentype=gettoken(token))!=14)
  {
    push(token,tokentype);
    convert_funct(molecule1,"1",1);
    sprintf(newtoken,"${%s}",molecule1);

    return 0;
  }

  tokentype=gettoken(token);

  if (strcasecmp(token,"servervariables")==0)
  { 
    convert_funct(molecule1,"1",1);
    sprintf(newtoken,"${%s}",molecule1);
    return 0;
  } 
    else
  if (strcasecmp(token,"form")==0)
  { 
    strcpy(token_obj,"HTTP_POST_VARS");
  }
    else
  if (strcasecmp(token,"querystring")==0)
  { 
    strcpy(token_obj,"HTTP_GET_VARS");
  }
    else
  if (strcasecmp(token,"cookies")==0)
  { 
    strcpy(token_obj,"HTTP_COOKIE_VARS");
  }
    else
  if (strcasecmp(token,"clientcertificate")==0)
  { 
    strcpy(token_obj,"HTTP_CERTIFICATE_VARS");
    printf("Warning: ClientCertificates are unsupported (line %d)\n",line);
  }
    else
  {
    strcat(newtoken,"// unsupported: "); eval_expression(" "); 
  }

  tokentype=gettoken(token);
  if (strcmp(token,".")==0)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"count")==0)
    { 
      sprintf(molecule1,"count($%s)",token_obj);
      strcat(newtoken,molecule1);
    }
  }
    else
  if (strcmp(token,"(")==0)
  {
    push(token,tokentype);

    convert_funct(molecule1,"1",1);
    sprintf(newtoken,"$%s[%s]",token_obj,molecule1);
  }
    else
  {
    push(token,tokentype);
    sprintf(molecule1,"$%s",token_obj);
    strcat(newtoken,molecule1);
  }

  return 0;
}

