#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "asp.xpm"

int convert=0;
GtkWidget *File_asp_dir;
GtkWidget *File_php_dir;
GtkWidget *Text_aspdir;
GtkWidget *Text_phpdir;
GtkWidget *Status;
GtkWidget *Dialog_help;
GtkWidget *Combo_database;
GtkWidget *Combo_case;
GtkWidget *Combo_php;
int context_id,status_count=0;
int pngs=0,html=0,global_asa=0;

char help_message[1024]={ "GTK asp2php - By Michael Kohn\n\n"
                  "To use:\n"
                  "(1) Select source asp dir by clicking on 'Select ASP Dir' button\n"
                  "(2) Select target php dir by clicking on 'Select PHP Dir' button\n"
                  "(3) Press 'Start Convert' button\n\n"
                  "NOTE: If you type in a directory for PHP Target dir and it doesn't\n"
                  "exist, asp2php will create all dirs needed to make the target exist\n\n"
                  "If you put GTK asp2php into PNGS (to convert GIFS to PNGS)\n"
                  "you must have ImageMagick's convert program in your path."};

void clear_status()
{

  while(status_count)
  {
    gtk_statusbar_pop(GTK_STATUSBAR(Status),(guint) &context_id);
    status_count--;
  }
}

void selected_asp (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (File_asp_dir);
  }
}

void selected_php (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (File_php_dir);
  }
}

void start (GtkWidget *widget, gpointer data)
{
char sourcedir[2048];
char targetdir[2048];
char command[2048];
char arguments[2048];
DIR *dp_asp;
DIR *dp_php;
int t;

  convert=1;
  strcpy(sourcedir,gtk_entry_get_text(GTK_ENTRY(Text_aspdir)));
  strcpy(targetdir,gtk_entry_get_text(GTK_ENTRY(Text_phpdir)));

  strcpy(arguments,"");

  if (pngs==1)
  { strcat(arguments," -pngs"); }

  if (html==1)
  { strcat(arguments," -html"); }

  if (global_asa==1)
  { strcat(arguments," -global_asa"); }

  if (strcmp("none",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_database)->entry)))!=0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_database)->entry)));
  }

  if (strcmp("none",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_case)->entry)))!=0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_case)->entry)));
  }

  if (strcmp("-php3",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)));
  }
    else
  if (strcmp("-php4",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)));
  }

  t=strlen(sourcedir);
  while (t>0 && sourcedir[t-1]=='/') { sourcedir[t-1]=0; t--; }
  t=strlen(targetdir);
  while (t>0 && targetdir[t-1]=='/') { targetdir[t-1]=0; t--; }

  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Checking to see if directories exist");
  status_count++;
 
  dp_asp=opendir(sourcedir);
  if (dp_asp==0)
  {
    gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: ASP Source Dir doesn't exist");
    status_count++;
    convert=0;
    return;
  } 
  closedir(dp_asp);
  
  if (strlen(targetdir)==0)
  {
    gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't create PHP target dir");
    status_count++;
  }


/*  printf("copying files\n"); */

  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Working...");
  status_count++;

  sprintf(command,"asp2php %s -dir -o %s %s",arguments,targetdir,sourcedir);
  printf("%s\n",command);
  system(command);

  clear_status();
  convert=0;
}

void stop (GtkWidget *widget, gpointer data)
{
  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "asp2php stopped by user");
  status_count++;
  convert=0;
}

void help_close (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(Dialog_help);
}

void help (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (Dialog_help);
  }
}

void change_png (GtkWidget *widget, gpointer data)
{
  if (pngs==0)
  { pngs=1; }
    else
  { pngs=0; }
}

void change_html (GtkWidget *widget, gpointer data)
{
  if (html==0)
  { html=1; }
    else
  { html=0; }
}

void change_global_asa (GtkWidget *widget, gpointer data)
{
  if (global_asa==0)
  { global_asa=1; }
    else
  { global_asa=0; }
}


void quit (GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

void selected_db (GtkWidget *widget, gpointer data)
{
  clear_status();
  g_print ("selected: %s\n",data);
  convert=0;
}

void asp_dir_selected(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_entry_set_text((GtkEntry *)Text_aspdir,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_widget_hide (File_asp_dir); 
}

void asp_dir_hide(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_widget_hide (File_asp_dir); 
}

void php_dir_selected(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_entry_set_text((GtkEntry *)Text_phpdir,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_widget_hide (File_php_dir); 
}

void php_dir_hide(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_widget_hide (File_php_dir); 
}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
  return (TRUE);
}

void destroy (GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

void set_status()
{
  context_id=gtk_statusbar_get_context_id(GTK_STATUSBAR(Status), "Statusbar");
  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Copyright 1999-2002 by Michael Kohn   License: GPL");
}

int main (int argc, char *argv[])
{
GtkWidget *window;
GtkWidget *Button_select_asp;
GtkWidget *Button_select_php;
GtkWidget *Button_start;
GtkWidget *Button_stop;
GtkWidget *Button_help;
GtkWidget *Button_quit;
GtkWidget *Box_right;
GtkWidget *Box_left;
GtkWidget *Box_main;
GtkWidget *Box_main_full;
GtkWidget *Label_aspdir;
GtkWidget *Label_phpdir;
GtkWidget *Label_database;
GtkWidget *Label_case;
GtkWidget *Label_php;
GtkWidget *pixmapwid;
GtkWidget *Dialog_button;
GtkWidget *Dialog_label;
GtkWidget *Check_png;
GtkWidget *Check_html;
GtkWidget *Check_global_asa;
GtkStyle *style;
GdkBitmap *mask;
GdkPixmap *Pixmap_asp2php;
GList *dlist,*dlist_case,*dlist_php;
GdkColormap *colormap;

  gtk_init (&argc, &argv);
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "GTK - ASP2PHP");

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_container_border_width (GTK_CONTAINER (window), 10);

  Box_right=gtk_vbox_new(FALSE, 0);
  Box_left=gtk_vbox_new(FALSE, 0);
  Box_main=gtk_hbox_new(FALSE, 0);
  Box_main_full=gtk_vbox_new(FALSE, 0);

  gtk_container_border_width (GTK_CONTAINER (Box_left), 10);
  gtk_container_border_width (GTK_CONTAINER (Box_main), 10);

  Status=gtk_statusbar_new();
  set_status();

  Label_aspdir=gtk_label_new("ASP Dir (Source):");
  Label_phpdir=gtk_label_new("PHP Dir (Target)");
  Label_database=gtk_label_new("Database");
  Label_case=gtk_label_new("Variable Case Change");
  Label_php=gtk_label_new("PHP File Extension");

  Text_aspdir=gtk_entry_new_with_max_length(1024);
  Text_phpdir=gtk_entry_new_with_max_length(1024);

  Dialog_help=gtk_dialog_new();
  Dialog_button=gtk_button_new_with_label("Close Help");
  gtk_signal_connect (GTK_OBJECT (Dialog_button), "clicked",
                      GTK_SIGNAL_FUNC (help_close), NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog_help)->action_area),
          Dialog_button, TRUE, TRUE, 0);
  Dialog_label=gtk_label_new(help_message);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog_help)->vbox),Dialog_label,
          TRUE,TRUE,0);
  gtk_container_border_width (GTK_CONTAINER (Dialog_help), 10);
  gtk_widget_show(Dialog_label);
  gtk_widget_show(Dialog_button);

  Combo_database=gtk_combo_new();
  dlist=NULL;
  dlist=g_list_prepend(dlist,"-sybase"); 
  dlist=g_list_prepend(dlist,"-oracle"); 
  dlist=g_list_prepend(dlist,"-odbc"); 
  dlist=g_list_prepend(dlist,"-mysql"); 
  dlist=g_list_prepend(dlist,"-postgres"); 
  dlist=g_list_prepend(dlist,"none"); 
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_database, dlist);

  Combo_case=gtk_combo_new();
  dlist_case=NULL;
  dlist_case=g_list_prepend(dlist_case,"-toupper");
  dlist_case=g_list_prepend(dlist_case,"-tolower");
  dlist_case=g_list_prepend(dlist_case,"none");
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_case, dlist_case);

  Combo_php=gtk_combo_new();
  dlist_php=NULL;
  dlist_php=g_list_prepend(dlist_php,"-php3");
  dlist_php=g_list_prepend(dlist_php,"-php4");
  dlist_php=g_list_prepend(dlist_php,"php");
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_php, dlist_php);

/*
  gtk_signal_connect (GTK_OBJECT (Combo_database), "selection_changed",
                      GTK_SIGNAL_FUNC (selected_db), NULL);
*/

  File_asp_dir=gtk_file_selection_new("ASP Source Dir");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_asp_dir)->ok_button),
                     "clicked",(GtkSignalFunc) asp_dir_selected, File_asp_dir);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_asp_dir)->cancel_button),
                     "clicked",(GtkSignalFunc) asp_dir_hide, File_asp_dir);

  File_php_dir=gtk_file_selection_new("PHP Target Dir");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_php_dir)->ok_button),
                     "clicked",(GtkSignalFunc) php_dir_selected, File_php_dir);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_php_dir)->cancel_button),
                     "clicked",(GtkSignalFunc) php_dir_hide, File_php_dir);

  Check_png=gtk_check_button_new_with_label("Convert PNGs [ -PNGS mode ]");
  gtk_signal_connect (GTK_OBJECT (Check_png), "pressed",
                      GTK_SIGNAL_FUNC (change_png), NULL);

  Check_html=gtk_check_button_new_with_label("Change references from .htm to .html");
  gtk_signal_connect (GTK_OBJECT (Check_html), "pressed",
                      GTK_SIGNAL_FUNC (change_html), NULL);

  Check_global_asa=gtk_check_button_new_with_label("Include global.php in all pages");
  gtk_signal_connect (GTK_OBJECT (Check_global_asa), "pressed",
                      GTK_SIGNAL_FUNC (change_global_asa), NULL);


  Button_select_asp = gtk_button_new_with_label ("Select ASP Dir");
  gtk_signal_connect (GTK_OBJECT (Button_select_asp), "clicked",
                      GTK_SIGNAL_FUNC (selected_asp), NULL);

  Button_select_php = gtk_button_new_with_label ("Select PHP Dir");
  gtk_signal_connect (GTK_OBJECT (Button_select_php), "clicked",
                      GTK_SIGNAL_FUNC (selected_php), NULL);

  Button_start = gtk_button_new_with_label ("Start Convert");
  gtk_signal_connect (GTK_OBJECT (Button_start), "clicked",
                      GTK_SIGNAL_FUNC (start), NULL);

  Button_stop = gtk_button_new_with_label ("Stop Convert");
  gtk_signal_connect (GTK_OBJECT (Button_stop), "clicked",
                      GTK_SIGNAL_FUNC (stop), NULL);

  Button_help = gtk_button_new_with_label ("Help");
  gtk_signal_connect (GTK_OBJECT (Button_help), "clicked",
                      GTK_SIGNAL_FUNC (help), NULL);

  Button_quit = gtk_button_new_with_label ("Quit");
  gtk_signal_connect (GTK_OBJECT (Button_quit), "clicked",
                      GTK_SIGNAL_FUNC (quit), NULL);

  gtk_widget_show(window); 

  style=gtk_widget_get_style(window);

/*
  Pixmap_asp2php=gdk_pixmap_create_from_xpm_d (window->window, &mask,
				&style->bg[GTK_STATE_NORMAL],
				(gchar *)"asp.xpm");
*/

  colormap=gtk_widget_get_colormap(window);
  Pixmap_asp2php=gdk_pixmap_colormap_create_from_xpm_d(NULL,colormap,&mask,NULL,
                                           (gchar **)asp_xpm);

  pixmapwid=gtk_pixmap_new(Pixmap_asp2php, mask);

  gtk_container_add (GTK_CONTAINER (Box_right), Button_select_asp);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_select_php);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_start);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_stop);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_help); 
  gtk_container_add (GTK_CONTAINER (Box_right), Button_quit); 
  gtk_container_add (GTK_CONTAINER (Box_left), pixmapwid); 
  gtk_container_add (GTK_CONTAINER (Box_left), Label_aspdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Text_aspdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_phpdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Text_phpdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_database);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_database);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_case);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_case);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_php);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_php);
  gtk_container_add (GTK_CONTAINER (Box_left), Check_png);
  gtk_container_add (GTK_CONTAINER (Box_left), Check_html);
  gtk_container_add (GTK_CONTAINER (Box_left), Check_global_asa);
  gtk_container_add (GTK_CONTAINER (Box_main), Box_left);
  gtk_container_add (GTK_CONTAINER (Box_main), Box_right);
  gtk_container_add (GTK_CONTAINER (Box_main_full), Box_main);
  gtk_container_add (GTK_CONTAINER (Box_main_full), Status);
  gtk_container_add (GTK_CONTAINER (window), Box_main_full);

  gtk_widget_show(Check_png);
  gtk_widget_show(Check_html);
  gtk_widget_show(Check_global_asa);
  gtk_widget_show (Button_select_asp); 
  gtk_widget_show (Button_select_php); 
  gtk_widget_show (Button_start); 
  gtk_widget_show (Button_stop);
  gtk_widget_show (Button_help); 
  gtk_widget_show (Button_quit); 
  gtk_widget_show (pixmapwid); 
  gtk_widget_show (Label_aspdir);
  gtk_widget_show (Text_aspdir);
  gtk_widget_show (Label_phpdir);
  gtk_widget_show (Text_phpdir);
  gtk_widget_show (Label_database);
  gtk_widget_show (Combo_database); 
  gtk_widget_show (Label_case);
  gtk_widget_show (Combo_case); 
  gtk_widget_show (Label_php);
  gtk_widget_show (Combo_php); 
  gtk_widget_show (Box_right); 
  gtk_widget_show (Box_left); 
  gtk_widget_show (Box_main); 
  gtk_widget_show (Box_main_full); 
  gtk_widget_show (Status); 

  gtk_main ();
  return 0;
}



