
/* General */ 
extern void push(char *token, int tokentype); 
extern void push2(char *token, int tokentype); 
extern void error(char *token,char *expected, char *keyword); 
extern void unsupported(char *keyword); 
extern void comment_out(char *tmp_token); 
extern int isnum(char *s);
extern void strcase(char *s);
extern void strtolower(char *s);
extern char *strcasestr_m(char *hejstack, char *needle);
extern void insert_session();
extern void insert_isnum();
extern int getobject(char *token);
extern int autoindent();
extern int autoindent_string(char *newtoken);
extern int gettoken();
extern int is_asp_filename(char *filename);
extern void change_extension(char *filename, char *extension);
extern int extcmp(char *filename, char *extension);
extern void add_indent(char *newtoken);
extern void eval_funct_or_molecule(char *newtoken);
extern void convert_funct(char *newtoken, char *params, int suppress);
extern void convert_expression(char *newtoken);
extern void fixwinpath(char *filename);
extern void dirname_kohn(char *s);
extern int find_null(char *s, int l);

extern int iskeyword(char *token);
extern int is_endscript();
extern int parse();
extern int parse_funct(int isfunct);
extern int parse_body(int iflag);
extern int parse_server(char *newtoken);
extern int parse_request(char *newtoken);
extern int parse_response();
extern int parse_set(char *newtoken);
extern int parse_command_set(char *newtoken,char *variable);
extern int parse_command(char *newtoken,char *variable);
extern int parse_rem();
extern int parse_at();
extern int parse_at_language();
extern int parse_dim();
extern int parse_randomize();
extern void parse_object(char *newtoken, char *token);

extern int copy_file(char *source, char *dest);

/* HTML */

extern void parse_tag();
extern int copyhtml();
extern int fixw2k(char *token);
extern int copyhtml();
extern void parse_include(char *tag);
extern int getattribute(char *tag, char *att, char *value);
extern void remove_quotes(char *s);

/* Token evaluation */

extern int eval_element(char *newtoken, int tokentype, char *token);
extern int eval_funct(char *newtoken);
extern int eval_token(int tokentype,char *token);
extern int isfunction(char *token);
extern int eval_molecule(char *newtoken);
extern int eval_expression(char *oldtoken);

/* DataBase */

extern int db_open(char *newtoken, char *variable);
extern int db_execute(char *newtoken, char *variable);
extern int parse_adodb_rs(char *newtoken,char *variable);
extern int parse_adodb_rs_mysql(char *newtoken,char *variable);
extern int parse_adodb_rs_odbc(char *newtoken,char *variable);
extern int parse_adodb_rs_oracle(char *newtoken,char *variable);
extern int parse_adodb_rs_pg(char *newtoken,char *variable);
extern int parse_adodb_rs_sybase(char *newtoken,char *variable);
extern int parse_adodb_connection(char *newtoken,char *variable);
extern int parse_adodb_connection_mysql(char *newtoken,char *variable);
extern int parse_adodb_connection_odbc(char *newtoken,char *variable);
extern int parse_adodb_connection_oracle(char *newtoken,char *variable);
extern int parse_adodb_connection_pg(char *newtoken,char *variable);
extern int parse_adodb_connection_sybase(char *newtoken,char *variable);
extern int getvar(char *answer, char *token, char *variable);

/* Sessions */

extern void start_session();
extern int parse_session();
extern int parse_session_properties(char *newtoken);
extern int session_registered(char *molecule);

/* Loops */

extern int parse_do_loop();
extern int parse_do();
extern int parse_while();
extern int parse_for();

/* Conditionals */

extern int parse_if();
extern int parse_select();
extern int parse_condition();

/* Mail */

extern int parse_mail(char *newtoken, char *temptoken);
extern int parse_new_mail(char *newtoken, char *temptoken);

/* FileSystem */

extern int parse_filesystem(char *newtoken, char *oldtoken);

/** JScript section **/

/* Scanner functions */
extern int gettoken_j(char *token);


/* Parser functions */
extern int parse_body_j();
extern void parse_section_j();

/* Loops */
extern void parse_for_j();
extern void parse_while_j();

/* Conditionals */
extern void parse_condition_j();
extern void parse_if_j();
extern void parse_switch_j();

/* Eval Expressions/Token */
extern void eval_expression_j();
extern int eval_token_j(char *molecule, int tokentype, char *token);
extern int eval_method_j(char *newtoken, char *variable);

/* Response/Request */
extern int parse_response_j();
extern int parse_request_j(char *newtoken);

/* Functions */
extern void convert_funct_j(char *newtoken, char *params, int suppress);
extern void convert_expression_j(char *newtoken);

/* Object Oriented */
int isclass(char *token);
extern int parse_class();
extern int parse_new(char *newtoken);


