/*
 *      scr.c from Access Point SNMP Utils for Linux
 *	program screen operate functions
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <stdlib.h>
#include <ncurses.h>
#include <menu.h>
#include <string.h>
#include "ap-utils.h"

extern WINDOW *main_sub, *win_for_help, *main_win;


#define MAC_LEN 12
#define MAC_BYTES 6

void
get_mac(int row, int col, char *mac) {

        char message[MAC_LEN+1], mess[MAC_LEN/MAC_BYTES+1];
        int i;

        get_value(message, row, col, MAC_LEN+1);

        for (i = 0; i < MAC_BYTES; i++) {
                mess[0] = message[2 * i];
                mess[1] = message[2 * i + 1];
                mess[2] = '\0';
                mac[i] = strtol(mess, NULL, 16);
        }
        clear_main_new(row, row+1);
}


int
get_value(char *value, int line, int column, int len)
{
    int i;

    echo();
    wattrset(main_sub, COLOR_PAIR(2));
    mvwaddch(main_sub, line, column, ' ');
    for (i = 0; i < len - 2; i++)
	waddch(main_sub, ' ');
    curs_set(1);
    mvwgetnstr(main_sub, line, column, value, len - 1);
    curs_set(0);
    noecho();
    value[len - 1] = '\0';
    wattrset(main_sub, A_NORMAL);
    return 0;
}

int
on_off(int bcol, int brow)
{
    char *names[2] = { ON, OFF };
    return menu_choose(bcol, brow, names, 2) + 1;
}


int menu_choose(int bcol, int brow, char **names, unsigned int num)
{
    unsigned short int c;
    ITEM **menu_item = calloc(num, sizeof(ITEM)), **ip = menu_item;
    MENU *menu1;
    unsigned int ncol = 2, i, nrow;
    WINDOW *choose_menu, *sub_choose_menu;
    extern WINDOW *main_sub;

    for (i = 0; i < num; i++) {
	*ip++ = new_item(names[i], "");
	if (ncol < strlen(names[i]) + 3)
	    ncol = strlen(names[i]) + 3;
    }
    *ip = (ITEM *) 0;


    nrow = num + 2;
    if (brow + 2 + nrow <= (unsigned int) LINES - 2)
	choose_menu = newwin(nrow, ncol, brow + 2, bcol + MCOLS);
    else
	choose_menu = newwin(nrow, ncol, brow - nrow + 3, bcol + MCOLS);
    sub_choose_menu = derwin(choose_menu, nrow - 2, ncol - 2, 1, 1);
    attrset(COLOR_PAIR(1));

    mvwaddch(choose_menu, 0, 0, ACS_ULCORNER);
    mvwaddch(choose_menu, 0, ncol - 1, ACS_URCORNER);
    mvwaddch(choose_menu, nrow - 1, 0, ACS_LLCORNER);
    mvwaddch(choose_menu, nrow - 1, ncol - 1, ACS_LRCORNER);
    for (i = 1; i < ncol - 1; i++) {
	mvwaddch(choose_menu, 0, i, ACS_HLINE);
	mvwaddch(choose_menu, nrow - 1, i, ACS_HLINE);
    }
    for (i = 1; i < nrow - 1; i++) {
	mvwaddch(choose_menu, i, 0, ACS_VLINE);
	mvwaddch(choose_menu, i, ncol - 1, ACS_VLINE);
    }
    wrefresh(choose_menu);


    menu1 = new_menu(menu_item);
    set_menu_win(menu1, choose_menu);
    set_menu_sub(menu1, sub_choose_menu);

    set_menu_opts(menu1, O_ONEVALUE);

    curs_set(0);
    post_menu(menu1);
    wrefresh(sub_choose_menu);

    while (1) {
	switch (getch()) {
	case KEY_DOWN:
	case 'j':
	case 'J':
	    menu_driver(menu1, REQ_NEXT_ITEM);
	    wrefresh(sub_choose_menu);
	    break;
	case KEY_RIGHT:
	case 'l':
	case 'L':
	    menu_driver(menu1, REQ_LAST_ITEM);
	    wrefresh(sub_choose_menu);
	    break;
	case KEY_LEFT:
	case 'h':
	case 'H':
	    menu_driver(menu1, REQ_FIRST_ITEM);
	    wrefresh(sub_choose_menu);
	    break;
	case KEY_UP:
	case 'k':
	case 'K':
	    menu_driver(menu1, REQ_PREV_ITEM);
	    wrefresh(sub_choose_menu);
	    break;
	case 10:
	    i = item_index(current_item(menu1));
	    unpost_menu(menu1);
	    free_menu(menu1);
	    for (c = 0; c < nrow - 2; c++)
		free_item(menu_item[c]);
	    delwin(sub_choose_menu);
	    delwin(choose_menu);
	    redrawwin(main_sub);
	    free(menu_item);
	    return i;

	}
    }
}

