/*
 *      bridge.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include <stdlib.h>
#include <ncurses.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "ap-utils.h"

#define HELP _("BPGINFDRT - set; W - write conf; Q - quit to menu")
#define INV_IP _("Invalid IP-address.  Press any key to continue.")
#define IP_FILTER _("[F] Filter non IP-traffic: %s")
#define PR_PORT _("[P] Primary port: %s")
#define DHCP _("[D] DHCP protocol: %s")
#define OPER _("[O] Operational Mode: %s")
#define REMOTE_MAC _("[R] Remote Mac addr: %02X%02X%02X%02X%02X%02X")

#define ATMEL_GENERIC	0
#define ATMEL_SB 	1 /* smartbriges use different mib*/

extern short ap_type;

void briging()
{

    char operEthernetAddress[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x03,
	0x00
    };
    char IPFilter[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x03, 0x01,
	0x00
    };
    char PrimaryPort[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x06,
	0x00
    };
    char operDHCP[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x05,
	0x00
    };
    char operIPAddress[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x01,
	0x00
    };
    char operIPMask[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x02,
	0x00
    };
    char operGateway[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x02, 0x04,
	0x00
    };
    char bridgeOperationalMode[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x04, 0x01,
	0x00
    };
    char bridgeRemoteBridgeBSSID[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x04, 0x02,
	0x00
    };
    char sysTrapSwitch[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x01, 0x03,
	0x00
    };

    char *bridge_modes[6] = { _("Wireless Bridge Point to MultiPoint"),
	_("Access Point"),
	_("Access Point client"),
	_("Wireless Bridge Point to Point"), _("Repeater"), ("unknown")
    }, *ports[2] = {
    _("Ethernet"), _("Wireless")}, oui_sb[3] = {0x00, 0x30, 0x1A}, atmel_ap_type=ATMEL_GENERIC;
    unsigned char message[1024], filter, primary_port, dhcp,
	RemoteBSSID[6], bridge_mode, traps, m_traps = 0;
    struct in_addr ip, mask, gw;
    varbind varbinds[10];
    char m_filter = 0, m_bridge_mode = 0, m_primary_port = 0, m_dhcp =
	0, m_ip = 0, m_mask = 0, m_gw = 0, m_remote_bssid = 0;
    int i;
    extern WINDOW *main_sub;

	if (ME102 == ap_type) {
	     	operEthernetAddress[5] = 0xE0;
		operEthernetAddress[6] = 0x3E;
	     	IPFilter[5] = 0xE0;
	 	IPFilter[6] = 0x3E;
		PrimaryPort[5] = 0xE0;
		PrimaryPort[6] = 0x3E;
		operDHCP[5] = 0xE0;
	    	operDHCP[6] = 0x3E;
	    	operIPAddress[5] = 0xE0;
                operIPAddress[6] = 0x3E;
		operIPMask[5] = 0xE0;
                operIPMask[6] = 0x3E;
		operGateway[5] = 0xE0;
                operGateway[6] = 0x3E;
		bridgeOperationalMode[5] = 0xE0;
                bridgeOperationalMode[6] = 0x3E;
		bridgeRemoteBridgeBSSID[5] = 0xE0;
                bridgeRemoteBridgeBSSID[6] = 0x3E;
                sysTrapSwitch[5] = 0xE0;
		sysTrapSwitch[6] = 0x3E;
	}
    
    for (i = 0; i < 10; i++) {
	varbinds[i].len_oid = sizeof(IPFilter);
	varbinds[i].type = NULL_VALUE;
	varbinds[i].len_val = 0;
    }

    varbinds[0].oid = IPFilter;
    varbinds[1].oid = PrimaryPort;
    varbinds[2].oid = operDHCP;
    varbinds[3].oid = operEthernetAddress;
    varbinds[4].oid = operIPAddress;
    varbinds[5].oid = operIPMask;
    varbinds[6].oid = operGateway;
    varbinds[7].oid = bridgeOperationalMode;
    varbinds[8].oid = sysTrapSwitch;
    varbinds[9].oid = bridgeRemoteBridgeBSSID;

    print_help(WAIT_RET);
    if (snmp(varbinds, 10, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }

    sprintf(message, MAC,
	    varbinds[3].value[0] & 0xFF,
	    varbinds[3].value[1] & 0xFF,
	    varbinds[3].value[2] & 0xFF,
	    varbinds[3].value[3] & 0xFF,
	    varbinds[3].value[4] & 0xFF,
	    varbinds[3].value[5] & 0xFF);
    mvwaddstr(main_sub, 0, 0, message);
    if (memcmp(oui_sb, varbinds[3].value, 3) == 0)
	atmel_ap_type = ATMEL_SB;


    filter = *(varbinds[0].value);
    if (atmel_ap_type != ATMEL_SB) {
	primary_port = *(varbinds[1].value);
	if (primary_port < 1 || primary_port > 2) {
	    primary_port = 1;
	}
	sprintf(message, PR_PORT, ports[primary_port - 1]);
	mvwaddstr(main_sub, 4, 0, message);
    }	
    if (atmel_ap_type == ATMEL_SB) {
	sprintf(message, _("Attached Station MAC: %02X%02X%02X%02X%02X%02X"),
		*(varbinds[1].value + 0) & 0xFF, *(varbinds[1].value + 1) & 0xFF,
		*(varbinds[1].value + 2) & 0xFF, *(varbinds[1].value + 3) & 0xFF,
		*(varbinds[1].value + 4) & 0xFF, *(varbinds[1].value + 5) & 0xFF);
    }
    
    dhcp = *(varbinds[2].value);
    memcpy(&ip.s_addr, varbinds[4].value, 4);
    memcpy(&mask.s_addr, varbinds[5].value, 4);
    memcpy(&gw.s_addr, varbinds[6].value, 4);
    traps = *(varbinds[8].value);
    memcpy(RemoteBSSID, varbinds[9].value, 6);
    if ((bridge_mode = *(varbinds[7].value)) != 2) {
	sprintf(message, REMOTE_MAC,
		*(RemoteBSSID + 0) & 0xFF, *(RemoteBSSID + 1) & 0xFF,
		*(RemoteBSSID + 2) & 0xFF, *(RemoteBSSID + 3) & 0xFF,
		*(RemoteBSSID + 4) & 0xFF, *(RemoteBSSID + 5) & 0xFF);
	mvwaddstr(main_sub, 7, 0, message);
    }
    if (bridge_mode > 5)
	bridge_mode  = 6;

    print_title(_("Bridging"));
    sprintf(message, "[I] IP: %s", inet_ntoa(ip));
    mvwaddstr(main_sub, 1, 0, message);
    sprintf(message, _("[N] Netmask: %s"), inet_ntoa(mask));
    mvwaddstr(main_sub, 1, 24, message);
    sprintf(message, _("[G] Gateway %s"), inet_ntoa(gw));
    mvwaddstr(main_sub, 2, 0, message);
    sprintf(message, IP_FILTER, (filter == 1) ? ON : OFF);
    mvwaddstr(main_sub, 3, 0, message);
    sprintf(message, DHCP, (dhcp == 1) ? ON : OFF);
    mvwaddstr(main_sub, 5, 0, message);
    sprintf(message, OPER, bridge_modes[bridge_mode - 1]);
    mvwaddstr(main_sub, 6, 0, message);
    sprintf(message, TRAPS, (traps == 1) ? ON : OFF);
    mvwaddstr(main_sub, 8, 0, message);
    wrefresh(main_sub);
    noecho();

    print_help(HELP);
    while (1) {
	switch (getch()) {
	case 'I':
	case 'i':
	    get_value(message, 1, 8, 16);
	    if (!(inet_aton(message, &ip))) {
		print_help(INV_IP);
		getch();
		print_help(HELP);
	    } else
		m_ip = 1;
	    continue;
	case 'N':
	case 'n':
	    get_value(message, 1, 37, 16);
	    if (!(inet_aton(message, &mask))) {
		print_help(INV_IP);
		getch();
		print_help(HELP);
	    } else
		m_mask = 1;
	    continue;
	case 'G':
	case 'g':
	    get_value(message, 2, 12, 16);
	    if (!(inet_aton(message, &gw))) {
		print_help(INV_IP);
		getch();
		print_help(HELP);
	    } else
		m_gw = 1;
	    continue;
	case 'F':
	case 'f':
	    filter = on_off(27, 3);
	    clear_main_new(3, 4);
	    sprintf(message, IP_FILTER, (filter == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 3, 0, message);
	    wrefresh(main_sub);
	    m_filter = 1;
	    continue;
	case 'S':
	case 's':
	    traps = on_off(16, 8);;
	    clear_main_new(8, 9);
	    sprintf(message, TRAPS, (traps == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 8, 0, message);
	    wrefresh(main_sub);
	    m_traps = 1;
	    continue;

	case 'P':
	case 'p':
	    if (atmel_ap_type != ATMEL_SB) {
		primary_port = menu_choose(17, 4, ports, 2) + 1;
		clear_main_new(4, 5);
		sprintf(message, PR_PORT, ports[primary_port - 1]);
		mvwaddstr(main_sub, 4, 0, message);
		wrefresh(main_sub);
		m_primary_port = 1;
	    }	
	    continue;
	case 'D':
	case 'd':
	    dhcp = on_off(18, 5);;
	    clear_main_new(5, 6);
	    sprintf(message, DHCP, (dhcp == 1) ? ON : OFF);
	    mvwaddstr(main_sub, 5, 0, message);
	    wrefresh(main_sub);
	    m_dhcp = 1;
	    continue;
	case 'O':
	case 'o':
	    bridge_mode = menu_choose(22, 6, bridge_modes, 5) + 1;
	    sprintf(message, OPER, bridge_modes[bridge_mode - 1]);
	    clear_main_new(6, 8);
	    mvwaddstr(main_sub, 6, 0, message);
	    if (bridge_mode != 2) {
		sprintf(message, REMOTE_MAC,
			*(RemoteBSSID + 0) & 0xFF,
			*(RemoteBSSID + 1) & 0xFF,
			*(RemoteBSSID + 2) & 0xFF,
			*(RemoteBSSID + 3) & 0xFF,
			*(RemoteBSSID + 4) & 0xFF,
			*(RemoteBSSID + 5) & 0xFF);
		mvwaddstr(main_sub, 7, 0, message);
	    }
	    wrefresh(main_sub);
	    m_bridge_mode = 1;
	    continue;
	case 'R':
	case 'r':
	    get_mac(7, 21, RemoteBSSID);
/*	    mvwaddstr(main_sub, 7, 21, "  :  :  :  :  :  ");
	    for (i = 0; i < 6; i++) {
		get_value(message, 7, 21 + i * 3, 3);
		RemoteBSSID[i] = strtol(message, NULL, 16);
	    }
*/	    m_remote_bssid = 1;
	sprintf(message, REMOTE_MAC,
		*(RemoteBSSID + 0) & 0xFF, *(RemoteBSSID + 1) & 0xFF,
		*(RemoteBSSID + 2) & 0xFF, *(RemoteBSSID + 3) & 0xFF,
		*(RemoteBSSID + 4) & 0xFF, *(RemoteBSSID + 5) & 0xFF);
	mvwaddstr(main_sub, 7, 0, message);
	    wrefresh(main_sub);

	    continue;
	case 'w':
	case 'W':
	    i = 0;
	    if (m_filter) {
		varbinds[i].oid = IPFilter;
		varbinds[i].len_oid = sizeof(IPFilter);
		varbinds[i].type = INT_VALUE;
		varbinds[i].value = (char *) &filter;
		varbinds[i].len_val = 1;
		i++;
	    }
	    if (m_primary_port && atmel_ap_type != ATMEL_SB) {
		varbinds[i].oid = PrimaryPort;
		varbinds[i].len_oid = sizeof(PrimaryPort);
		varbinds[i].type = INT_VALUE;
		varbinds[i].value = (char *) &primary_port;
		varbinds[i].len_val = 1;
		i++;
	    }
	    if (m_dhcp) {
		varbinds[i].oid = operDHCP;
		varbinds[i].len_oid = sizeof(operDHCP);
		varbinds[i].type = INT_VALUE;
		varbinds[i].value = (char *) &dhcp;
		varbinds[i].len_val = 1;
		i++;
	    }
	    if (m_ip) {
		varbinds[i].oid = operIPAddress;
		varbinds[i].len_oid = sizeof(operIPAddress);
		ip.s_addr = htonl(ip.s_addr);
		varbinds[i].value = (char *) &ip.s_addr;
		varbinds[i].len_val = 4;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_mask) {
		varbinds[i].oid = operIPMask;
		varbinds[i].len_oid = sizeof(operIPMask);
		mask.s_addr = htonl(mask.s_addr);
		varbinds[i].value = (char *) &mask.s_addr;
		varbinds[i].len_val = 4;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_gw) {
		varbinds[i].oid = operGateway;
		gw.s_addr = htonl(gw.s_addr);
		varbinds[i].len_oid = sizeof(operGateway);
		varbinds[i].value = (char *) &gw.s_addr;
		varbinds[i].len_val = 4;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_traps) {
		varbinds[i].oid = sysTrapSwitch;
		varbinds[i].len_oid = sizeof(sysTrapSwitch);
		varbinds[i].value = &traps;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (m_bridge_mode) {
		varbinds[i].oid = bridgeOperationalMode;
		varbinds[i].len_oid = sizeof(bridgeOperationalMode);
		varbinds[i].value = (char *) &bridge_mode;
		varbinds[i].len_val = 1;
		varbinds[i].type = INT_VALUE;
		i++;
	    }
	    if (bridge_mode != 2 && m_remote_bssid) {
		varbinds[i].oid = bridgeRemoteBridgeBSSID;
		varbinds[i].len_oid = sizeof(bridgeRemoteBridgeBSSID);
		varbinds[i].value = RemoteBSSID;
		varbinds[i].len_val = 6;
		varbinds[i].type = STRING_VALUE;
		i++;
	    }
	    print_help(WAIT_SET);
	    if (snmp(varbinds, i, SET) <= 0)
		print_help(ERR_SET);
	    else
           	print_help(DONE_SET);
    	    goto exit;
	case 'Q':
	case 'q':
	    goto quit;
	}
	continue;
    }
  exit:
    getch();
  quit:
    print_title("");
    clear_main(0);
}

