#!/bin/sh
##
## runtest.sh:						sep '90
##
## Erik Schoenfelder (schoenfr@tubsibr.uucp)
##
##
## run some tests to verify the a60 interpreter.
##
## use: runtest.sh
##

a60='../a60'
tests='fakul.a60 outnum.a60 irnum.a60 outstr.a60 jdev.a60 cbname.a60
	ack.a60 queen.a60 logic1.a60 sin.a60 rmath.a60 goto.a60
	ifstmt.a60 for.a60 procp.a60 sort.a60 iarr.a60
	mama.a60 entier.a60 igral.a60 own.a60 switch.a60 dirty.a60
	syntax.a60 order.a60 cond.a60 input.a60'

tmpres='/tmp/rt$$'

if [ `echo -n gna` = "-n gna" ] ; then
        echo='echo'; fin='\c';
else
        echo='echo -n'; fin='done.';
fi

rm -f $tmpres
touch $tmpres

for f in $tests ; do
	$echo "** running $f ... "
	echo "" > $tmpres 2>&1
	echo "$f :" >> $tmpres 2>&1
	echo "" >> $tmpres 2>&1
	if [ -f `basename $f .a60`.inp ] ; then
	  $a60 $f < `basename $f .a60`.inp >> $tmpres 2>&1
	else
	  $a60 $f >> $tmpres 2>&1
	fi
	echo $fin
	echo "checking for differences:"
	diff $tmpres `basename $f .a60`.outp
done

##
## running FILE_n tests:
##
rm -rf FILE_3 FILE_4 $tmpres

$echo "** running file_n_34.a60 ... "
cp input.inp FILE_3
$a60 file_n_34.a60
echo done.
echo "checking for differences:"
diff file_n_34.outp FILE_4

$echo "** running file_n_56.a60 ... "
FILE_5=input.inp
FILE_6=$tmpres
export FILE_5 FILE_6
$a60 file_n_56.a60
echo done.
echo "checking for differences:"
diff file_n_56.outp $tmpres

echo ""
echo "ok - thats it."

rm -f $tmpres core

exit 0
