.TH A60 1 "June 1991"
.SH NAME
a60 \- An Algol 60 Interpreter
.SH SYNOPSIS
.B a60
[
.B "options"
]
[
.B "<input-file>"
]
.SH DESCRIPTION
A60 is an Algol 60 interpreter, based on the standard of the ``Revised
Report on the Algorithmic Language Algol 60''.
.SH OPTIONS
.TP
.B -h
Give help on usage.
.TP
.B -V
Print the version string and exit.
.TP
.B -v
Be verbose.
.TP
.B -n
Do not execute the input. Parse and check only.
.TP
.B -i
Do not check or execute the input. Parse only.
.TP
.B -t
Trace the line numbers while running the input.
.TP
.B -strict
Follow strict a60 convention. Skip whitespace in entire input, except in
strings, so keywords must be enclosed in quotes.
.TP
.B -c
Create C output from the given input. This is experimental.
.TP
.B -C
Create a executable from the given input. This is -c followed by
compiling (gcc is used).
.TP
.B -I
Force inclusion of the include file via cpp statement and no not as
copy. Used with -c or -C option.
.TP
.B -o "<output-file>"
Use <output-file> for output. Used with -c or -C option.
.TP
.B <input-file>
Specification of the inputfile to be interpreted. It would be nice if
it is of the form: foobar.a60
.SH FILES
 .../a60-mkc.inc - a C include file, used for C-code generation.
.SH DIAGNOSTICS
For explanation of the parse-time and run-time error messages, look at the
a60.info documentation.
.SH BUGS
Please send bug reports to schoenfr@ibr.cs.tu-bs.de. Please include an
example showing the bug.
.br
The interpreter is still growing.
.br
The standard is not implemented exactly; many things are still untested.
.SH AUTHORS
Erik Schoenfelder (schoenfr@ibr.cs.tu-bs.de)
.br
June 1991
