/*
 * Name: my_defines.h
 * Description: This header contains data types, constants and function
 *     prototypes that are needed in the Linux header domain and in the
 *     native header domain. It does not need (and must not need) any
 *     preconditions. It uses only basic C datatypes.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-11-14
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

extern int		debug_mode;
extern char		fake_dot_in_root;
extern char		fake_dotdot_in_root;
extern char		rw_is_safe, allow_readonly, use_extended;
extern int		conf_uid, conf_gid, conf_dirmode, conf_filemode;
extern char		use_syslog;
extern char		*progname;

#define	DEBUG_FOPS			0x01
#define	DEBUG_NFS			0x02
#define	DEBUG_NFS_NOISY		0x04
#define	DEBUG_DISPATCH		0x08
#define	DEBUG_PSINODE		0x10
#define	DEBUG_PROC			0x20
#define	DEBUG_PROC_NOISY	0x40
#define	DEBUG_FILE			0x80


int		printk(const char *format, ...);
void	fo_regular(void);
void	fo_init(void);
void	kernel_init(void);
void	terminate(int retval);
void	eprintf(const char *format, ...);
void	debprintf(const char *format, ...);	/* for debug outputs */

void	nfs_dispatch();
void	mount_and_dispatch(char *dir, void (*proc)(), void *root_fh, int bg);


#define	MY_NFSERR_STALE		70

typedef	long long	fh_t;

typedef struct my_attributes{
	int		mode;
	int		nlink;
	int		uid;
	int		gid;
	int		size;
	int		blocksize;
	int		blocks;
	int		fileid;
	long	atime;
	long	mtime;
	long	ctime;
	int		rdev;
}my_attr_t;

typedef struct my_direntry {/* layout must be equal to NFS 'struct entry'! */
	int					fh;
	char				*name;
	int					cookie;
	struct my_direntry	*next;
}my_direntry_t;


typedef struct my_statfs{
	long	type;
	long	bsize;
	long	blocks;
	long	bfree;
	long	bavail;
	long	files;
	long	ffree;
}my_statfs_t;

int	fo_create(fh_t *fh, my_attr_t *fa, fh_t dir, char *name, my_attr_t *sa);
int	fo_mkdir(fh_t *fh, my_attr_t *fa, fh_t dir, char *name, my_attr_t *sa);
int	fo_getattr(my_attr_t *fa, fh_t fh);
int	fo_lookup(fh_t *fh, my_attr_t *fa, fh_t dir, char *name);
int	fo_readdir(my_direntry_t **result, int *eof, int max_bytes,
														fh_t dir, int cookie);
int	fo_setattr(my_attr_t *fa, fh_t fh, my_attr_t *sa);
int	fo_remove(fh_t dir, char *name);
int	fo_rmdir(fh_t dir, char *name);
int	fo_rename(fh_t fromdir, char *fromname, fh_t todir, char *toname);
int	fo_statfs(my_statfs_t *fsstat);
int	fo_read(my_attr_t *fa, int *len, char **data, fh_t fh, int off, int count);
int	fo_write(my_attr_t *fa, fh_t fh, int offset, int count, char *data);
int	fo_link(fh_t from, fh_t dir, char *name);
int	fo_readlink(char **path, fh_t fh);
int	fo_symlink(fh_t fromdir, char *fromname, char *topath, my_attr_t *sa);
int	fo_mount(char *server_ipname, char *server_name, char *client_name,
			char *service, char *root_path, char *username,
			char *password, int max_xmit, int port);
void	fo_unmount(void);

