/*
 * Name: kernel.c
 * Description: Emulation/dummies for some Linux kernel functions.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-12-06
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

#include "syshdr.h"
#include <smb/smb_fs.h>
#include "my_defines.h"
#include <time.h>
#include <sys/time.h>

struct timezone	sys_tz;

void	sleep_on(struct wait_queue ** p)
{
	/* no locking necessary, we are single threaded! */
}

void	wake_up(struct wait_queue ** p)
{
	/* nobody waiting, we are single threaded! */
}

void	*kmalloc(int len, int priority)
{
	return malloc(len);
}

void	kfree(void *base)
{
	free(base);
}


void	kernel_init(void)
{
time_t		t;

	tzset();
	time(&t);
#ifdef SOLARIS
	sys_tz.tz_minuteswest = timezone / 60;
#else
	sys_tz.tz_minuteswest = -(localtime(&t)->tm_gmtoff) / 60;
#endif
}

int	printk(const char *format, ...)
{
va_list	vlist;
char	buffer[32768];	/* should we alloc a larger chunk of virtual mem? */

	va_start(vlist, format);
	vsprintf(buffer, format, vlist);
	eprintf("Kernel: %s", buffer);
	va_end(vlist);
	return 1;
}

void	kfree_s(void *base, int len)
{
	free(base);
}


