set(FIND_SSVLUAWRAPPER_LIB_PATHS
  "${PROJECT_SOURCE_DIR}/../SSVLuaWrapper/"
  "${PROJECT_SOURCE_DIR}/extlibs/SSVLuaWrapper/"
  ${SSVLUAWRAPPER_ROOT}
  $ENV{SSVLUAWRAPPER_ROOT}
  ~/Library/Frameworks
  /Library/Frameworks
  /usr/local
  /usr/
  /sw/
  /opt/local
  /opt/csw
  /opt
)

FIND_PATH(SSVLUAWRAPPER_INCLUDE_DIR
  NAMES SSVLuaWrapper/SSVLuaWrapper.h
  PATH_SUFFIXES include/
  PATHS ${FIND_SSVLUAWRAPPER_LIB_PATHS}
)
MESSAGE("\nFound SSVLuaWrapper include at: ${SSVLUAWRAPPER_INCLUDE_DIR}.\n")

FIND_LIBRARY(SSVLUAWRAPPER_LIBRARY_RELEASE
  NAMES SSVLuaWrapper SSVLuaWrapper-s
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVLUAWRAPPER_LIB_PATHS}
)
MESSAGE("\nFound SSVLuaWrapper release library at: ${SSVLUAWRAPPER_LIBRARY_RELEASE}.\n")

FIND_LIBRARY(SSVLUAWRAPPER_LIBRARY_DEBUG
  NAMES SSVLuaWrapper-d SSVLuaWrapper-s-d
  PATH_SUFFIXES lib/ lib64/
  PATHS ${FIND_SSVLUAWRAPPER_LIB_PATHS}
)
MESSAGE("\nFound SSVLuaWrapper debug library at: ${SSVLUAWRAPPER_LIBRARY_DEBUG}.\n")

if(SSVLUAWRAPPER_LIBRARY_DEBUG OR SSVLUAWRAPPER_LIBRARY_RELEASE)
  set(SSVLUAWRAPPER_FOUND TRUE)
  if(SSVLUAWRAPPER_LIBRARY_DEBUG AND SSVLUAWRAPPER_LIBRARY_RELEASE)
    SET(SSVLUAWRAPPER_LIBRARY debug ${SSVLUAWRAPPER_LIBRARY_DEBUG} optimized ${SSVLUAWRAPPER_LIBRARY_RELEASE})
  endif()
  if(SSVLUAWRAPPER_LIBRARY_DEBUG AND NOT SSVLUAWRAPPER_LIBRARY_RELEASE)
    set(SSVLUAWRAPPER_LIBRARY_RELEASE ${SSVLUAWRAPPER_LIBRARY_DEBUG})
    set(SSVLUAWRAPPER_LIBRARY         ${SSVLUAWRAPPER_LIBRARY_DEBUG})
  endif()
  if(SSVLUAWRAPPER_LIBRARY_RELEASE AND NOT SSVLUAWRAPPER_LIBRARY_DEBUG)
    set(SSVLUAWRAPPER_LIBRARY_DEBUG ${SSVLUAWRAPPER_LIBRARY_RELEASE})
    set(SSVLUAWRAPPER_LIBRARY       ${SSVLUAWRAPPER_LIBRARY_RELEASE})
  endif()
else()
  set(SSVLUAWRAPPER_FOUND FALSE)
  set(SSVLUAWRAPPER_LIBRARY "")
endif()

IF(SSVLUAWRAPPER_FOUND)
  MESSAGE(STATUS "\nFound SSVLUAWRAPPER: ${SSVLUAWRAPPER_LIBRARY}\n")
ELSE()
  IF(SSVLUAWRAPPER_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "\nCould not find SSVLuaWrapper library\n")
  ENDIF(SSVLUAWRAPPER_FIND_REQUIRED)
  set(SSVLUAWRAPPER_ROOT "" CACHE PATH "SSVLuaWrapper top-level directory")
  message("\n-> SSVLuaWrapper directory not found. Set SSVLUAWRAPPER_ROOT to SSVLuaWrapper' top-level path (containing both \"include\" and \"lib\" directories).")
ENDIF()

MARK_AS_ADVANCED(
  SSVLUAWRAPPER_LIBRARY_DEBUG
  SSVLUAWRAPPER_LIBRARY_RELEASE
  SSVLUAWRAPPER_LIBRARY
  SSVLUAWRAPPER_INCLUDE_DIR
)
