<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

Feb 25, 2019

Host: Michael Dolan

Rotating Secretary: Mark Boorer

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Sean Cooper (_TSC_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Sony Pictures Imageworks
  * [X] Larry Gritz (_TSC_) - Sony Pictures Imageworks
  * [X] Thanh Ha - Academy Software Foundation / Linux Foundation
  * [X] Patrick Hodoul (_TSC_) - Autodesk
  * [ ] John Mertic - Academy Software Foundation / Linux Foundation
  * [ ] Carl Rand (_TSC_) - Foundry
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore

# **OCIO TSC Meeting Notes**

* CI
    - Thinking is that because ASWF already has Linux CI support, we could start using it.
    - The ASWF solution is Jenkins at the moment, but due to the young age of the project, no-one is really using it yet.
    - Circle CI has been proposed as a potential candidate as well.
    - There is a proof of concept of OCIO on the travis CI, though it is only a simple CMake build (no tests).
    - Additionally it would be good to get away from Travis CI as its future seems uncertain.
    - Potentially wait for results of ASWF TAC discussion on future CI decision before actioning any changes.
    - Thoughts are that migration of repo to ASWF is more important. We can keep our existing CI, and just move the repo.
        - **TODO**: Might need someone from Sony to do the ASWF move.
        - There will be a day or so crossover to set up the existing CI on the new ASWF setup.
        - Decided to move to ASWF first, then sort CI later.
    - **TODO**: Candidate for championing CI? Mark Boorer and Sean Cooper.

* Embedded libraries
    - Decision to remove all embedded dependencies at the same time as CI update.
    - Concerns over Windows developer experience (as building of dependencies would now be required prior to building OCIO.
    - Potentially solvable via vcpkg or Chocolatey.
    - Patrick made a GH issue for further discussion: #690

* 1.1 patch release
    - Updates to OCIO to allow optional OIIO 2.0 compatability (which requires C++11)
    - **TODO**: Larry / Michael will look into removal of auto keyword from OIIO headers.

* Feature preview tag / Early 2.0 release
    - Proponents want to the benefits of the improved GPU features for internal use.
    - Fear is that it will achieve semi-release status and start being used in other DCC's where inconsistencies might arise, leading to all the same effort as an actual release.
    - Suggestion for a limited release of some 2.0 features (3d lut inversion, gpu improvements).
    - Autodesk have two main reasons to oppose both a tag or early release:
        1. They don't feel the current state of the features represent a good, stable product to support.
        2. As the primary integrators of Autodesk's DCC's are also the developers working on 2.0, the developers times would be split between adding the new integrations, and completing 2.0.
    - Discussion tabled for next week.
    - Further discussion, and status of continued TSC discussion in GH issue #665

* Items for next TSC meeting agenda:
    - Discuss ASWF TAC proposal of future CI direction
    - Consensus on feature preview tag / early 2.0 release discussion
    - Other tabled items (due to time)
        - Python binding update (pybind11 proposed by Sony)
        - Apple deprecation of OpenGL. Explore Metal or another alternative?
