/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.NetxPanel;
import net.sourceforge.jnlp.PluginParameters;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.applet.AppletPanel;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginDebug;
import sun.applet.PluginStreamHandler;

class PluginAppletPanelFactory {
    PluginAppletPanelFactory() {
    }

    public AppletPanel createPanel(PluginStreamHandler pluginStreamHandler, final int n, final long l, final URL uRL, final PluginParameters pluginParameters) {
        final NetxPanel netxPanel = AccessController.doPrivileged(new PrivilegedAction<NetxPanel>(){

            @Override
            public NetxPanel run() {
                NetxPanel netxPanel = new NetxPanel(uRL, pluginParameters);
                NetxPanel.debug("Using NetX panel");
                PluginDebug.debug(pluginParameters.toString());
                return netxPanel;
            }
        });
        Thread thread = new Thread(netxPanel.getThreadGroup(), new Runnable(){

            @Override
            public void run() {
                netxPanel.createNewAppContext();
                PluginDebug.debug("X and Y are: " + pluginParameters.getWidth() + " " + pluginParameters.getHeight());
                netxPanel.setAppletViewerFrame(PluginAppletViewer.framePanel(n, l, pluginParameters.getWidth(), pluginParameters.getHeight(), netxPanel));
                netxPanel.init();
                PluginAppletPanelFactory.this.initEventQueue(netxPanel);
            }
        }, "NetXPanel initializer");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
        }
        PluginAppletPanelFactory.setAppletViewerSize(netxPanel, pluginParameters.getWidth(), pluginParameters.getHeight());
        PluginAppletViewer.waitForAppletInit(netxPanel);
        Applet applet = netxPanel.getApplet();
        if (applet == null) {
            pluginStreamHandler.write("instance " + n + " reference " + -1 + " fatalError: " + "Initialization timed out");
            return null;
        }
        PluginDebug.debug("Applet ", applet.getClass(), " initialized");
        pluginStreamHandler.write("instance " + n + " reference 0 initialized");
        netxPanel.removeSplash();
        AppletSecurityContextManager.getSecurityContext(0).associateSrc(netxPanel.getAppletClassLoader(), uRL);
        AppletSecurityContextManager.getSecurityContext(0).associateInstance(n, netxPanel.getAppletClassLoader());
        return netxPanel;
    }

    private static void setAppletViewerSize(final AppletPanel appletPanel, final int n, final int n2) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    appletPanel.getParent().setSize(n, n2);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            PluginDebug.debug("Unable to resize panel: ");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            PluginDebug.debug("Unable to resize panel: ");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
        }
    }

    private void initEventQueue(AppletPanel appletPanel) {
        PrivilegedAction<String> privilegedAction = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("appletviewer.send.event");
            }
        };
        String string = AccessController.doPrivileged(privilegedAction);
        if (string == null) {
            appletPanel.sendEvent(1);
            appletPanel.sendEvent(2);
            appletPanel.sendEvent(3);
        } else {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                PluginDebug.debug("Adding event to queue: ", string2);
                if ("dispose".equals(string2)) {
                    appletPanel.sendEvent(0);
                    continue;
                }
                if ("load".equals(string2)) {
                    appletPanel.sendEvent(1);
                    continue;
                }
                if ("init".equals(string2)) {
                    appletPanel.sendEvent(2);
                    continue;
                }
                if ("start".equals(string2)) {
                    appletPanel.sendEvent(3);
                    continue;
                }
                if ("stop".equals(string2)) {
                    appletPanel.sendEvent(4);
                    continue;
                }
                if ("destroy".equals(string2)) {
                    appletPanel.sendEvent(5);
                    continue;
                }
                if ("quit".equals(string2)) {
                    appletPanel.sendEvent(6);
                    continue;
                }
                if ("error".equals(string2)) {
                    appletPanel.sendEvent(7);
                    continue;
                }
                PluginDebug.debug("Unrecognized event name: ", string2);
            }
            while (!appletPanel.emptyEventQueue()) {
            }
        }
    }
}

