/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.nanoxml.XMLParseException;

public class XMLElement {
    private Hashtable<String, Object> attributes;
    private Vector<XMLElement> children;
    private String name;
    private String contents;
    private Hashtable<String, char[]> entities;
    private int lineNr;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private char sanitizeCharReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    public XMLElement() {
        this(new Hashtable<String, char[]>(), false, true, true);
    }

    protected XMLElement(Hashtable<String, char[]> hashtable, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreWhitespace = bl;
        this.ignoreCase = bl3;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.entities = hashtable;
        this.lineNr = 0;
        Enumeration<String> enumeration = this.entities.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            char[] cArray = this.entities.get(string);
            if (!(cArray instanceof String)) continue;
            hashtable.put(string, ((String)cArray).toCharArray());
        }
        if (bl2) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public void addChild(XMLElement xMLElement) {
        this.children.addElement(xMLElement);
    }

    public void setAttribute(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, object.toString());
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration<String> enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration<XMLElement> enumerateChildren() {
        return this.children.elements();
    }

    public String getContent() {
        return this.contents;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Object getAttribute(String string) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        Object object = this.attributes.get(string);
        return object;
    }

    public String getName() {
        return this.name;
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int n) throws IOException, XMLParseException {
        char c;
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = n;
        while (true) {
            if ((c = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<", c);
            }
            c = this.readChar();
            if (c != '!' && c != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(c);
        this.scanElement(this);
    }

    protected XMLElement createAnotherElement() {
        return new XMLElement(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public void setContent(String string) {
        this.contents = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void scanIdentifier(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if (!((c = this.readChar()) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || c > '~')) {
                this.unreadChar(c);
                return;
            }
            stringBuffer.append(c);
        }
    }

    protected char scanWhitespace() throws IOException {
        char c;
        block3: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c;
    }

    protected char scanWhitespace(StringBuffer stringBuffer) throws IOException {
        char c;
        block4: while (true) {
            c = this.readChar();
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuffer.append(c);
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c;
    }

    protected void scanString(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '\'' && c != '\"') {
            throw this.expectedInput("' or \"");
        }
        char c2;
        while ((c2 = this.readChar()) != c) {
            if (c2 == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c2);
        }
        return;
    }

    protected void scanPCData(StringBuffer stringBuffer) throws IOException {
        while (true) {
            char c;
            if ((c = this.readChar()) == '<') {
                c = this.readChar();
                if (c == '!') {
                    this.checkCDATA(stringBuffer);
                    continue;
                }
                this.unreadChar(c);
                return;
            }
            if (c == '&') {
                this.resolveEntity(stringBuffer);
                continue;
            }
            stringBuffer.append(c);
        }
    }

    protected boolean checkCDATA(StringBuffer stringBuffer) throws IOException {
        char c = this.readChar();
        if (c != '[') {
            this.unreadChar(c);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int n = 0;
        block4: while (n < 3) {
            int n2;
            c = this.readChar();
            switch (c) {
                case ']': {
                    if (n < 2) {
                        ++n;
                        continue block4;
                    }
                    stringBuffer.append(']');
                    stringBuffer.append(']');
                    n = 0;
                    continue block4;
                }
                case '>': {
                    if (n < 2) {
                        for (n2 = 0; n2 < n; ++n2) {
                            stringBuffer.append(']');
                        }
                        n = 0;
                        stringBuffer.append('>');
                        continue block4;
                    }
                    n = 3;
                    continue block4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(']');
            }
            stringBuffer.append(c);
            n = 0;
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int n = 2;
        while (n > 0) {
            char c = this.readChar();
            n = c == '-' ? --n : 2;
            if (n != 0) continue;
            c = this.readChar();
            if (c == '>') {
                return;
            }
            n = 2;
            this.unreadChar(c);
        }
    }

    protected void skipSpecialTag(int n) throws IOException {
        char c;
        int n2 = 1;
        char c2 = '\u0000';
        if (n == 0) {
            c = this.readChar();
            if (c == '[') {
                ++n;
            } else if (c == '-') {
                c = this.readChar();
                if (c == '[') {
                    ++n;
                } else if (c == ']') {
                    --n;
                } else if (c == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n2 > 0) {
            c = this.readChar();
            if (c2 == '\u0000') {
                if (c == '\"' || c == '\'') {
                    c2 = c;
                } else if (n <= 0) {
                    if (c == '<') {
                        ++n2;
                    } else if (c == '>') {
                        --n2;
                    }
                }
                if (c == '[') {
                    ++n;
                    continue;
                }
                if (c != ']') continue;
                --n;
                continue;
            }
            if (c != c2) continue;
            c2 = '\u0000';
        }
    }

    protected boolean checkLiteral(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (this.readChar() == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char c = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return c;
        }
        int n = this.reader.read();
        if (n < 0) {
            throw this.unexpectedEndOfData();
        }
        if (n == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)n;
    }

    protected void scanElement(XMLElement xMLElement) throws IOException {
        Object object;
        char c;
        String string;
        StringBuffer stringBuffer;
        block22: {
            stringBuffer = new StringBuffer();
            this.scanIdentifier(stringBuffer);
            string = stringBuffer.toString();
            xMLElement.setName(string);
            c = this.scanWhitespace();
            while (c != '>' && c != '/') {
                stringBuffer.setLength(0);
                this.unreadChar(c);
                this.scanIdentifier(stringBuffer);
                object = stringBuffer.toString();
                c = this.scanWhitespace();
                if (c != '=') {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                stringBuffer.setLength(0);
                this.scanString(stringBuffer);
                xMLElement.setAttribute((String)object, stringBuffer);
                c = this.scanWhitespace();
            }
            if (c == '/') {
                c = this.readChar();
                if (c != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            stringBuffer.setLength(0);
            c = this.scanWhitespace(stringBuffer);
            if (c != '<') {
                this.unreadChar(c);
                this.scanPCData(stringBuffer);
            } else {
                while ((c = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuffer)) {
                        this.scanPCData(stringBuffer);
                    } else {
                        c = this.scanWhitespace(stringBuffer);
                        if (c == '<') continue;
                        this.unreadChar(c);
                        this.scanPCData(stringBuffer);
                    }
                    break block22;
                }
                stringBuffer.setLength(0);
            }
        }
        if (stringBuffer.length() == 0) {
            while (c != '/') {
                if (c == '!') {
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    c = this.readChar();
                    if (c != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(c);
                    object = this.createAnotherElement();
                    this.scanElement((XMLElement)object);
                    xMLElement.addChild((XMLElement)object);
                }
                c = this.scanWhitespace();
                if (c != '<') {
                    throw this.expectedInput("<");
                }
                c = this.readChar();
            }
            this.unreadChar(c);
        } else if (this.ignoreWhitespace) {
            xMLElement.setContent(stringBuffer.toString().trim());
        } else {
            xMLElement.setContent(stringBuffer.toString());
        }
        c = this.readChar();
        if (c != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(string)) {
            throw this.expectedInput(string);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void resolveEntity(StringBuffer stringBuffer) throws IOException {
        char c = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer();
        while ((c = this.readChar()) != ';') {
            stringBuffer2.append(c);
        }
        String string = stringBuffer2.toString();
        if (string.charAt(0) == '#') {
            try {
                c = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(c);
        } else {
            char[] cArray = this.entities.get(string);
            if (cArray == null) {
                throw this.unknownEntity(string);
            }
            stringBuffer.append(cArray);
        }
    }

    protected void unreadChar(char c) {
        this.charReadTooMuch = c;
    }

    protected XMLParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (entity name = \"" + string + "\")";
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException invalidValue(String string, String string2) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid " + "value (\"" + string2 + "\")";
        return new XMLParseException(this.getName(), this.parserLineNr, string3);
    }

    protected XMLParseException unexpectedEndOfData() {
        String string = "Unexpected end of data reached";
        return new XMLParseException(this.getName(), this.parserLineNr, string);
    }

    protected XMLParseException syntaxError(String string) {
        String string2 = "Syntax error while parsing " + string;
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException expectedInput(String string) {
        String string2 = "Expected: " + string;
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException expectedInput(String string, char c) {
        String string2 = "Expected: '" + string + "'" + " but got: '" + c + "'";
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException unknownEntity(String string) {
        String string2 = "Unknown or invalid entity: &" + string + ";";
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    public void sanitizeInput(Reader reader, OutputStream outputStream) {
        try {
            PrintStream printStream = new PrintStream(outputStream);
            this.sanitizeCharReadTooMuch = '\u0000';
            this.reader = reader;
            this.parserLineNr = 0;
            int n = 2;
            int n2 = 32;
            while (true) {
                int n3;
                char c;
                if (this.sanitizeCharReadTooMuch != '\u0000') {
                    c = this.sanitizeCharReadTooMuch;
                    this.sanitizeCharReadTooMuch = '\u0000';
                } else {
                    n3 = this.reader.read();
                    if (n3 == -1) {
                        printStream.flush();
                        break;
                    }
                    c = n3 == 10 ? (char)'\n' : (char)((char)n3);
                }
                int n4 = this.reader.read();
                if (n4 == -1) {
                    printStream.print(c);
                    printStream.flush();
                    if (!JNLPRuntime.isDebug()) break;
                    if (c == '\n') {
                        OutputController.getLogger().printOutLn("");
                        OutputController.getLogger().printOut("line: " + n + " ");
                        ++n;
                        break;
                    }
                    OutputController.getLogger().printOut(c + "");
                    break;
                }
                n3 = n4 == 10 ? 10 : (int)((char)n4);
                this.sanitizeCharReadTooMuch = (char)n3;
                if (c == '<' && this.sanitizeCharReadTooMuch == '!') {
                    c = (char)this.reader.read();
                    if (c == '-') {
                        c = (char)this.reader.read();
                        if (c == '-') {
                            this.skipComment();
                            this.sanitizeCharReadTooMuch = '\u0000';
                        } else {
                            printStream.print('<');
                            printStream.print('!');
                            printStream.print('-');
                            this.sanitizeCharReadTooMuch = c;
                            if (JNLPRuntime.isDebug()) {
                                OutputController.getLogger().printOut("<");
                                OutputController.getLogger().printOut("!");
                                OutputController.getLogger().printOut("-");
                            }
                        }
                    } else {
                        printStream.print('<');
                        printStream.print('!');
                        this.sanitizeCharReadTooMuch = c;
                        if (JNLPRuntime.isDebug()) {
                            OutputController.getLogger().printOut("<");
                            OutputController.getLogger().printOut("!");
                        }
                    }
                } else {
                    printStream.print(c);
                    if (JNLPRuntime.isDebug()) {
                        if (c == '\n') {
                            OutputController.getLogger().printOutLn("");
                            OutputController.getLogger().printOut("line: " + n + " ");
                            ++n;
                        } else {
                            OutputController.getLogger().printOut(c + "");
                        }
                    }
                }
                n2 = n3;
            }
            printStream.close();
            reader.close();
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
    }
}

