/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PropertiesFile
extends Properties {
    File file;
    String header = "netx file";
    long lastStore;

    public PropertiesFile(File file) {
        this.file = file;
    }

    public PropertiesFile(File file, String string) {
        this.file = file;
        this.header = string;
    }

    @Override
    public String getProperty(String string) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.getProperty(string);
    }

    @Override
    public String getProperty(String string, String string2) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.getProperty(string, string2);
    }

    @Override
    public Object setProperty(String string, String string2) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.setProperty(string, string2);
    }

    public File getStoreFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (!this.file.exists()) {
            return false;
        }
        long l = this.file.lastModified();
        long l2 = System.currentTimeMillis();
        if (this.lastStore == 0L || l != this.lastStore || l == this.lastStore && l / 1000L == l2 / 1000L) {
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(this.file);
                    this.load(fileInputStream);
                }
                finally {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                        this.lastStore = l;
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                this.file.getParentFile().mkdirs();
                fileOutputStream = new FileOutputStream(this.file);
                this.store(fileOutputStream, this.header);
                fileOutputStream.getChannel().force(true);
                this.lastStore = this.file.lastModified();
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
    }
}

