/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CertInformation {
    private boolean hasExpiredCert = false;
    private boolean hasExpiringCert = false;
    private boolean isNotYetValidCert = false;
    private boolean hasBadKeyUsage = false;
    private boolean hasBadExtendedKeyUsage = false;
    private boolean hasBadNetscapeCertType = false;
    private boolean alreadyTrustPublisher = false;
    private boolean rootInCacerts = false;
    private EnumSet<Detail> details = EnumSet.noneOf(Detail.class);
    private HashMap<String, Integer> signedJars = new HashMap();

    public boolean hasSigningIssues() {
        return this.hasExpiredCert || this.isNotYetValidCert || this.hasBadKeyUsage || this.hasBadExtendedKeyUsage || this.hasBadNetscapeCertType;
    }

    public boolean isPublisherAlreadyTrusted() {
        return this.alreadyTrustPublisher;
    }

    public void setAlreadyTrustPublisher() {
        this.alreadyTrustPublisher = true;
    }

    public boolean isRootInCacerts() {
        return this.rootInCacerts;
    }

    public void setRootInCacerts() {
        this.rootInCacerts = true;
        this.details.add(Detail.TRUSTED);
    }

    public void resetForReverification() {
        this.alreadyTrustPublisher = false;
        this.rootInCacerts = false;
        this.removeFromDetails(Detail.UNTRUSTED);
        this.removeFromDetails(Detail.TRUSTED);
    }

    public boolean isSignerOfJar(String string) {
        return this.signedJars.containsKey(string);
    }

    public void setNumJarEntriesSigned(String string, int n) {
        if (this.signedJars.containsKey(string)) {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "WARNING: A jar that has already been verified is being yet again verified: " + string);
        } else {
            this.signedJars.put(string, n);
        }
    }

    public int getNumJarEntriesSigned(String string) {
        return this.signedJars.get(string);
    }

    public Map<String, Integer> getSignedJars() {
        return this.signedJars;
    }

    public List<String> getDetailsAsStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Detail detail : this.details) {
            arrayList.add(detail.message());
        }
        return arrayList;
    }

    private void removeFromDetails(Detail detail) {
        this.details.remove((Object)detail);
    }

    public void setHasExpiredCert() {
        this.hasExpiredCert = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.EXPIRED);
    }

    public void setHasExpiringCert() {
        this.hasExpiringCert = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.EXPIRING);
    }

    public boolean hasExpiringCert() {
        return this.hasExpiringCert;
    }

    public void setNotYetValidCert() {
        this.isNotYetValidCert = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.NOT_YET_VALID);
    }

    public void setBadKeyUsage() {
        this.hasBadKeyUsage = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.BAD_KEY_USAGE);
    }

    public void setBadExtendedKeyUsage() {
        this.hasBadExtendedKeyUsage = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.BAT_EXTENDED_KEY_USAGE);
    }

    public void setBadNetscapeCertType() {
        this.hasBadNetscapeCertType = true;
        this.details.add(Detail.RUN_WITHOUT_RESTRICTIONS);
        this.details.add(Detail.BAD_NETSCAPE_CERT_TYPE);
    }

    public void setUntrusted() {
        this.details.add(Detail.UNTRUSTED);
    }

    static enum Detail {
        TRUSTED(Translator.R("STrustedCertificate")),
        UNTRUSTED(Translator.R("SUntrustedCertificate")),
        RUN_WITHOUT_RESTRICTIONS(Translator.R("SRunWithoutRestrictions")),
        EXPIRED(Translator.R("SHasExpiredCert")),
        EXPIRING(Translator.R("SHasExpiringCert")),
        NOT_YET_VALID(Translator.R("SNotYetValidCert")),
        BAD_KEY_USAGE(Translator.R("SBadKeyUsage")),
        BAT_EXTENDED_KEY_USAGE(Translator.R("SBadExtendedKeyUsage")),
        BAD_NETSCAPE_CERT_TYPE(Translator.R("SBadNetscapeCertType"));

        private final String message;

        private Detail(String string2) {
            this.message = string2;
        }

        public String message() {
            return this.message;
        }
    }
}

