/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.parts.DescriptionInfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.util.logging.OutputController;

public class InformationElement {
    private InfoItem title;
    private InfoItem vendor;
    private InfoItem homepage;
    private List<DescriptionInfoItem> descriptions = new ArrayList<DescriptionInfoItem>(5);

    public void setTitle(String string) {
        if (string == null) {
            return;
        }
        this.title = new InfoItem("title", string);
    }

    public void setvendor(String string) {
        if (string == null) {
            return;
        }
        this.vendor = new InfoItem("vendor", string);
    }

    public void setHomepage(String string) {
        if (string == null) {
            return;
        }
        this.homepage = new InfoItem("homepage", string);
    }

    public void addDescription(String string) {
        this.addDescription(string, null);
    }

    public void addDescription(String string, String string2) {
        if (string == null) {
            return;
        }
        DescriptionInfoItem descriptionInfoItem = new DescriptionInfoItem(string, string2);
        for (DescriptionInfoItem descriptionInfoItem2 : this.descriptions) {
            if (!descriptionInfoItem2.isOfSameKind(descriptionInfoItem)) continue;
            this.descriptions.remove(descriptionInfoItem2);
            this.descriptions.add(descriptionInfoItem);
            return;
        }
        this.descriptions.add(descriptionInfoItem);
    }

    public InfoItem getBestMatchingDescriptionForSplash() {
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (!InfoItem.descriptionKindOneLine.equals(descriptionInfoItem.getKind())) continue;
            return descriptionInfoItem;
        }
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (descriptionInfoItem.getKind() != null) continue;
            return descriptionInfoItem;
        }
        return null;
    }

    public InfoItem getLongestDescriptionForSplash() {
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (!InfoItem.descriptionKindShort.equals(descriptionInfoItem.getKind())) continue;
            return descriptionInfoItem;
        }
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (descriptionInfoItem.getKind() != null) continue;
            return descriptionInfoItem;
        }
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (!InfoItem.descriptionKindOneLine.equals(descriptionInfoItem.getKind())) continue;
            return descriptionInfoItem;
        }
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (!InfoItem.descriptionKindToolTip.equals(descriptionInfoItem.getKind())) continue;
            return descriptionInfoItem;
        }
        return null;
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.toNiceString();
    }

    public String getVendor() {
        if (this.vendor == null) {
            return null;
        }
        return this.vendor.toNiceString();
    }

    public String getHomepage() {
        if (this.homepage == null) {
            return null;
        }
        return this.homepage.toNiceString();
    }

    List<DescriptionInfoItem> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public String getDescription() {
        InfoItem infoItem = this.getBestMatchingDescriptionForSplash();
        if (infoItem == null) {
            return null;
        }
        return infoItem.toNiceString();
    }

    public List<String> getHeader() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        String string = this.getTitle();
        String string2 = this.getVendor();
        String string3 = this.getHomepage();
        if (string != null) {
            arrayList.add(string);
        }
        if (string2 != null) {
            arrayList.add(string2);
        }
        if (string3 != null) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static InformationElement createFromJNLP(JNLPFile jNLPFile) {
        try {
            if (jNLPFile == null) {
                String string = Translator.R("SPLASHerrorInInformation");
                InformationElement informationElement = new InformationElement();
                informationElement.setHomepage("");
                informationElement.setTitle(string);
                informationElement.setvendor("");
                informationElement.addDescription(string);
                return informationElement;
            }
            if (jNLPFile.getInformation() == null) {
                String string = Translator.R("SPLASHmissingInformation");
                InformationElement informationElement = new InformationElement();
                informationElement.setHomepage("");
                informationElement.setTitle(string);
                informationElement.setvendor("");
                informationElement.addDescription(string);
                return informationElement;
            }
            InformationElement informationElement = new InformationElement();
            String string = Translator.R("SPLASHdefaultHomepage");
            if (jNLPFile.getInformation().getHomepage() != null) {
                string = jNLPFile.getInformation().getHomepage().toString();
            }
            informationElement.setHomepage(string);
            informationElement.setTitle(jNLPFile.getInformation().getTitle());
            informationElement.setvendor(jNLPFile.getInformation().getVendor());
            informationElement.addDescription(jNLPFile.getInformation().getDescriptionStrict((String)InformationDesc.DEFAULT));
            informationElement.addDescription(jNLPFile.getInformation().getDescriptionStrict(InfoItem.descriptionKindOneLine), InfoItem.descriptionKindOneLine);
            informationElement.addDescription(jNLPFile.getInformation().getDescriptionStrict(InfoItem.descriptionKindShort), InfoItem.descriptionKindShort);
            informationElement.addDescription(jNLPFile.getInformation().getDescriptionStrict(InfoItem.descriptionKindToolTip), InfoItem.descriptionKindToolTip);
            return informationElement;
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            String string = Translator.R("SPLASHerrorInInformation");
            InformationElement informationElement = new InformationElement();
            informationElement.setHomepage("");
            informationElement.setTitle(string);
            informationElement.setvendor("");
            informationElement.addDescription(exception.getMessage());
            return informationElement;
        }
    }
}

