/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.MovingText;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.SplinesDefs;
import net.sourceforge.jnlp.splashscreen.impls.defaultsplashscreen2012.TextWithWaterLevel;
import net.sourceforge.jnlp.splashscreen.parts.BasicComponentSplashScreen;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InformationElement;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class BasePainter
implements Observer {
    protected final BasicComponentSplashScreen master;
    private int waterLevel = 0;
    private int animationsPosition = 0;
    private int greyTextIncrment = 15;
    protected static final Color TEA_LIVE_COLOR = new Color(205, 1, 3);
    protected static final Color BACKGROUND_LIVE_COLOR = Color.white;
    protected static final Color TEA_LEAFS_STALKS_LIVE_COLOR = Color.black;
    protected static final Color PLUGIN_LIVE_COLOR = Color.black;
    protected static final Color WATER_LIVE_COLOR = new Color(80, 131, 160);
    protected static final Color PLAIN_TEXT_LIVE_COLOR = Color.black;
    protected Color teaColor;
    protected Color backgroundColor;
    protected Color teaLeafsStalksColor;
    protected Color pluginColor;
    protected Color waterColor;
    protected Color plainTextColor;
    protected BufferedImage prerenderedStuff;
    private Font teaFont;
    private Font icedFont;
    private Font webFont;
    private Font pluginFont;
    private Font plainTextsFont;
    private Font alternativeTextFont;
    private static final String alternativeICED = "Iced    ";
    private static final String alternativeWeb = "Web  ";
    private static final String alternativeTtea = "    Tea";
    private static final String alternativePlugin = "plugin ";
    private static final String ICED = "Iced";
    private static final String web = "web";
    private static final String tea = "Tea";
    private static final String plugin = "plugin  ";
    private final int WEB_TOP_ALIGMENT = 324;
    private final int WEB_LEFT_ALIGMENT = 84;
    protected boolean showNiceTexts = true;
    private boolean showLeaf = true;
    private boolean showInfo = true;
    protected TextWithWaterLevel twl;
    protected TextWithWaterLevel oldTwl;
    protected boolean canWave = true;
    private Point aboutOfset = new Point();
    private static final float[] dash1 = new float[]{10.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);

    protected void paintNiceTexts(Graphics2D graphics2D) {
        this.oldTwl = this.twl;
        this.twl = new TextWithWaterLevel(ICED, this.icedFont);
        if (this.oldTwl != null && !this.canWave) {
            this.twl.setCachedPolygon(this.oldTwl.getCachedPolygon());
        }
        this.twl.setPercentageOfWater(this.waterLevel);
        this.twl.setBgColor(this.backgroundColor);
        this.twl.setWaterColor(this.waterColor);
        this.twl.cutTo(graphics2D, this.scaleX(42.0), this.scaleY(278.0));
        MovingText movingText = new MovingText(web, this.webFont);
        movingText.setPercentageOfWater(this.animationsPosition);
        movingText.cutTo(graphics2D, this.scaleX(84.0), this.scaleY(324.0));
    }

    protected void paintPlainTexts(Graphics2D graphics2D) {
        graphics2D.setFont(this.alternativeTextFont);
        graphics2D.setColor(this.waterColor);
        this.drawTextAroundCenter(graphics2D, -0.6, alternativeICED);
        graphics2D.setColor(this.teaColor);
        this.drawTextAroundCenter(graphics2D, -0.6, alternativeTtea);
        graphics2D.setColor(this.pluginColor);
        String string = this.getAlternativeProductName();
        int n = this.animationsPosition / this.greyTextIncrment;
        n %= string.length();
        if (!this.master.isAnimationRunning()) {
            n = string.length();
        }
        this.drawTextAroundCenter(graphics2D, 0.3, string.substring(0, n));
    }

    private int scaleAvarage(double d) {
        return (int)(this.avarageRatio() * d);
    }

    private int scaleMax(double d) {
        return (int)(this.maxRatio() * d);
    }

    private int scaleMin(double d) {
        return (int)(this.minRatio() * d);
    }

    private double avarageRatio() {
        return (this.getRatioX() + this.getRatioY()) / 2.0;
    }

    private double minRatio() {
        return Math.min(this.getRatioX(), this.getRatioY());
    }

    private double maxRatio() {
        return Math.max(this.getRatioX(), this.getRatioY());
    }

    private int scaleY(double d) {
        return (int)BasePainter.scaleY(this.master.getSplashHeight(), d);
    }

    private int scaleX(double d) {
        return (int)BasePainter.scaleX(this.master.getSplashWidth(), d);
    }

    private double getRatioY() {
        return BasePainter.getRatio(480.0, this.master.getSplashHeight());
    }

    private double getRatioX() {
        return BasePainter.getRatio(635.0, this.master.getSplashWidth());
    }

    private static double scaleY(double d, double d2) {
        return BasePainter.scale(480.0, d, d2);
    }

    private static double scaleX(double d, double d2) {
        return BasePainter.scale(635.0, d, d2);
    }

    private static double getRatioY(double d) {
        return BasePainter.getRatio(480.0, d);
    }

    private static double getRatioX(double d) {
        return BasePainter.getRatio(635.0, d);
    }

    public static double scale(double d, double d2, double d3) {
        return BasePainter.getRatio(d, d2) * d3;
    }

    public static double getRatio(double d, double d2) {
        return d2 / d;
    }

    public BasePainter(BasicComponentSplashScreen basicComponentSplashScreen) {
        this(basicComponentSplashScreen, false);
    }

    public BasePainter(BasicComponentSplashScreen basicComponentSplashScreen, boolean bl) {
        this.master = basicComponentSplashScreen;
        this.setColors();
        this.adjustForSize(basicComponentSplashScreen.getSplashWidth(), basicComponentSplashScreen.getSplashHeight());
        if (bl) {
            this.startAnimationThreads();
        }
    }

    public void increaseAnimationPosition() {
        this.animationsPosition += this.greyTextIncrment;
    }

    protected void ensurePrerenderedStuff() {
        if (this.prerenderedStuff == null) {
            this.prerenderedStuff = this.prerenderStill();
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.ensurePrerenderedStuff();
        if (this.prerenderedStuff != null) {
            graphics2D.drawImage((Image)this.prerenderedStuff, 0, 0, null);
        }
        if (this.showNiceTexts) {
            this.paintNiceTexts(graphics2D);
        } else {
            this.paintPlainTexts(graphics2D);
        }
    }

    public final void adjustForSize(int n, int n2) {
        this.prepareFonts(n, n2);
        this.setEnablings(n, n2, this.master.getVersion(), this.master.getInformationElement(), (Graphics2D)this.master.getGraphics());
        this.prerenderedStuff = this.prerenderStill();
    }

    private void setEnablings(int n, int n2, String string, InformationElement informationElement, Graphics2D graphics2D) {
        this.showLeaf = true;
        if (n > 0 && n2 > 0 && (n2 / n > 2 || n / n2 > 6)) {
            this.showLeaf = false;
        }
        this.showInfo = true;
        if (string != null && graphics2D != null && informationElement != null && informationElement.getHeader() != null && informationElement.getHeader().size() > 0) {
            String string2 = informationElement.getHeader().get(0);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.plainTextsFont);
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.stringWidth(string2);
            if (n4 > n - n3 - 10) {
                this.showInfo = false;
            }
        }
        this.showNiceTexts = !((double)Math.min(n2, n) < ScreenFinder.getCurrentScreenSizeWithoutBounds().getHeight() / 10.0);
    }

    public final void startAnimationThreads() {
        Thread thread = this.getMovingTextThread();
        thread.start();
        Thread thread2 = this.getWaterLevelThread();
        thread2.start();
    }

    private void prepareFonts(int n, int n2) {
        this.master.setSplashHeight(n2);
        this.master.setSplashWidth(n);
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.SIZE, new Integer(this.scaleMin(84.0)));
        hashMap.put(TextAttribute.WIDTH, new Double(0.95));
        hashMap.put(TextAttribute.FAMILY, "Serif");
        this.teaFont = new Font(hashMap);
        HashMap<TextAttribute, Object> hashMap2 = new HashMap<TextAttribute, Object>();
        hashMap2.put(TextAttribute.SIZE, new Integer(this.scaleMin(82.0)));
        hashMap2.put(TextAttribute.WIDTH, new Double(0.8));
        hashMap2.put(TextAttribute.FAMILY, "Serif");
        this.icedFont = new Font(hashMap2);
        HashMap<TextAttribute, Object> hashMap3 = new HashMap<TextAttribute, Object>();
        hashMap3.put(TextAttribute.SIZE, new Integer(this.scaleMin(41.0)));
        hashMap3.put(TextAttribute.WIDTH, new Double(2.0));
        hashMap3.put(TextAttribute.FAMILY, "Serif");
        this.webFont = new Font(hashMap3);
        HashMap<TextAttribute, Object> hashMap4 = new HashMap<TextAttribute, Object>();
        hashMap4.put(TextAttribute.SIZE, new Integer(this.scaleMin(32.0)));
        hashMap4.put(TextAttribute.WEIGHT, new Double(5.0));
        hashMap4.put(TextAttribute.WIDTH, new Double(0.9));
        hashMap4.put(TextAttribute.FAMILY, "Serif");
        this.pluginFont = new Font(hashMap4);
        HashMap<TextAttribute, Object> hashMap5 = new HashMap<TextAttribute, Object>();
        hashMap5.put(TextAttribute.SIZE, new Integer(12));
        hashMap5.put(TextAttribute.FAMILY, "Monospaced");
        this.plainTextsFont = new Font(hashMap5);
        HashMap<TextAttribute, Object> hashMap6 = new HashMap<TextAttribute, Object>();
        hashMap6.put(TextAttribute.SIZE, Math.min(n, n2) / 5);
        hashMap6.put(TextAttribute.WIDTH, new Double(0.7));
        hashMap6.put(TextAttribute.FAMILY, "Monospaced");
        this.alternativeTextFont = new Font(hashMap6);
    }

    private void setColors() {
        this.teaColor = TEA_LIVE_COLOR;
        this.backgroundColor = BACKGROUND_LIVE_COLOR;
        this.teaLeafsStalksColor = TEA_LEAFS_STALKS_LIVE_COLOR;
        this.pluginColor = PLUGIN_LIVE_COLOR;
        this.waterColor = WATER_LIVE_COLOR;
        this.plainTextColor = PLAIN_TEXT_LIVE_COLOR;
    }

    protected BufferedImage prerenderStill() {
        if (this.master.getSplashWidth() <= 0 || this.master.getSplashHeight() <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.master.getSplashWidth(), this.master.getSplashHeight(), 2);
        this.paintStillTo(bufferedImage.createGraphics(), this.master.getInformationElement(), this.master.getVersion());
        return bufferedImage;
    }

    protected void paintStillTo(Graphics2D graphics2D, InformationElement informationElement, String string) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        this.drawBase(graphics2D, informationElement, string);
        graphics2D.setRenderingHints(renderingHints);
    }

    protected void drawTextAroundCenter(Graphics2D graphics2D, double d, String string) {
        int n = this.master.getSplashHeight() / 2 + (graphics2D.getFontMetrics().getHeight() / 2 + (int)(d * (double)graphics2D.getFontMetrics().getHeight()));
        int n2 = this.master.getSplashWidth() / 2 - graphics2D.getFontMetrics().stringWidth(string) / 2;
        graphics2D.drawString(string, n2, n);
    }

    private Thread getMovingTextThread() {
        Thread thread = new Thread(new MovingTextRunner(this));
        return thread;
    }

    static String stripCommitFromVersion(String string) {
        if (string.contains("pre+")) {
            return string;
        }
        int n = string.indexOf("+");
        if (n < 0) {
            return string;
        }
        return string.substring(0, string.indexOf("+"));
    }

    private Thread getWaterLevelThread() {
        Thread thread = new Thread(new WaterLevelThread(this));
        return thread;
    }

    private String getAlternativeProductName() {
        if (SplashUtils.SplashReason.JAVAWS.equals((Object)this.master.getSplashReason())) {
            return alternativeWeb;
        }
        if (SplashUtils.SplashReason.APPLET.equals((Object)this.master.getSplashReason())) {
            return "Web  plugin ";
        }
        return "....";
    }

    protected FontMetrics drawBase(Graphics2D graphics2D, InformationElement informationElement, String string) {
        Object object;
        FontMetrics fontMetrics;
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRect(0, 0, this.master.getSplashWidth() + 5, this.master.getSplashHeight() + 5);
        if (this.showNiceTexts) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setFont(this.teaFont);
            graphics2D.setColor(this.teaColor);
            graphics2D.drawString(tea, this.scaleX(42.0) + graphics2D.getFontMetrics(this.icedFont).stringWidth(ICED), this.scaleY(278.0));
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            if (this.showLeaf) {
                graphics2D.fillPolygon(SplinesDefs.getMainLeafCurve(this.getRatioX(), this.getRatioY()));
            }
            if (this.showLeaf) {
                graphics2D.fillPolygon(SplinesDefs.getSecondLeafCurve(this.getRatioX(), this.getRatioY()));
            }
            graphics2D.setColor(this.teaLeafsStalksColor);
            if (this.showLeaf) {
                graphics2D.fillPolygon(SplinesDefs.getMainLeafStalkCurve(this.getRatioX(), this.getRatioY()));
            }
            if (this.showLeaf) {
                graphics2D.fillPolygon(SplinesDefs.getSecondLeafStalkCurve(this.getRatioX(), this.getRatioY()));
            }
            graphics2D.setFont(this.pluginFont);
            graphics2D.setColor(this.pluginColor);
            if (SplashUtils.SplashReason.APPLET.equals((Object)this.master.getSplashReason())) {
                if (this.showLeaf) {
                    graphics2D.drawString(plugin, this.scaleX(404.0), this.scaleY(145.0));
                } else {
                    fontMetrics = graphics2D.getFontMetrics(this.webFont);
                    graphics2D.drawString(plugin, fontMetrics.stringWidth(web) + this.scaleX(84.0) + 10, this.scaleY(324.0));
                }
            }
            graphics2D.setFont(this.plainTextsFont);
            graphics2D.setColor(this.plainTextColor);
            fontMetrics = graphics2D.getFontMetrics();
            if (informationElement != null) {
                object = informationElement.getBestMatchingDescriptionForSplash();
                List<String> list = informationElement.getHeader();
                if (list != null && this.showInfo) {
                    for (int i = 0; i < list.size(); ++i) {
                        String string2 = list.get(i);
                        graphics2D.drawString(string2, 5, (i + 1) * fontMetrics.getHeight());
                    }
                }
                if (object != null && ((InfoItem)object).getValue() != null) {
                    graphics2D.drawString(((InfoItem)object).getValue(), 5, this.master.getSplashHeight() - fontMetrics.getHeight());
                }
            }
        }
        graphics2D.setFont(this.plainTextsFont);
        graphics2D.setColor(this.plainTextColor);
        fontMetrics = graphics2D.getFontMetrics();
        if (string != null) {
            object = Translator.R("AboutDialogueTabAbout") + ": ";
            int n = fontMetrics.stringWidth((String)object);
            String string3 = BasePainter.stripCommitFromVersion(string);
            int n2 = this.master.getSplashWidth() - fontMetrics.stringWidth(string3 + " ");
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n) {
                string3 = (String)object + string3;
                n2 -= n;
            }
            this.aboutOfset = new Point(n2, fontMetrics.getHeight());
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(dashed);
            graphics2D.drawRect(this.aboutOfset.x - 1, 1, this.master.getSplashWidth() - this.aboutOfset.x - 1, this.aboutOfset.y + 1);
            graphics2D.setStroke(stroke);
            graphics2D.drawString(string3, n2, fontMetrics.getHeight());
        }
        return fontMetrics;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public void setWaterLevel(int n) {
        this.waterLevel = n;
    }

    public int getAnimationsPosition() {
        return this.animationsPosition;
    }

    public void clearCachedWaterTextImage() {
        this.oldTwl = null;
    }

    @Override
    public void update(Observable observable, Object object) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BasePainter.this.master.repaint();
                }
            });
        }
        catch (Exception exception) {
            OutputController.getLogger().log(exception);
        }
    }

    public BasicComponentSplashScreen getMaster() {
        return this.master;
    }

    public Point getAboutOfset() {
        return this.aboutOfset;
    }

    private final class WaterLevelThread
    extends Observable
    implements Runnable {
        private static final int MAX_WATERLEVEL_VALUE = 120;
        private static final int WATER_LEVEL_INCREMENT = 2;

        private WaterLevelThread(BasePainter basePainter2) {
            this.addObserver(basePainter2);
        }

        @Override
        public void run() {
            while (BasePainter.this.master.isAnimationRunning() && BasePainter.this.waterLevel <= 120) {
                try {
                    BasePainter.this.waterLevel += 2;
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(BasePainter.this.waterLevel / 4 * 30);
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(exception);
                }
            }
        }
    }

    private final class MovingTextRunner
    extends Observable
    implements Runnable {
        private static final int MAX_ANIMATION_VALUE = 10000;
        private static final int ANIMATION_RESTART_VALUE = 1;
        private static final long MOOVING_TEXT_DELAY = 150L;

        public MovingTextRunner(Observer observer) {
            this.addObserver(observer);
        }

        @Override
        public void run() {
            while (BasePainter.this.master.isAnimationRunning()) {
                try {
                    BasePainter.this.animationsPosition += BasePainter.this.greyTextIncrment;
                    if (BasePainter.this.animationsPosition > 10000) {
                        BasePainter.this.animationsPosition = 1;
                    }
                    this.setChanged();
                    this.notifyObservers();
                    Thread.sleep(150L);
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(exception);
                }
            }
        }
    }
}

