/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.jnlp.PrintService;
import javax.swing.JOptionPane;
import net.sourceforge.jnlp.util.logging.OutputController;

public class XPrintService
implements PrintService {
    private PrinterJob pj = PrinterJob.getPrinterJob();

    @Override
    public PageFormat getDefaultPage() {
        if (this.pj != null) {
            return this.pj.defaultPage();
        }
        this.showWarning();
        return new PageFormat();
    }

    @Override
    public PageFormat showPageFormatDialog(PageFormat pageFormat) {
        if (this.pj != null) {
            return this.pj.pageDialog(pageFormat);
        }
        this.showWarning();
        return pageFormat;
    }

    @Override
    public boolean print(Pageable pageable) {
        if (this.pj != null) {
            this.pj.setPageable(pageable);
            if (this.pj.printDialog()) {
                try {
                    this.pj.print();
                    return true;
                }
                catch (PrinterException printerException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Could not print: " + printerException);
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, printerException);
                    return false;
                }
            }
        } else {
            this.showWarning();
        }
        return false;
    }

    @Override
    public boolean print(Printable printable) {
        if (this.pj != null) {
            this.pj.setPrintable(printable);
            if (this.pj.printDialog()) {
                try {
                    this.pj.print();
                    return true;
                }
                catch (PrinterException printerException) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Could not print: " + printerException);
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, printerException);
                    return false;
                }
            }
        } else {
            this.showWarning();
        }
        return false;
    }

    private void showWarning() {
        JOptionPane.showMessageDialog(null, "Unable to find a default printer.", "Warning", 2);
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to print: Unable to find default printer.");
    }
}

