/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

class XBasicService
implements BasicService {
    private String command = null;
    private boolean initialized = false;

    protected XBasicService() {
    }

    @Override
    public URL getCodeBase() {
        ApplicationInstance applicationInstance = JNLPRuntime.getApplication();
        if (applicationInstance != null) {
            JNLPFile jNLPFile = applicationInstance.getJNLPFile();
            if (jNLPFile.getCodeBase() != null) {
                return jNLPFile.getCodeBase();
            }
            JARDesc jARDesc = jNLPFile.getResources().getMainJAR();
            if (jARDesc != null) {
                return jARDesc.getLocation();
            }
        }
        return null;
    }

    @Override
    public boolean isOffline() {
        URL uRL = this.findFirstURLFromJNLPFile();
        try {
            uRL.openConnection().getInputStream().close();
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private URL findFirstURLFromJNLPFile() {
        Object object;
        ApplicationInstance applicationInstance = JNLPRuntime.getApplication();
        if (applicationInstance != null) {
            object = applicationInstance.getJNLPFile();
            URL uRL = ((JNLPFile)object).getSourceLocation();
            if (uRL != null) {
                return uRL;
            }
            URL uRL2 = ((JNLPFile)object).getCodeBase();
            if (uRL2 != null) {
                return uRL2;
            }
            InformationDesc informationDesc = ((JNLPFile)object).getInformation();
            URL uRL3 = informationDesc.getHomepage();
            if (uRL3 != null) {
                return uRL3;
            }
            int n = 0;
            JARDesc[] jARDescArray = ((JNLPFile)object).getResources().getJARs();
            JARDesc[] jARDescArray2 = jARDescArray;
            int n2 = jARDescArray2.length;
            if (n < n2) {
                JARDesc jARDesc = jARDescArray2[n];
                return jARDesc.getLocation();
            }
        }
        try {
            object = new URL("http://icedtea.classpath.org");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return object;
    }

    @Override
    public boolean isWebBrowserSupported() {
        this.initialize();
        return this.command != null;
    }

    @Override
    public boolean showDocument(URL uRL) {
        this.initialize();
        if (uRL.toString().endsWith(".jnlp")) {
            try {
                new Launcher().launchExternal(uRL);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.command != null) {
            try {
                Runtime.getRuntime().exec(this.command + " " + uRL.toString());
                return true;
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(iOException);
            }
        }
        return false;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initializeBrowserCommand();
        OutputController.getLogger().log("browser is " + this.command);
    }

    private void initializeBrowserCommand() {
        if (JNLPRuntime.isWindows()) {
            this.command = "rundll32 url.dll,FileProtocolHandler ";
        } else if (JNLPRuntime.isUnix()) {
            DeploymentConfiguration deploymentConfiguration = JNLPRuntime.getConfiguration();
            this.command = deploymentConfiguration.getProperty("deployment.browser.path");
            if (this.command != null) {
                return;
            }
            if (this.posixCommandExists("xdg-open")) {
                this.command = "xdg-open";
                return;
            }
            if (this.posixCommandExists(System.getenv("BROWSER"))) {
                this.command = System.getenv("BROWSER");
                return;
            }
            do {
                this.command = this.promptForCommand(this.command);
            } while (this.command == null || !this.posixCommandExists(this.command));
            deploymentConfiguration.setProperty("deployment.browser.path", this.command);
            try {
                deploymentConfiguration.save();
            }
            catch (IOException iOException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            }
        } else {
            DeploymentConfiguration deploymentConfiguration = JNLPRuntime.getConfiguration();
            this.command = deploymentConfiguration.getProperty("deployment.browser.path");
            if (this.command == null) {
                this.command = this.promptForCommand(null);
                if (this.command != null) {
                    deploymentConfiguration.setProperty("deployment.browser.path", this.command);
                    try {
                        deploymentConfiguration.save();
                    }
                    catch (IOException iOException) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
                    }
                }
            }
        }
    }

    private boolean posixCommandExists(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if ((string = string.trim()).contains("\n") || string.contains("\r")) {
            return false;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", "type " + string});
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, interruptedException);
            return false;
        }
    }

    private String promptForCommand(String string) {
        String string2 = null;
        string2 = string == null ? Translator.R("RBrowserLocationPromptMessage") : Translator.R("RBrowserLocationPromptMessageWithReason", string);
        return JOptionPane.showInputDialog(new JPanel(), Translator.R("RBrowserLocationPromptTitle"), string2, -1);
    }
}

