/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.NetPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogMessage;
import net.sourceforge.jnlp.security.UnsignedAppletTrustWarningPanel;
import net.sourceforge.jnlp.security.appletextendedsecurity.ExecuteUnsignedApplet;

public class SecurityDialogs {
    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile jNLPFile) {
        return SecurityDialogs.showAccessWarningDialog(accessType, jNLPFile, null);
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile jNLPFile, Object[] objectArray) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage securityDialogMessage = new SecurityDialogMessage();
        securityDialogMessage.dialogType = DialogType.ACCESS_WARNING;
        securityDialogMessage.accessType = accessType;
        securityDialogMessage.file = jNLPFile;
        securityDialogMessage.extras = objectArray;
        Object object = SecurityDialogs.getUserResponse(securityDialogMessage);
        return SecurityDialogs.getIntegerResponseAsBoolean(object);
    }

    public static boolean showNotAllSignedWarningDialog(JNLPFile jNLPFile) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage securityDialogMessage = new SecurityDialogMessage();
        securityDialogMessage.dialogType = DialogType.NOTALLSIGNED_WARNING;
        securityDialogMessage.accessType = AccessType.NOTALLSIGNED;
        securityDialogMessage.file = jNLPFile;
        securityDialogMessage.extras = new Object[0];
        Object object = SecurityDialogs.getUserResponse(securityDialogMessage);
        return SecurityDialogs.getIntegerResponseAsBoolean(object);
    }

    public static UnsignedAppletTrustWarningPanel.UnsignedWarningAction showUnsignedWarningDialog(JNLPFile jNLPFile) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return new UnsignedAppletTrustWarningPanel.UnsignedWarningAction(ExecuteUnsignedApplet.NO, false);
        }
        SecurityDialogMessage securityDialogMessage = new SecurityDialogMessage();
        securityDialogMessage.dialogType = DialogType.UNSIGNED_WARNING;
        securityDialogMessage.accessType = AccessType.UNSIGNED;
        securityDialogMessage.file = jNLPFile;
        return (UnsignedAppletTrustWarningPanel.UnsignedWarningAction)SecurityDialogs.getUserResponse(securityDialogMessage);
    }

    public static boolean showCertWarningDialog(AccessType accessType, JNLPFile jNLPFile, CertVerifier certVerifier) {
        if (!SecurityDialogs.shouldPromptUser()) {
            return false;
        }
        SecurityDialogMessage securityDialogMessage = new SecurityDialogMessage();
        securityDialogMessage.dialogType = DialogType.CERT_WARNING;
        securityDialogMessage.accessType = accessType;
        securityDialogMessage.file = jNLPFile;
        securityDialogMessage.certVerifier = certVerifier;
        Object object = SecurityDialogs.getUserResponse(securityDialogMessage);
        return SecurityDialogs.getIntegerResponseAsBoolean(object);
    }

    public static Object[] showAuthenicationPrompt(String string, int n, String string2, String string3) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        object = new SecurityDialogMessage();
        ((SecurityDialogMessage)object).dialogType = DialogType.AUTHENTICATION;
        ((SecurityDialogMessage)object).extras = new Object[]{string, n, string2, string3};
        Object object2 = SecurityDialogs.getUserResponse((SecurityDialogMessage)object);
        return (Object[])object2;
    }

    public static int showAppletWarning() {
        if (!SecurityDialogs.shouldPromptUser()) {
            return 2;
        }
        SecurityDialogMessage securityDialogMessage = new SecurityDialogMessage();
        securityDialogMessage.dialogType = DialogType.APPLET_WARNING;
        Object object = SecurityDialogs.getUserResponse(securityDialogMessage);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 2;
    }

    private static Object getUserResponse(final SecurityDialogMessage securityDialogMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            final JDialog jDialog = new JDialog();
            jDialog.setSize(0, 0);
            jDialog.setResizable(false);
            jDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    securityDialogMessage.toDispose = jDialog;
                    securityDialogMessage.lock = null;
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            JNLPRuntime.getSecurityDialogHandler().postMessage(securityDialogMessage);
                            return null;
                        }
                    });
                }
            });
            jDialog.setVisible(true);
        } else {
            securityDialogMessage.toDispose = null;
            securityDialogMessage.lock = new Semaphore(0);
            JNLPRuntime.getSecurityDialogHandler().postMessage(securityDialogMessage);
            boolean bl = false;
            while (!bl) {
                try {
                    securityDialogMessage.lock.acquire();
                    bl = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return securityDialogMessage.userResponse;
    }

    public static boolean getIntegerResponseAsBoolean(Object object) {
        boolean bl = object instanceof Integer;
        if (bl) {
            Integer n = (Integer)object;
            return n == 0;
        }
        return false;
    }

    private static boolean shouldPromptUser() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.security.askgrantdialog.show"));
            }
        });
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CREATE_DESTKOP_SHORTCUT,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        NOTALLSIGNED,
        UNSIGNED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        NOTALLSIGNED_WARNING,
        UNSIGNED_WARNING,
        APPLET_WARNING,
        AUTHENTICATION;

    }
}

