/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JDialog;
import javax.swing.UIManager;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.security.AccessWarningPane;
import net.sourceforge.jnlp.security.AppletWarningPane;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertWarningPane;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.MoreInfoPane;
import net.sourceforge.jnlp.security.NotAllSignedWarningPane;
import net.sourceforge.jnlp.security.PasswordAuthenticationPane;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.SingleCertInfoPane;
import net.sourceforge.jnlp.security.UnsignedAppletTrustWarningDialog;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialog
extends JDialog {
    private final SecurityDialogs.DialogType dialogType;
    private final SecurityDialogs.AccessType accessType;
    private SecurityDialogPanel panel;
    private final JNLPFile file;
    private final CertVerifier certVerifier;
    private final X509Certificate cert;
    private final Object[] extras;
    private boolean initialized = false;
    private Object value;
    private boolean requiresSignedJNLPWarning;
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile jNLPFile, CertVerifier certVerifier, X509Certificate x509Certificate, Object[] objectArray) {
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = jNLPFile;
        this.certVerifier = certVerifier;
        this.cert = x509Certificate;
        this.extras = objectArray;
        this.initialized = true;
        if (jNLPFile != null) {
            this.requiresSignedJNLPWarning = jNLPFile.requiresSignedJNLPWarning();
        }
        this.initDialog();
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile jNLPFile) {
        this(dialogType, accessType, jNLPFile, null, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile jNLPFile, CertVerifier certVerifier) {
        this(dialogType, accessType, jNLPFile, certVerifier, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, CertVerifier certVerifier) {
        this(dialogType, accessType, null, certVerifier, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile jNLPFile, Object[] objectArray) {
        this(dialogType, accessType, jNLPFile, null, null, objectArray);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, X509Certificate x509Certificate) {
        this(dialogType, null, null, null, x509Certificate, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static void showMoreInfoDialog(CertVerifier certVerifier, SecurityDialog securityDialog) {
        JNLPFile jNLPFile = securityDialog.getFile();
        SecurityDialog securityDialog2 = new SecurityDialog(SecurityDialogs.DialogType.MORE_INFO, null, jNLPFile, certVerifier);
        securityDialog2.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        securityDialog2.setVisible(true);
        securityDialog2.dispose();
    }

    public static void showCertInfoDialog(CertVerifier certVerifier, SecurityDialog securityDialog) {
        SecurityDialog securityDialog2 = new SecurityDialog(SecurityDialogs.DialogType.CERT_INFO, null, null, certVerifier);
        securityDialog2.setLocationRelativeTo(securityDialog);
        securityDialog2.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        securityDialog2.setVisible(true);
        securityDialog2.dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate x509Certificate, JDialog jDialog) {
        SecurityDialog securityDialog = new SecurityDialog(SecurityDialogs.DialogType.SINGLE_CERT_INFO, x509Certificate);
        securityDialog.setLocationRelativeTo(jDialog);
        securityDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        securityDialog.setVisible(true);
        securityDialog.dispose();
    }

    private void initDialog() {
        this.setSystemLookAndFeel();
        String string = "";
        if (this.dialogType == SecurityDialogs.DialogType.CERT_WARNING) {
            string = this.accessType == SecurityDialogs.AccessType.VERIFIED ? "Security Approval Required" : "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.MORE_INFO) {
            string = "More Information";
        } else if (this.dialogType == SecurityDialogs.DialogType.CERT_INFO) {
            string = "Details - Certificate";
        } else if (this.dialogType == SecurityDialogs.DialogType.ACCESS_WARNING) {
            string = "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.APPLET_WARNING) {
            string = "Applet Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.NOTALLSIGNED_WARNING) {
            string = "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.AUTHENTICATION) {
            string = "Authentication Required";
        }
        this.setTitle(string);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.installPanel();
        this.pack();
        SecurityDialog.centerDialog(this);
        WindowAdapter windowAdapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    SecurityDialog.this.selectDefaultButton();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (windowEvent.getSource() instanceof SecurityDialog) {
                    SecurityDialog securityDialog = (SecurityDialog)windowEvent.getSource();
                    securityDialog.setResizable(true);
                    securityDialog.setValue(null);
                }
            }
        };
        this.addWindowListener(windowAdapter);
        this.addWindowFocusListener(windowAdapter);
    }

    public SecurityDialogs.AccessType getAccessType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getCertVerifier() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    private void installPanel() {
        if (this.dialogType == SecurityDialogs.DialogType.CERT_WARNING) {
            this.panel = new CertWarningPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.MORE_INFO) {
            this.panel = new MoreInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.CERT_INFO) {
            this.panel = new CertsInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.SINGLE_CERT_INFO) {
            this.panel = new SingleCertInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.ACCESS_WARNING) {
            this.panel = new AccessWarningPane(this, this.extras, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.APPLET_WARNING) {
            this.panel = new AppletWarningPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.NOTALLSIGNED_WARNING) {
            this.panel = new NotAllSignedWarningPane(this);
        } else if (this.dialogType == SecurityDialogs.DialogType.UNSIGNED_WARNING) {
            this.panel = new UnsignedAppletTrustWarningDialog(this, (PluginBridge)this.file);
        } else if (this.dialogType == SecurityDialogs.DialogType.AUTHENTICATION) {
            this.panel = new PasswordAuthenticationPane(this, this.extras);
        }
        this.add((Component)this.panel, "Center");
    }

    private static void centerDialog(JDialog jDialog) {
        ScreenFinder.centerWindowsToCurrentScreen(jDialog);
    }

    private void selectDefaultButton() {
        if (this.panel == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "initial value panel is null");
        }
        this.panel.requestFocusOnDefaultButton();
    }

    protected void setValue(Object object) {
        OutputController.getLogger().log("Setting value:" + object);
        this.value = object;
    }

    public Object getValue() {
        OutputController.getLogger().log("Returning value:" + this.value);
        return this.value;
    }

    @Override
    public void dispose() {
        this.notifySelectionMade();
        super.dispose();
    }

    protected void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifySelectionMade() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public boolean requiresSignedJNLPWarning() {
        return this.requiresSignedJNLPWarning;
    }
}

