/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import sun.misc.Launcher;

public class MoreInfoPane
extends SecurityDialogPanel {
    private boolean showSignedJNLPWarning;

    public MoreInfoPane(SecurityDialog securityDialog, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
        this.showSignedJNLPWarning = securityDialog.requiresSignedJNLPWarning();
        this.addComponents();
    }

    private void addComponents() {
        Accessible accessible;
        List<String> list = this.certVerifier.getDetails(null);
        if (this.showSignedJNLPWarning) {
            list.add(Translator.R("SJNLPFileIsNotSigned"));
        }
        int n = list.size();
        JPanel jPanel = new JPanel(new GridLayout(n, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setPreferredSize(new Dimension(400, 70 * n));
        for (int i = 0; i < n; ++i) {
            accessible = null;
            accessible = list.get(i).equals(Translator.R("STrustedCertificate")) ? new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/info-small.png")) : new ImageIcon(new Launcher().getClassLoader().getResource("net/sourceforge/jnlp/resources/warning-small.png"));
            jPanel.add(new JLabel(this.htmlWrap(list.get(i)), (Icon)((Object)accessible), 2));
        }
        if (this.showSignedJNLPWarning) {
            list.remove(list.size() - 1);
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        accessible = new JButton(Translator.R("SCertificateDetails"));
        accessible.addActionListener(new CertInfoButtonListener());
        JButton jButton = new JButton(Translator.R("ButClose"));
        jButton.addActionListener(this.createSetValueListener(this.parent, 0));
        jPanel2.add((Component)((Object)accessible), "West");
        jPanel2.add((Component)jButton, "East");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "South");
    }

    private class CertInfoButtonListener
    implements ActionListener {
        private CertInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SecurityDialog.showCertInfoDialog(MoreInfoPane.this.parent.getCertVerifier(), MoreInfoPane.this.parent);
        }
    }
}

