/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class KeyStores {
    public static final Map<Integer, String> keystoresPaths = new HashMap<Integer, String>();
    private static DeploymentConfiguration config = null;
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_PASSWORD = "changeit";

    public static final char[] getPassword() {
        return DEFAULT_PASSWORD.toCharArray();
    }

    public static void setConfiguration(DeploymentConfiguration deploymentConfiguration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        config = deploymentConfiguration;
    }

    public static final KeyStore getKeyStore(Level level, Type type) {
        boolean bl = false;
        bl = level == Level.USER;
        return KeyStores.getKeyStore(level, type, bl);
    }

    public static final KeyStore getKeyStore(Level level, Type type, boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        String string = KeyStores.getKeyStoreLocation(level, type);
        KeyStore keyStore = null;
        try {
            keyStore = KeyStores.createKeyStoreFromFile(new File(string), bl, DEFAULT_PASSWORD);
            keystoresPaths.put(keyStore.hashCode(), string);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
        }
        return keyStore;
    }

    public static String getPathToKeystore(int n) {
        String string = keystoresPaths.get(n);
        if (string == null) {
            return "unknown keystore location";
        }
        return string;
    }

    public static final KeyStore[] getCertKeyStores() {
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>(10);
        KeyStore keyStore = null;
        keyStore = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CERTS);
        if (keyStore != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.SYSTEM, Type.CERTS)) != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.USER, Type.JSSE_CERTS)) != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.USER, Type.CERTS)) != null) {
            arrayList.add(keyStore);
        }
        return arrayList.toArray(new KeyStore[arrayList.size()]);
    }

    public static final KeyStore[] getCAKeyStores() {
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>(10);
        KeyStore keyStore = null;
        keyStore = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CA_CERTS);
        if (keyStore != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.SYSTEM, Type.CA_CERTS)) != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.USER, Type.JSSE_CA_CERTS)) != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.USER, Type.CA_CERTS)) != null) {
            arrayList.add(keyStore);
        }
        return arrayList.toArray(new KeyStore[arrayList.size()]);
    }

    public static KeyStore[] getClientKeyStores() {
        ArrayList<KeyStore> arrayList = new ArrayList<KeyStore>();
        KeyStore keyStore = null;
        keyStore = KeyStores.getKeyStore(Level.SYSTEM, Type.CLIENT_CERTS);
        if (keyStore != null) {
            arrayList.add(keyStore);
        }
        if ((keyStore = KeyStores.getKeyStore(Level.USER, Type.CLIENT_CERTS)) != null) {
            arrayList.add(keyStore);
        }
        return arrayList.toArray(new KeyStore[arrayList.size()]);
    }

    public static final String getKeyStoreLocation(Level level, Type type) {
        String string = null;
        block0 : switch (level) {
            case SYSTEM: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        string = "deployment.system.security.jssecacerts";
                        break;
                    }
                    case CA_CERTS: {
                        string = "deployment.system.security.cacerts";
                        break;
                    }
                    case JSSE_CERTS: {
                        string = "deployment.system.security.trusted.jssecerts";
                        break;
                    }
                    case CERTS: {
                        string = "deployment.system.security.trusted.certs";
                        break;
                    }
                    case CLIENT_CERTS: {
                        string = "deployment.system.security.trusted.clientautcerts";
                    }
                }
                break;
            }
            case USER: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        string = "deployment.user.security.trusted.jssecacerts";
                        break block0;
                    }
                    case CA_CERTS: {
                        string = "deployment.user.security.trusted.cacerts";
                        break block0;
                    }
                    case JSSE_CERTS: {
                        string = "deployment.user.security.trusted.jssecerts";
                        break block0;
                    }
                    case CERTS: {
                        string = "deployment.user.security.trusted.certs";
                        break block0;
                    }
                    case CLIENT_CERTS: {
                        string = "deployment.user.security.trusted.clientauthcerts";
                    }
                }
            }
        }
        if (string == null) {
            throw new RuntimeException("Unspported");
        }
        return config.getProperty(string);
    }

    public static final String toTranslatableString(Level level, Type type) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("KS");
        if (level != null) {
            string = level.toString();
            stringBuilder.append(string.substring(0, 1).toUpperCase());
            stringBuilder.append(string.substring(1).toLowerCase());
        }
        if (type != null) {
            string = type.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                stringBuilder.append(string2.substring(0, 1).toUpperCase());
                stringBuilder.append(string2.substring(1).toLowerCase());
            }
        }
        return stringBuilder.toString();
    }

    public static String toDisplayableString(Level level, Type type) {
        return Translator.R(KeyStores.toTranslatableString(level, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KeyStore createKeyStoreFromFile(File file, boolean bl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = null;){
            if (bl && !file.exists()) {
                File file2 = file.getParentFile();
                if (!file2.isDirectory() && !file2.mkdirs()) {
                    throw new IOException("unable to create " + file2);
                }
                FileUtils.createRestrictedFile(file, true);
                keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
                keyStore.load(null, string.toCharArray());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                keyStore.store(fileOutputStream, string.toCharArray());
                fileOutputStream.close();
            }
            if (file.exists()) {
                fileInputStream = new FileInputStream(file);
                keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
                keyStore.load(fileInputStream, string.toCharArray());
            } else {
                keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
                keyStore.load(null, string.toCharArray());
            }
        }
        return keyStore;
    }

    public static enum Type {
        CERTS,
        JSSE_CERTS,
        CA_CERTS,
        JSSE_CA_CERTS,
        CLIENT_CERTS;

    }

    public static enum Level {
        USER,
        SYSTEM;

    }
}

