/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.security.util.DerValue;
import sun.security.util.HostnameChecker;
import sun.security.x509.X500Name;

public class HttpsCertVerifier
implements CertVerifier {
    private X509Certificate[] chain;
    private String authType;
    private String hostName;
    private boolean isTrusted;
    private boolean hostMatched;
    private ArrayList<String> details = new ArrayList();

    public HttpsCertVerifier(X509Certificate[] x509CertificateArray, String string, boolean bl, boolean bl2, String string2) {
        this.chain = x509CertificateArray;
        this.authType = string;
        this.hostName = string2;
        this.isTrusted = bl;
        this.hostMatched = bl2;
    }

    @Override
    public boolean getAlreadyTrustPublisher() {
        return this.isTrusted;
    }

    @Override
    public CertPath getCertPath(CertPath certPath) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (int i = 0; i < this.chain.length; ++i) {
            arrayList.add(this.chain[i]);
        }
        ArrayList<CertPath> arrayList2 = new ArrayList<CertPath>();
        try {
            arrayList2.add(CertificateFactory.getInstance("X.509").generateCertPath(arrayList));
        }
        catch (CertificateException certificateException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, certificateException);
        }
        return (CertPath)arrayList2.get(0);
    }

    @Override
    public List<String> getDetails(CertPath certPath) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = bl = !this.hostMatched;
        if (!this.getAlreadyTrustPublisher()) {
            bl5 = true;
        }
        for (int i = 0; i < this.chain.length; ++i) {
            X509Certificate x509Certificate = this.chain[i];
            long l = System.currentTimeMillis();
            long l2 = 15552000000L;
            long l3 = x509Certificate.getNotAfter().getTime();
            if (l3 < l) {
                bl2 = true;
            } else if (l3 < l + l2) {
                bl3 = true;
            }
            try {
                x509Certificate.checkValidity();
                continue;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                bl4 = true;
                continue;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                bl2 = true;
            }
        }
        String string = this.getNamesForCert(this.chain[0]);
        if (bl5 || bl2 || bl3 || bl4 || bl) {
            if (bl5) {
                this.addToDetails(Translator.R("SUntrustedCertificate"));
            }
            if (bl2) {
                this.addToDetails(Translator.R("SHasExpiredCert"));
            }
            if (bl3) {
                this.addToDetails(Translator.R("SHasExpiringCert"));
            }
            if (bl4) {
                this.addToDetails(Translator.R("SNotYetValidCert"));
            }
            if (bl) {
                this.addToDetails(Translator.R("SCNMisMatch", string, this.hostName));
            }
        }
        return this.details;
    }

    private String getNamesForCert(X509Certificate x509Certificate) {
        String string = "";
        int n = 2;
        int n2 = 7;
        try {
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            X500Name x500Name = HostnameChecker.getSubjectX500Name(x509Certificate);
            DerValue derValue = x500Name.findMostSpecificAttribute(X500Name.commonName_oid);
            string = string + derValue.getAsString();
            if (collection != null) {
                for (List<?> list : collection) {
                    if ((Integer)list.get(0) != n2 && (Integer)list.get(0) != n) continue;
                    string = string + ", " + (String)list.get(1);
                }
            }
            if (collection != null) {
                string = string.substring(2);
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, certificateParsingException);
        }
        catch (IOException iOException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
        }
        return string;
    }

    private void addToDetails(String string) {
        if (!this.details.contains(string)) {
            this.details.add(string);
        }
    }

    @Override
    public Certificate getPublisher(CertPath certPath) {
        if (this.chain.length > 0) {
            return this.chain[0];
        }
        return null;
    }

    @Override
    public Certificate getRoot(CertPath certPath) {
        if (this.chain.length > 0) {
            return this.chain[this.chain.length - 1];
        }
        return null;
    }

    @Override
    public boolean getRootInCacerts() {
        try {
            KeyStore[] keyStoreArray = KeyStores.getCAKeyStores();
            return CertificateUtils.inKeyStores((X509Certificate)this.getRoot(null), keyStoreArray);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean hasSigningIssues(CertPath certPath) {
        return false;
    }
}

