/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertificateUtils;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialog;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.misc.Launcher;

public class CertWarningPane
extends SecurityDialogPanel {
    JCheckBox alwaysTrust;
    CertVerifier certVerifier;

    public CertWarningPane(SecurityDialog securityDialog, CertVerifier certVerifier) {
        super(securityDialog, certVerifier);
        this.certVerifier = certVerifier;
        this.addComponents();
    }

    private void addComponents() {
        SecurityDialogs.AccessType accessType = this.parent.getAccessType();
        JNLPFile jNLPFile = this.parent.getFile();
        Certificate certificate = this.parent.getCertVerifier().getPublisher(null);
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            string = this.certVerifier instanceof HttpsCertVerifier && certificate instanceof X509Certificate ? SecurityUtil.getCN(((X509Certificate)certificate).getSubjectX500Principal().getName()) : (jNLPFile instanceof PluginBridge ? jNLPFile.getTitle() : jNLPFile.getInformation().getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (certificate instanceof X509Certificate) {
                string2 = SecurityUtil.getCN(((X509Certificate)certificate).getSubjectX500Principal().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = jNLPFile instanceof PluginBridge ? jNLPFile.getCodeBase().getHost() : jNLPFile.getInformation().getHomepage().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = "";
        String string5 = this.parent.getCertVerifier().getRootInCacerts() ? Translator.R("STrustedSource") : Translator.R("SUntrustedSource");
        String string6 = "";
        String string7 = "net/sourceforge/jnlp/resources/";
        boolean bl = false;
        if (this.certVerifier instanceof HttpsCertVerifier) {
            string4 = Translator.R("SHttpsUnverified") + " " + Translator.R("Continue");
            string6 = "OptionPane.warningIcon";
            string7 = string7 + "warning.png";
        } else {
            switch (accessType) {
                case VERIFIED: {
                    string4 = Translator.R("SSigVerified");
                    string6 = "OptionPane.informationIcon";
                    string7 = string7 + "question.png";
                    bl = true;
                    break;
                }
                case UNVERIFIED: {
                    string4 = Translator.R("SSigUnverified");
                    string6 = "OptionPane.warningIcon";
                    string7 = string7 + "warning.png";
                    string5 = string5 + " " + Translator.R("SWarnFullPermissionsIgnorePolicy");
                    break;
                }
                case SIGNING_ERROR: {
                    string4 = Translator.R("SSignatureError");
                    string6 = "OptionPane.warningIcon";
                    string7 = string7 + "warning.png";
                    string5 = string5 + " " + Translator.R("SWarnFullPermissionsIgnorePolicy");
                }
            }
        }
        ImageIcon imageIcon = new ImageIcon(new Launcher().getClassLoader().getResource(string7));
        JLabel jLabel = new JLabel(this.htmlWrap(string4), imageIcon, 2);
        jLabel.setFont(new Font(jLabel.getFont().toString(), 1, 12));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.WHITE);
        jPanel.add((Component)jLabel, "Center");
        jPanel.setPreferredSize(new Dimension(400, 75));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel2 = new JLabel(Translator.R("Name") + ":   " + string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel3 = new JLabel(Translator.R("Publisher") + ": " + string2);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel4 = new JLabel(Translator.R("From") + ":   " + string3);
        jLabel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.alwaysTrust = new JCheckBox(Translator.R("SAlwaysTrustPublisher"));
        this.alwaysTrust.setEnabled(true);
        this.alwaysTrust.setSelected(bl);
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        jPanel2.add(jLabel2);
        jPanel2.add(jLabel3);
        if (!(this.certVerifier instanceof HttpsCertVerifier)) {
            jPanel2.add(jLabel4);
        }
        jPanel2.add(this.alwaysTrust);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton(Translator.R("ButRun"));
        JButton jButton2 = new JButton(Translator.R("ButCancel"));
        int n = Math.max(jButton.getMinimumSize().width, jButton2.getMinimumSize().width);
        int n2 = jButton.getMinimumSize().height;
        Dimension dimension = new Dimension(n, n2);
        jButton.setPreferredSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton.addActionListener(this.createSetValueListener(this.parent, 0));
        jButton.addActionListener(new CheckBoxListener());
        jButton2.addActionListener(this.createSetValueListener(this.parent, 1));
        this.initialFocusComponent = jButton2;
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
        JLabel jLabel5 = new JLabel(this.htmlWrap(string5));
        JButton jButton3 = new JButton(Translator.R("ButMoreInformation"));
        jButton3.addActionListener(new MoreInfoButtonListener());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jLabel5);
        jPanel4.add(jButton3);
        jPanel4.setPreferredSize(new Dimension(600, 100));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(jPanel4);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CertWarningPane.this.alwaysTrust != null && CertWarningPane.this.alwaysTrust.isSelected()) {
                try {
                    KeyStore keyStore = KeyStores.getKeyStore(KeyStores.Level.USER, KeyStores.Type.CERTS);
                    X509Certificate x509Certificate = (X509Certificate)CertWarningPane.this.parent.getCertVerifier().getPublisher(null);
                    CertificateUtils.addToKeyStore(x509Certificate, keyStore);
                    File file = new File(KeyStores.getKeyStoreLocation(KeyStores.Level.USER, KeyStores.Type.CERTS));
                    if (!file.isFile()) {
                        FileUtils.createRestrictedFile(file, true);
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                        keyStore.store(fileOutputStream, KeyStores.getPassword());
                    }
                    OutputController.getLogger().log("certificate is now permanently trusted");
                }
                catch (Exception exception) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
                }
            }
        }
    }

    private class MoreInfoButtonListener
    implements ActionListener {
        private MoreInfoButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SecurityDialog.showMoreInfoDialog(CertWarningPane.this.parent.getCertVerifier(), CertWarningPane.this.parent);
        }
    }
}

