/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Window;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.Permission;
import javax.swing.JWindow;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.WeakList;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;

class JNLPSecurityManager
extends AWTSecurityManager {
    private Object exitClass = null;
    private SecurityException closeAppEx = new SecurityException(Translator.R("RShutdown"));
    private WeakList<Window> weakWindows = new WeakList();
    private WeakList<ApplicationInstance> weakApplications = new WeakList();
    private boolean exitAllowed = true;
    private AppContext mainAppContext;

    JNLPSecurityManager() {
        if (!JNLPRuntime.isHeadless()) {
            new JWindow().getOwner();
        }
        this.mainAppContext = AppContext.getAppContext();
    }

    public boolean isExitClass() {
        return this.isExitClass(this.getClassContext());
    }

    private boolean isExitClass(Class[] classArray) {
        if (this.exitClass == null) {
            return true;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != this.exitClass) continue;
            return true;
        }
        return false;
    }

    public void setExitClass(Class<?> clazz) throws IllegalStateException {
        if (this.exitClass != null) {
            throw new IllegalStateException(Translator.R("RExitTaken"));
        }
        this.exitClass = clazz;
    }

    protected ApplicationInstance getApplication() {
        return this.getApplication(Thread.currentThread(), this.getClassContext(), 0);
    }

    protected ApplicationInstance getApplication(Window window) {
        int n = this.weakWindows.size();
        while (n-- > 0) {
            Window window2 = this.weakWindows.get(n);
            if (window2 == null) {
                this.weakWindows.remove(n);
                this.weakApplications.remove(n);
            }
            if (window2 != window) continue;
            return this.weakApplications.get(n);
        }
        return null;
    }

    protected ApplicationInstance getApplication(Thread thread, Class<?>[] classArray, int n) {
        JNLPClassLoader jNLPClassLoader;
        ClassLoader classLoader;
        for (classLoader = thread.getContextClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            jNLPClassLoader = this.getJnlpClassLoader(classLoader);
            if (jNLPClassLoader == null || jNLPClassLoader.getApplication() == null) continue;
            return jNLPClassLoader.getApplication();
        }
        if (n <= 0) {
            n = classArray.length;
        }
        for (int i = 0; i < classArray.length && i < n; ++i) {
            for (classLoader = classArray[i].getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
                jNLPClassLoader = this.getJnlpClassLoader(classLoader);
                if (jNLPClassLoader == null || jNLPClassLoader.getApplication() == null) continue;
                return jNLPClassLoader.getApplication();
            }
        }
        return null;
    }

    private JNLPClassLoader getJnlpClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof JNLPClassLoader.CodeBaseClassLoader) {
            classLoader = ((JNLPClassLoader.CodeBaseClassLoader)classLoader).getParentJNLPClassLoader();
        }
        if (classLoader instanceof JNLPClassLoader) {
            JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)classLoader;
            return jNLPClassLoader;
        }
        return null;
    }

    @Override
    public ThreadGroup getThreadGroup() {
        ApplicationInstance applicationInstance = this.getApplication();
        if (applicationInstance == null) {
            return super.getThreadGroup();
        }
        return applicationInstance.getThreadGroup();
    }

    @Override
    public void checkPermission(Permission permission) {
        String string = permission.getName();
        if (!JNLPRuntime.isWebstartApplication() && ("setPolicy".equals(string) || "setSecurityManager".equals(string))) {
            throw new SecurityException(Translator.R("RCantReplaceSM"));
        }
        try {
            super.checkPermission(permission);
        }
        catch (SecurityException securityException) {
            OutputController.getLogger().log("Denying permission: " + permission);
            throw securityException;
        }
    }

    private boolean askPermission(Permission permission) {
        ApplicationInstance applicationInstance = this.getApplication();
        return applicationInstance != null && !applicationInstance.isSigned() && permission instanceof SocketPermission && ServiceUtil.checkAccess(SecurityDialogs.AccessType.NETWORK, permission.getName());
    }

    private void addPermission(Permission permission) {
        if (JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            jNLPClassLoader.addPermission(permission);
            if (JNLPRuntime.isDebug()) {
                if (jNLPClassLoader.getSecurity() == null) {
                    if (jNLPClassLoader.getPermissions(null).implies(permission)) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Added permission: " + permission.toString());
                    } else {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to add permission: " + permission.toString());
                    }
                } else {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Cannot get permissions for null codesource when classloader security is not null");
                }
            }
        } else {
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Unable to add permission: " + permission + ", classloader not JNLP.");
        }
    }

    @Override
    public boolean checkTopLevelWindow(Object object) {
        ApplicationInstance applicationInstance = this.getApplication();
        if (applicationInstance != null && object instanceof Window) {
            Window window = (Window)object;
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "SM: app: " + applicationInstance.getTitle() + " is adding a window: " + object + " with appContext " + AppContext.getAppContext());
            this.weakWindows.add(window);
            this.weakApplications.add(applicationInstance);
            applicationInstance.addWindow(window);
        }
        return super.checkTopLevelWindow(object);
    }

    @Override
    public void checkExit(int n) {
        int n2;
        Class[] classArray = this.getClassContext();
        if (!this.exitAllowed) {
            for (n2 = 0; n2 < classArray.length; ++n2) {
                if (classArray[n2].getClassLoader() == null) continue;
                throw new AccessControlException("Applets may not call System.exit()");
            }
        }
        super.checkExit(n);
        int n3 = n2 = classArray[1] == Runtime.class ? 1 : 0;
        if (this.isExitClass(classArray)) {
            return;
        }
        if (n2 == 0) {
            super.checkExit(n);
            return;
        }
        ApplicationInstance applicationInstance = this.getApplication(Thread.currentThread(), classArray, 0);
        if (applicationInstance == null) {
            throw new SecurityException(Translator.R("RExitNoApp"));
        }
        applicationInstance.destroy();
        throw this.closeAppEx;
    }

    protected void disableExit() {
        this.exitAllowed = false;
    }

    @Override
    public AppContext getAppContext() {
        ApplicationInstance applicationInstance = this.getApplication();
        if (applicationInstance == null) {
            return this.mainAppContext;
        }
        return applicationInstance.getAppContext();
    }

    @Override
    public void checkAwtEventQueueAccess() {
        super.checkAwtEventQueueAccess();
    }
}

