/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.PacEvaluator;
import net.sourceforge.jnlp.runtime.PacEvaluatorFactory;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class JNLPProxySelector
extends ProxySelector {
    public static final int PROXY_TYPE_UNKNOWN = -1;
    public static final int PROXY_TYPE_NONE = 0;
    public static final int PROXY_TYPE_MANUAL = 1;
    public static final int PROXY_TYPE_AUTO = 2;
    public static final int PROXY_TYPE_BROWSER = 3;
    public static final int FALLBACK_PROXY_PORT = 3128;
    private PacEvaluator pacEvaluator = null;
    private int proxyType = -1;
    private URL autoConfigUrl = null;
    private List<String> bypassList = null;
    private boolean bypassLocal = false;
    private boolean sameProxy = false;
    private String proxyHttpHost;
    private int proxyHttpPort;
    private String proxyHttpsHost;
    private int proxyHttpsPort;
    private String proxyFtpHost;
    private int proxyFtpPort;
    private String proxySocks4Host;
    private int proxySocks4Port;
    private String overrideHosts = null;

    public JNLPProxySelector(DeploymentConfiguration deploymentConfiguration) {
        this.parseConfiguration(deploymentConfiguration);
    }

    private void parseConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.proxyType = Integer.valueOf(deploymentConfiguration.getProperty("deployment.proxy.type"));
        String string = deploymentConfiguration.getProperty("deployment.proxy.auto.config.url");
        if (string != null) {
            try {
                this.autoConfigUrl = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
            }
        }
        if (this.autoConfigUrl != null) {
            this.pacEvaluator = PacEvaluatorFactory.getPacEvaluator(this.autoConfigUrl);
        }
        this.bypassList = new ArrayList<String>();
        String string2 = deploymentConfiguration.getProperty("deployment.proxy.bypass.list");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.trim().length() == 0) continue;
                this.bypassList.add(string3);
            }
        }
        this.bypassLocal = Boolean.valueOf(deploymentConfiguration.getProperty("deployment.proxy.bypass.local"));
        this.sameProxy = Boolean.valueOf(deploymentConfiguration.getProperty("deployment.proxy.same"));
        this.proxyHttpHost = this.getHost(deploymentConfiguration, "deployment.proxy.http.host");
        this.proxyHttpPort = this.getPort(deploymentConfiguration, "deployment.proxy.http.port");
        this.proxyHttpsHost = this.getHost(deploymentConfiguration, "deployment.proxy.https.host");
        this.proxyHttpsPort = this.getPort(deploymentConfiguration, "deployment.proxy.https.port");
        this.proxyFtpHost = this.getHost(deploymentConfiguration, "deployment.proxy.ftp.host");
        this.proxyFtpPort = this.getPort(deploymentConfiguration, "deployment.proxy.ftp.port");
        this.proxySocks4Host = this.getHost(deploymentConfiguration, "deployment.proxy.socks.host");
        this.proxySocks4Port = this.getPort(deploymentConfiguration, "deployment.proxy.socks.port");
        this.overrideHosts = deploymentConfiguration.getProperty("deployment.proxy.override.hosts");
    }

    private String getHost(DeploymentConfiguration deploymentConfiguration, String string) {
        String string2 = deploymentConfiguration.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private int getPort(DeploymentConfiguration deploymentConfiguration, String string) {
        int n = 3128;
        String string2 = deploymentConfiguration.getProperty(string);
        if (string2 != null && string2.trim().length() != 0) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, numberFormatException);
            }
        }
        return n;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, iOException);
    }

    @Override
    public List<Proxy> select(URI uRI) {
        OutputController.getLogger().log("Selecting proxy for: " + uRI);
        if (this.inBypassList(uRI)) {
            List<Proxy> list = Arrays.asList(Proxy.NO_PROXY);
            OutputController.getLogger().log("Selected proxies: " + Arrays.toString(list.toArray()));
            return list;
        }
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        switch (this.proxyType) {
            case 1: {
                arrayList.addAll(this.getFromConfiguration(uRI));
                break;
            }
            case 2: {
                arrayList.addAll(this.getFromPAC(uRI));
                break;
            }
            case 3: {
                arrayList.addAll(this.getFromBrowser(uRI));
                break;
            }
            default: {
                arrayList.add(Proxy.NO_PROXY);
            }
        }
        OutputController.getLogger().log("Selected proxies: " + Arrays.toString(arrayList.toArray()));
        return arrayList;
    }

    private boolean inBypassList(URI uRI) {
        try {
            String string = uRI.getScheme();
            if (string.equals("http") || string.equals("https") || string.equals("ftp")) {
                URL uRL = uRI.toURL();
                if (this.bypassLocal && this.isLocalHost(uRL.getHost())) {
                    return true;
                }
                if (this.bypassList.contains(uRL.getHost())) {
                    return true;
                }
            } else if (string.equals("socket")) {
                String string2 = uRI.getHost();
                if (this.bypassLocal && this.isLocalHost(string2)) {
                    return true;
                }
                if (this.bypassList.contains(string2)) {
                    return true;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return false;
    }

    private boolean isLocalHost(String string) {
        try {
            if (InetAddress.getByName(string).isLoopbackAddress()) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            if (string.equals(InetAddress.getLocalHost().getHostName())) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            if (string.equals(InetAddress.getLocalHost().getHostAddress())) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    private List<Proxy> getFromConfiguration(URI uRI) {
        return JNLPProxySelector.getFromArguments(uRI, this.sameProxy, false, this.proxyHttpsHost, this.proxyHttpsPort, this.proxyHttpHost, this.proxyHttpPort, this.proxyFtpHost, this.proxyFtpPort, this.proxySocks4Host, this.proxySocks4Port);
    }

    protected static List<Proxy> getFromArguments(URI uRI, boolean bl, boolean bl2, String string, int n, String string2, int n2, String string3, int n3, String string4, int n4) {
        InetSocketAddress inetSocketAddress;
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        String string5 = uRI.getScheme();
        boolean bl3 = false;
        if (bl) {
            if (string2 != null) {
                inetSocketAddress = new InetSocketAddress(string2, n2);
                if (string5.equals("https") || string5.equals("http") || string5.equals("ftp")) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                    arrayList.add(proxy);
                } else if (string5.equals("socket") && bl2) {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
                    arrayList.add(proxy);
                    bl3 = true;
                }
            }
        } else if (string5.equals("http") && string2 != null) {
            inetSocketAddress = new InetSocketAddress(string2, n2);
            arrayList.add(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
        } else if (string5.equals("https") && string != null) {
            inetSocketAddress = new InetSocketAddress(string, n);
            arrayList.add(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
        } else if (string5.equals("ftp") && string3 != null) {
            inetSocketAddress = new InetSocketAddress(string3, n3);
            arrayList.add(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
        }
        if (!bl3 && string4 != null) {
            inetSocketAddress = new InetSocketAddress(string4, n4);
            arrayList.add(new Proxy(Proxy.Type.SOCKS, inetSocketAddress));
            bl3 = true;
        }
        if (arrayList.size() == 0) {
            arrayList.add(Proxy.NO_PROXY);
        }
        return arrayList;
    }

    protected List<Proxy> getFromPAC(URI uRI) {
        if (this.autoConfigUrl == null || uRI.getScheme().equals("socket")) {
            return Arrays.asList(Proxy.NO_PROXY);
        }
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        try {
            String string = this.pacEvaluator.getProxies(uRI.toURL());
            arrayList.addAll(JNLPProxySelector.getProxiesFromPacResult(string));
        }
        catch (MalformedURLException malformedURLException) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, malformedURLException);
            arrayList.add(Proxy.NO_PROXY);
        }
        return arrayList;
    }

    protected abstract List<Proxy> getFromBrowser(URI var1);

    public static List<Proxy> getProxiesFromPacResult(String string) {
        String[] stringArray;
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        for (String string2 : stringArray = string.split(";")) {
            InetSocketAddress inetSocketAddress;
            int n;
            String string3;
            String string4;
            if (string2.startsWith("PROXY")) {
                string4 = string2.substring("PROXY".length()).trim();
                if (!string4.contains(":")) continue;
                string3 = string4.split(":")[0];
                try {
                    n = Integer.valueOf(string4.split(":")[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                inetSocketAddress = new InetSocketAddress(string3, n);
                arrayList.add(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
                continue;
            }
            if (string2.startsWith("SOCKS")) {
                string4 = string2.substring("SOCKS".length()).trim();
                if (!string4.contains(":")) continue;
                string3 = string4.split(":")[0];
                try {
                    n = Integer.valueOf(string4.split(":")[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                inetSocketAddress = new InetSocketAddress(string3, n);
                arrayList.add(new Proxy(Proxy.Type.SOCKS, inetSocketAddress));
                continue;
            }
            if (string2.startsWith("DIRECT")) {
                arrayList.add(Proxy.NO_PROXY);
                continue;
            }
            OutputController.getLogger().log("Unrecognized proxy token: " + string2);
        }
        return arrayList;
    }
}

