/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.URIParameter;
import java.security.cert.Certificate;
import java.util.Enumeration;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.logging.OutputController;

public class JNLPPolicy
extends Policy {
    private static CodeSource shellSource;
    private static CodeSource systemSource;
    private static Policy systemPolicy;
    private final String jreExtDir;
    private Policy systemJnlpPolicy = null;
    private Policy userJnlpPolicy = null;

    protected JNLPPolicy() {
        shellSource = JNLPPolicy.class.getProtectionDomain().getCodeSource();
        systemSource = Policy.class.getProtectionDomain().getCodeSource();
        systemPolicy = Policy.getPolicy();
        this.systemJnlpPolicy = this.getPolicyFromConfig("deployment.system.security.policy");
        this.userJnlpPolicy = this.getPolicyFromConfig("deployment.user.security.policy");
        String string = System.getProperty("java.home");
        this.jreExtDir = string + File.separator + "lib" + File.separator + "ext";
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        if (codeSource.equals(systemSource) || codeSource.equals(shellSource)) {
            return this.getAllPermissions();
        }
        if (this.isSystemJar(codeSource)) {
            return this.getAllPermissions();
        }
        if (JNLPRuntime.getApplication() != null && JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader jNLPClassLoader = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            PermissionCollection permissionCollection = jNLPClassLoader.getPermissions(codeSource);
            CodeSource codeSource2 = new CodeSource(JNLPRuntime.getApplication().getJNLPFile().getSourceLocation(), (Certificate[])null);
            Enumeration<Permission> enumeration = systemPolicy.getPermissions(codeSource2).elements();
            while (enumeration.hasMoreElements()) {
                permissionCollection.add(enumeration.nextElement());
            }
            if (this.systemJnlpPolicy != null) {
                enumeration = this.systemJnlpPolicy.getPermissions(codeSource2).elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
            if (this.userJnlpPolicy != null) {
                enumeration = this.userJnlpPolicy.getPermissions(codeSource2).elements();
                while (enumeration.hasMoreElements()) {
                    permissionCollection.add(enumeration.nextElement());
                }
            }
            return permissionCollection;
        }
        return systemPolicy.getPermissions(codeSource);
    }

    @Override
    public void refresh() {
    }

    private Permissions getAllPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }

    private boolean isSystemJar(CodeSource codeSource) {
        if (codeSource == null || codeSource.getLocation() == null) {
            return false;
        }
        String string = codeSource.getLocation().getProtocol();
        String string2 = codeSource.getLocation().getPath();
        return string.toUpperCase().equals("FILE") && string2.startsWith(this.jreExtDir);
    }

    private Policy getPolicyFromConfig(String string) {
        Policy policy = null;
        String string2 = null;
        DeploymentConfiguration deploymentConfiguration = JNLPRuntime.getConfiguration();
        string2 = deploymentConfiguration.getProperty(string);
        if (string2 != null) {
            try {
                URI uRI = new URI(string2);
                policy = JNLPPolicy.getInstance("JavaPolicy", new URIParameter(uRI));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, illegalArgumentException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, noSuchAlgorithmException);
            }
            catch (URISyntaxException uRISyntaxException) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, uRISyntaxException);
            }
        }
        return policy;
    }

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection = this.getPermissions(protectionDomain.getCodeSource());
        return super.implies(protectionDomain, permission) || permissionCollection.implies(permission);
    }
}

