/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.applet.AudioClip;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import net.sourceforge.jnlp.util.logging.OutputController;

public class AppletAudioClip
implements AudioClip {
    private Clip clip;

    public AppletAudioClip(URL uRL) {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            this.clip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
            this.clip.open(audioInputStream);
        }
        catch (Exception exception) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Error loading sound:" + uRL.toString());
            OutputController.getLogger().log(exception);
            this.clip = null;
        }
    }

    @Override
    public void loop() {
        if (this.clip == null) {
            return;
        }
        this.clip.loop(-1);
    }

    @Override
    public void play() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
        this.clip.setFramePosition(0);
        this.clip.start();
    }

    @Override
    public void stop() {
        if (this.clip == null) {
            return;
        }
        this.clip.stop();
    }

    void dispose() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.flush();
            this.clip.close();
        }
        this.clip = null;
    }
}

