/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.jnlp.JNLPMatcherException;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.nanoxml.XMLElement;

public final class JNLPMatcher {
    private final Node appTemplateNode;
    private final Node launchJNLPNode;
    private final boolean isTemplate;

    public JNLPMatcher(Reader reader, Reader reader2, boolean bl) throws JNLPMatcherException {
        if (reader == null && reader2 == null) {
            throw new JNLPMatcherException("Template JNLP file and Launching JNLP file are both null.");
        }
        if (reader == null) {
            throw new JNLPMatcherException("Template JNLP file is null.");
        }
        if (reader2 == null) {
            throw new JNLPMatcherException("Launching JNLP file is null.");
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = null;
        try {
            XMLElement xMLElement = new XMLElement();
            XMLElement xMLElement2 = new XMLElement();
            byteArrayOutputStream = new ByteArrayOutputStream();
            xMLElement.sanitizeInput(reader, byteArrayOutputStream);
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            xMLElement2.sanitizeInput(reader2, byteArrayOutputStream2);
            xMLElement.parseFromReader(new StringReader(byteArrayOutputStream.toString()));
            xMLElement2.parseFromReader(new StringReader(byteArrayOutputStream2.toString()));
            this.appTemplateNode = new Node(xMLElement);
            this.launchJNLPNode = new Node(xMLElement2);
            this.isTemplate = bl;
            this.closeOutputStream(byteArrayOutputStream);
            this.closeOutputStream(byteArrayOutputStream2);
        }
        catch (Exception exception) {
            try {
                throw new JNLPMatcherException("Failed to create an instance of JNLPVerify with specified InputStreamReader", exception);
            }
            catch (Throwable throwable) {
                this.closeOutputStream(byteArrayOutputStream);
                this.closeOutputStream(byteArrayOutputStream2);
                throw throwable;
            }
        }
    }

    public boolean isMatch() {
        return this.matchNodes(this.appTemplateNode, this.launchJNLPNode);
    }

    private boolean matchNodes(Node node, Node node2) {
        if (node != null && node2 != null) {
            Node node3 = node;
            Node node4 = node2;
            LinkedList<Node> linkedList = new LinkedList<Node>(Arrays.asList(node3.getChildNodes()));
            LinkedList<Node> linkedList2 = new LinkedList<Node>(Arrays.asList(node4.getChildNodes()));
            if (node3.getNodeName().equals(node4.getNodeName()) && linkedList.size() == linkedList2.size()) {
                int n = linkedList.size();
                int n2 = 0;
                block0: while (n2 < n) {
                    for (int i = 0; i < n; ++i) {
                        boolean bl = this.matchNodes((Node)linkedList.get(n2), (Node)linkedList2.get(i));
                        if (!bl && i == n - 1) {
                            return false;
                        }
                        if (!bl) continue;
                        linkedList.remove(n2);
                        linkedList2.remove(i);
                        --n;
                        continue block0;
                    }
                }
                if (!node3.getNodeValue().equals(node4.getNodeValue())) {
                    if (this.isTemplate && !node3.getNodeValue().equals("*")) {
                        return false;
                    }
                    if (!this.isTemplate) {
                        return false;
                    }
                }
                return this.matchAttributes(node3, node4);
            }
        }
        return false;
    }

    private boolean matchAttributes(Node node, Node node2) {
        if (node != null && node2 != null) {
            List<String> list = node.getAttributeNames();
            List<String> list2 = node2.getAttributeNames();
            Collections.sort(list);
            Collections.sort(list2);
            if (list.size() == list2.size()) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (list2.get(i).equals(list.get(i))) {
                        String string = list2.get(i);
                        boolean bl = node.getAttribute(string).equals(node2.getAttribute(string));
                        if (!this.isTemplate && !bl) {
                            return false;
                        }
                        if (!this.isTemplate || bl || node.getAttribute(string).equals("*")) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
    }

    private void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, exception);
            }
        }
    }
}

